/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.jira;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.bamboo.event.ResultsSummaryUpdatedEvent;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueLinkType;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssueImpl;
import com.atlassian.bamboo.jira.rest.JiraRestService;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.ww2.actions.jira.AbstractCreateNewJiraIssueAction;
import com.atlassian.event.api.EventPublisher;
import com.google.common.collect.Sets;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class CreateNewJiraIssueForBuildResultAction
extends AbstractCreateNewJiraIssueAction {
    public static final String NEW_ISSUE_KEY_PARAM = "newIssueKey";
    @Autowired
    private EventPublisher eventPublisher;
    @Autowired
    private JiraRestService jiraRestService;
    @Autowired
    private ResultsSummaryManager resultsSummaryManager;

    @Override
    @NotNull
    protected JSONObject buildJsonObject() throws JSONException {
        JSONObject result = super.buildJsonObject();
        if (this.credentialsRequiredUrl == null && !this.hasActionErrors() && this.newIssueKey != null) {
            result.put(NEW_ISSUE_KEY_PARAM, (Object)this.newIssueKey);
        }
        return result;
    }

    @Override
    public String execute() throws Exception {
        String result = super.execute();
        if (!"success".equals(result)) {
            return result;
        }
        ResultsSummary resultsSummary = this.getResultsSummary();
        LinkedJiraIssueImpl issue = new LinkedJiraIssueImpl();
        issue.setIssueKey(this.newIssueKey.toUpperCase());
        issue.setResultsSummary(resultsSummary);
        issue.setIssueType(JiraIssueLinkType.BUILD_CAUSES);
        resultsSummary.getJiraIssues().add(issue);
        this.resultsSummaryManager.saveResultSummary(resultsSummary);
        this.eventPublisher.publish((Object)new ResultsSummaryUpdatedEvent((Object)this, resultsSummary.getPlanResultKey(), (Set)Sets.newHashSet((Object[])new String[]{this.newIssueKey})));
        return result;
    }

    @Override
    protected JSONObject createIssueLinkData(@NotNull ApplicationLink applicationLink, @NotNull String issueKey, @NotNull ResultsSummary resultsSummary) throws Exception {
        return this.jiraRestService.getRemoteIssueLinkJson("planResultKey=" + resultsSummary.getPlanResultKey(), this.getBuildPlanResultName(resultsSummary), resultsSummary.getPlanResultKey().toString(), "Created from build", "/browse/" + resultsSummary.getPlanResultKey(), applicationLink.getRpcUrl() + this.convertBuildStateToIconFileName(resultsSummary));
    }
}

