/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.jira;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.bamboo.applinks.JiraApplinksService;
import com.atlassian.bamboo.jira.rest.Errors;
import com.atlassian.bamboo.jira.rest.JiraRestResponse;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class AbstractJiraIssueAction
extends BambooActionSupport {
    private static final Logger log = Logger.getLogger(AbstractJiraIssueAction.class);
    private static int JIRA_50_BUILDNUMBER = 713;
    @Autowired
    protected JiraApplinksService jiraApplinksService;
    protected PlanResultKey planResultKey;
    private String appLinkId;

    public List<ApplicationLink> getJiraServers() {
        return Lists.newArrayList((Iterable)this.jiraApplinksService.getJiraApplicationLinks());
    }

    protected ApplicationLink getSelectedJiraApplicationLink() {
        return this.getJiraServers().stream().filter(applicationLink -> applicationLink.getId().equals((Object)new ApplicationId(this.getAppLinkId()))).findFirst().orElseThrow(NoSuchElementException::new);
    }

    public PlanResultKey getPlanResultKey() {
        return this.planResultKey;
    }

    public void setPlanResultKey(String planResultKey) {
        this.planResultKey = PlanKeys.getPlanResultKey((String)planResultKey);
    }

    public void setAppLinkId(String appLinkId) {
        this.appLinkId = appLinkId;
    }

    public String getAppLinkId() {
        return this.appLinkId;
    }

    protected void copyErrorsToAction(JiraRestResponse response) {
        this.copyErrorsToAction(response, Collections.emptySet());
    }

    protected void copyErrorsToAction(@NotNull JiraRestResponse response, @NotNull Set<String> knownFields) {
        Errors errors = response.errors;
        if (errors != null) {
            this.addErrorMessages(errors.errorMessages);
            for (Map.Entry entry : errors.errors.entrySet()) {
                if (knownFields.contains(entry.getKey())) {
                    this.addFieldError((String)entry.getKey(), (String)entry.getValue());
                    continue;
                }
                this.addActionError((String)entry.getKey() + ": " + (String)entry.getValue());
            }
        }
    }

    protected void copyErrorsToActionWarnings(@NotNull JiraRestResponse response) {
        Errors errors = response.errors;
        if (errors == null) {
            return;
        }
        errors.errorMessages.forEach(this::addActionWarning);
        for (Map.Entry entry : errors.errors.entrySet()) {
            this.addActionWarning((String)entry.getKey() + ": " + (String)entry.getValue());
        }
    }
}

