/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.jira;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.bamboo.jira.rest.JiraRestResponse;
import com.atlassian.bamboo.jira.rest.JiraRestService;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.ww2.actions.jira.AbstractJiraIssueAction;
import com.atlassian.sal.api.net.Request;
import com.atlassian.user.User;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.opensymphony.webwork.dispatcher.json.JSONArray;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractCreateNewJiraIssueAction
extends AbstractJiraIssueAction {
    private static final Logger log = Logger.getLogger(AbstractCreateNewJiraIssueAction.class);
    public static final String APPLICATION_LINK_ID_JSON_KEY = "applicationLinkId";
    public static final String PROJECT_JSON_KEY = "project";
    public static final String ISSUETYPE_JSON_KEY = "issuetype";
    private Set<String> knownFields = ImmutableSet.of((Object)"summary", (Object)"description", (Object)"issuetype", (Object)"project", (Object)"components", (Object)"versions", (Object[])new String[0]);
    @Autowired
    private JiraRestService jiraRestService;
    @Autowired
    private ResultsSummaryManager resultsSummaryManager;
    private String summary;
    private String description;
    private String issueType;
    private String project;
    private List<Long> components = Collections.emptyList();
    private List<Long> versions = Collections.emptyList();
    private ResultsSummary resultsSummary;
    protected URI credentialsRequiredUrl;
    protected String newIssueKey;

    @Override
    @NotNull
    protected JSONObject buildJsonObject() throws JSONException {
        JSONObject result = super.buildJsonObject();
        if (this.credentialsRequiredUrl != null) {
            result.put("redirectUrl", (Object)this.credentialsRequiredUrl);
        }
        return result;
    }

    public String input() throws Exception {
        String jsonString;
        User user = this.getUser();
        if (user != null && this.getAppLinkId() == null && (jsonString = this.bambooUserManager.getJiraIssueDefaults(user)) != null) {
            try {
                JSONObject defaults = new JSONObject(jsonString);
                String applicationLinkId = defaults.getString(APPLICATION_LINK_ID_JSON_KEY);
                if (applicationLinkId != null) {
                    this.setAppLinkId(applicationLinkId);
                    String project = defaults.getString(PROJECT_JSON_KEY);
                    if (project != null) {
                        this.project = project;
                        String issueType = defaults.getString(ISSUETYPE_JSON_KEY);
                        if (issueType != null) {
                            this.issueType = issueType;
                        }
                    }
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return "input";
    }

    public String execute() throws Exception {
        JiraRestResponse response;
        ApplicationLink applicationLink = this.getSelectedJiraApplicationLink();
        if (applicationLink == null) {
            this.addActionError("Unable to find application link for the supplied parameters.");
            return "error";
        }
        JSONObject issueFieldsJson = new JSONObject().put(PROJECT_JSON_KEY, (Object)new JSONObject().put("id", (Object)this.project)).put("summary", (Object)this.summary).put("description", (Object)this.description).put(ISSUETYPE_JSON_KEY, (Object)new JSONObject().put("id", (Object)this.issueType));
        if (!this.versions.isEmpty()) {
            JSONArray versionArray = this.idListToJSONArray(this.versions);
            issueFieldsJson.put("versions", (Object)versionArray);
        }
        if (!this.components.isEmpty()) {
            JSONArray componentArray = this.idListToJSONArray(this.components);
            issueFieldsJson.put("components", (Object)componentArray);
        }
        if ((response = this.jiraRestService.doRestCallViaApplink(applicationLink, "rest/api/latest/issue", Request.MethodType.POST, new JSONObject().put("fields", (Object)issueFieldsJson))).hasErrors()) {
            this.copyErrorsToAction(response, this.knownFields);
            return "error";
        }
        if (this.getResultsSummary() == null) {
            String errorMsg = "Error while fetching issue information from Jira, no planResultKey specified.";
            this.addActionError("Error while fetching issue information from Jira, no planResultKey specified.");
            log.error((Object)"Error while fetching issue information from Jira, no planResultKey specified.");
            return "error";
        }
        JSONObject responseEntity = response.entity;
        if (responseEntity != null && responseEntity.has("key")) {
            this.newIssueKey = responseEntity.getString("key");
            this.addActionMessage(this.getText("jira.create.success", Lists.newArrayList((Object[])new String[]{this.buildIssueLink(applicationLink, this.newIssueKey)})));
            this.addIssueLinkFromJiraIssueToThisBuildResult(applicationLink, this.newIssueKey, this.resultsSummary);
            this.modifyReturnUrl(this.newIssueKey);
            this.saveDefaults();
            return "success";
        }
        this.addActionError("Could not determine which issue was created.");
        return "error";
    }

    private String buildIssueLink(ApplicationLink applicationLink, String newIssueKey) {
        String url = applicationLink.getDisplayUrl() + "/browse/" + newIssueKey;
        return "<a id='createdIssue' href='" + url + "'>" + newIssueKey + "</a>";
    }

    private void saveDefaults() {
        User user = this.getUser();
        if (user != null) {
            try {
                JSONObject jsonObject = new JSONObject().put(APPLICATION_LINK_ID_JSON_KEY, (Object)this.getAppLinkId()).put(PROJECT_JSON_KEY, (Object)this.project).put(ISSUETYPE_JSON_KEY, (Object)this.issueType);
                this.bambooUserManager.saveJiraIssueDefaults(user, jsonObject.toString());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    private void modifyReturnUrl(String newIssueKey) {
        String url = this.getReturnUrl();
        if (url.contains("newIssueKey")) {
            url = url.substring(0, url.indexOf("&newIssueKey"));
        }
        url = url + "&newIssueKey=" + newIssueKey;
        this.setReturnUrl(url);
    }

    protected abstract JSONObject createIssueLinkData(@NotNull ApplicationLink var1, @NotNull String var2, @NotNull ResultsSummary var3) throws Exception;

    protected void addIssueLinkFromJiraIssueToThisBuildResult(@NotNull ApplicationLink applicationLink, @NotNull String issueKey, @NotNull ResultsSummary resultsSummary) throws Exception {
        JSONObject issueLinkData = this.createIssueLinkData(applicationLink, issueKey, resultsSummary);
        JiraRestResponse response = this.jiraRestService.doRestCallViaApplink(applicationLink, "rest/api/latest/issue/" + issueKey + "/remotelink", Request.MethodType.POST, issueLinkData);
        if (response.hasErrors()) {
            this.addActionWarning("Failed to link created Issue from Jira back to Bamboo");
            this.copyErrorsToActionWarnings(response);
        }
    }

    private JSONArray idListToJSONArray(List<Long> list) throws JSONException {
        JSONArray jsonArray = new JSONArray();
        for (Long id : list) {
            jsonArray.put((Object)new JSONObject().put("id", (Object)id.toString()));
        }
        return jsonArray;
    }

    protected String getBuildPlanResultName(ResultsSummary buildSummary) {
        ImmutablePlan plan = buildSummary.getImmutablePlan();
        ImmutablePlan master = plan.getMaster();
        if (master != null) {
            return plan.getProject().getName() + " \u203a " + master.getBuildName() + " \u203a " + plan.getBuildName() + " \u203a #" + buildSummary.getBuildNumber();
        }
        return plan.getProject().getName() + " \u203a " + plan.getBuildName() + " \u203a #" + buildSummary.getBuildNumber();
    }

    protected String convertBuildStateToIconFileName(@NotNull ResultsSummary resultsSummary) {
        String buildStatusIcon = "";
        switch (resultsSummary.getBuildState()) {
            case SUCCESS: {
                buildStatusIcon = "successful";
                break;
            }
            case FAILED: {
                buildStatusIcon = "failed";
                break;
            }
            case UNKNOWN: {
                buildStatusIcon = "canceled";
            }
        }
        return "/download/resources/com.atlassian.jira.plugin.ext.bamboo:bamboo-version-tabpanel/images/iconsv3/plan_" + buildStatusIcon + "_16.png";
    }

    protected ResultsSummary getResultsSummary() {
        if (this.resultsSummary == null && this.getPlanResultKey() != null) {
            this.resultsSummary = this.resultsSummaryManager.getResultsSummary(this.getPlanResultKey());
        }
        return this.resultsSummary;
    }

    public String getCredentialsRequiredUrl() {
        return this.credentialsRequiredUrl.toString();
    }

    public List<String> getJiraProjects() {
        return Collections.emptyList();
    }

    public List<String> getJiraIssueTypes() {
        return Collections.emptyList();
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getIssuetype() {
        return this.issueType;
    }

    public void setIssuetype(String issueType) {
        this.issueType = issueType;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public List<Long> getComponents() {
        return this.components;
    }

    public void setComponents(List<String> components) {
        this.components = components != null ? Lists.newArrayList((Iterable)Iterables.transform(components, Long::valueOf)) : Collections.emptyList();
    }

    public List<Long> getVersions() {
        return this.versions;
    }

    public void setVersions(List<String> versions) {
        this.versions = versions != null ? Lists.newArrayList((Iterable)Iterables.transform(versions, Long::valueOf)) : Collections.emptyList();
    }
}

