/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.error;

import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.actions.error.ExceptionTranslator;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalBypassSecurityAware;
import com.opensymphony.xwork2.ActionContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.jetbrains.annotations.Nullable;

public class FiveOhOh
extends BambooActionSupport
implements GlobalBypassSecurityAware {
    private static final Logger log = Logger.getLogger(FiveOhOh.class);
    private String stackTrace;
    private boolean showStackTrace = SystemProperty.SHOW_STACK_TRACES_ON_500.getValue(true);
    private ExceptionTranslator exceptionTranslator;

    public String execute() throws Exception {
        HttpServletResponse response = ServletActionContext.getResponse();
        response.setStatus(500);
        Throwable fiveOhOhException = (Throwable)ServletActionContext.getRequest().getAttribute("javax.servlet.error.exception");
        if (fiveOhOhException == null) {
            fiveOhOhException = (Throwable)ActionContext.getContext().getValueStack().findValue("exception", Throwable.class);
        }
        if (this.exceptionTranslator != null) {
            this.exceptionTranslator.translateException(fiveOhOhException);
        }
        if (this.showStackTrace || BuildUtils.isDevMode() && !BuildUtils.isFunctionalTest()) {
            this.stackTrace = ExceptionUtils.getStackTrace((Throwable)fiveOhOhException);
        } else {
            log.info((Object)"Stack trace was hidden on the error page since -Dbamboo.show.internal.server.error.stacks property is false");
        }
        log.error((Object)"500 Exception was thrown.", fiveOhOhException);
        return "error";
    }

    @Nullable
    public String getStackTrace() {
        return this.stackTrace;
    }

    public void setShowStackTrace(boolean showStackTrace) {
        this.showStackTrace = showStackTrace;
    }

    public ExceptionTranslator getExceptionTranslator() {
        return this.exceptionTranslator;
    }

    public void setExceptionTranslator(ExceptionTranslator exceptionTranslator) {
        this.exceptionTranslator = exceptionTranslator;
    }
}

