/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.error;

import com.atlassian.bamboo.logger.AdminErrorHandler;
import com.atlassian.bamboo.ww2.actions.error.ExceptionHandler;
import com.atlassian.bamboo.ww2.actions.error.ExceptionTranslator;
import com.atlassian.bamboo.ww2.actions.error.IOExceptionHandler;
import com.atlassian.spring.container.ContainerManager;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ExceptionTranslatorImpl
implements ExceptionTranslator {
    static final ExceptionHandler[] availableHandlers = new ExceptionHandler[]{new IOExceptionHandler()};
    private AdminErrorHandler adminErrorHandler;

    @Override
    public void translateException(Throwable throwable) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)throwable);
        if (rootCause == null) {
            rootCause = throwable;
        }
        block0: for (ExceptionHandler exceptionHandler : availableHandlers) {
            Class<? extends Throwable>[] supportedExceptions = exceptionHandler.getHandledExceptions();
            if (supportedExceptions == null) continue;
            for (Class<? extends Throwable> supportedException : supportedExceptions) {
                if (!supportedException.isInstance(rootCause)) continue;
                String message = exceptionHandler.parseError(rootCause);
                if (message == null) continue block0;
                this.getAdminErrorHandler().recordError(message, message);
                continue block0;
            }
        }
    }

    public AdminErrorHandler getAdminErrorHandler() {
        if (this.adminErrorHandler == null) {
            this.adminErrorHandler = (AdminErrorHandler)ContainerManager.getComponent((String)"adminErrorHandler");
        }
        return this.adminErrorHandler;
    }

    public void setAdminErrorHandler(AdminErrorHandler adminErrorHandler) {
        this.adminErrorHandler = adminErrorHandler;
    }
}

