/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.error;

import com.atlassian.bamboo.user.authentication.BambooElevatedSecurityGuard;
import com.atlassian.bamboo.web.utils.JohnsonEventContainerHolder;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalBypassSecurityAware;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.http.entity.ContentType;
import org.apache.struts2.ServletActionContext;

public class ErrorAction
extends BambooActionSupport
implements GlobalBypassSecurityAware {
    private Collection<Event> events = Collections.emptyList();
    private int statusCode = 500;
    private boolean restSupported = false;
    private String errorMessage;

    public String execute() throws Exception {
        JohnsonEventContainer appEventContainer;
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        response.setStatus(this.statusCode);
        if (this.statusCode == 403 && BambooElevatedSecurityGuard.isElevatedSecurityFailed((ServletRequest)request)) {
            this.restSupported = true;
        }
        if (this.restSupported) {
            String contentType = (String)ObjectUtils.firstNonNull((Object[])new String[]{response.getContentType(), request.getContentType()});
            if (ContentType.APPLICATION_JSON.getMimeType().equals(contentType)) {
                return "error-rest-json";
            }
            if (ContentType.APPLICATION_XML.getMimeType().equals(contentType)) {
                return "error-rest-xml";
            }
        }
        if ((appEventContainer = JohnsonEventContainerHolder.get((ServletContext)ServletActionContext.getServletContext())) != null && appEventContainer.hasEvents()) {
            this.events = appEventContainer.getEvents();
        }
        this.errorMessage = Optional.ofNullable((Throwable)ServletActionContext.getRequest().getAttribute("javax.servlet.error.exception")).map(Throwable::getMessage).orElse("");
        return "error";
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public void setRestSupported(boolean restSupported) {
        this.restSupported = restSupported;
    }

    public Collection<Event> getEvents() {
        return this.events;
    }

    public String getExceptionMessage() {
        return this.errorMessage;
    }
}

