/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.comment;

import com.atlassian.bamboo.build.PlanResultsAction;
import com.atlassian.bamboo.comment.Comment;
import com.atlassian.bamboo.comment.CommentService;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.exception.AccessDeniedException;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueUtils;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.user.gravatar.GravatarService;
import com.atlassian.bamboo.util.HtmlUtils;
import com.atlassian.bamboo.utils.DurationUtils;
import com.atlassian.user.User;
import com.google.common.base.Preconditions;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.util.Date;
import org.acegisecurity.acls.Permission;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class EditCommentAction
extends PlanResultsAction {
    private static final Logger log = Logger.getLogger(EditCommentAction.class);
    private static final int AVATAR_SIZE = 32;
    String commentContent;
    long commentId;
    protected Comment comment;
    private CommentService commentService;
    private GravatarService gravatarService;
    private JiraIssueUtils jiraIssueUtils;

    @Override
    @NotNull
    public JSONObject getJsonObject() throws JSONException {
        JSONObject jsonObject = this.buildJsonObject();
        if (this.comment != null) {
            ResultsSummary result = (ResultsSummary)Preconditions.checkNotNull((Object)this.resultsSummaryManager.getResultsSummary(this.comment.getEntityId()), (Object)("Expecting comment of id " + this.comment.getId() + " to reference result summary with id " + this.comment.getEntityId()));
            JSONObject jsonCommentObject = new JSONObject();
            jsonCommentObject.put("id", this.comment.getId());
            jsonCommentObject.put("comment", (Object)this.jiraIssueUtils.getRenderedString(HtmlUtils.getTextAsHtml((Object)this.comment.getContent().trim()), (ImmutableResultsSummary)result));
            jsonCommentObject.put("lastModificationDate", (Object)this.comment.getLastModificationDate());
            jsonCommentObject.put("prettyLastModificationDate", (Object)DurationUtils.getRelativeDate((Date)this.comment.getLastModificationDate()));
            User user = this.comment.getUser();
            if (user != null) {
                BambooUser bambooUser = this.bambooUserManager.getBambooUser(user);
                String gravatarUrl = this.gravatarService.getDefaultGravatarUrl(32);
                if (bambooUser != null) {
                    gravatarUrl = this.gravatarService.getGravatarUrl(bambooUser.getEmail(), 32);
                }
                jsonCommentObject.put("avatar", (Object)gravatarUrl);
                JSONObject userObj = new JSONObject();
                userObj.put("name", (Object)user.getName());
                jsonCommentObject.put("user", (Object)userObj);
                jsonCommentObject.put("userDisplayName", (Object)(user.getFullName() != null ? user.getFullName() : user.getName()));
            }
            JSONObject jsonResultObject = new JSONObject();
            jsonResultObject.put("buildKey", (Object)result.getPlanKey().toString());
            jsonResultObject.put("buildNumber", result.getBuildNumber());
            jsonCommentObject.put("result", (Object)jsonResultObject);
            jsonCommentObject.put("showOperations", this.featureManager.isRemovingLabelsAndCommentsAllowedForNonPlanAdmin() || this.bambooPermissionManager.hasPlanPermission((Permission)BambooPermission.WRITE, this.getImmutablePlan().getPlanKey()));
            jsonObject.put("comment", (Object)jsonCommentObject);
        }
        return jsonObject;
    }

    public String doBrowse() throws Exception {
        if (this.getResultsSummary() == null) {
            this.addActionError("Can not find result summary");
            return "error";
        }
        return "success";
    }

    public String create() {
        if (this.getResultsSummary() == null) {
            this.addActionError("Can not add comment, cannot retrieve build result summary");
            return "error";
        }
        if (StringUtils.isBlank((CharSequence)this.getCommentContent().trim())) {
            this.addActionError("Can not add empty comment.");
            return "error";
        }
        try {
            this.comment = this.commentService.addComment(this.getCommentContent(), this.getUser(), (BambooIdProvider)this.getResultsSummary());
        }
        catch (AccessDeniedException e) {
            this.addActionError(e.getMessage());
            return "error";
        }
        return "success";
    }

    public String delete() {
        ImmutablePlan plan = this.getImmutablePlan();
        if (this.featureManager.isRemovingLabelsAndCommentsAllowedForNonPlanAdmin()) {
            if (!this.bambooPermissionManager.hasPlanPermission((Permission)BambooPermission.READ, plan.getPlanKey())) {
                this.addActionError("Can not delete comment. You need read permission to plan " + plan.getName());
                return "error";
            }
        } else if (!this.bambooPermissionManager.hasPlanPermission((Permission)BambooPermission.WRITE, plan.getPlanKey())) {
            this.addActionError("Can not delete comment. You need edit permission to plan " + plan.getName());
            return "error";
        }
        if (this.getResultsSummary() == null) {
            this.addActionError("Can not delete comment, cannot retrieve build result summary");
            return "error";
        }
        this.comment = this.commentService.getCommentById(this.commentId);
        if (this.comment == null) {
            this.addActionError("Can not delete comment, no comment with id: " + this.commentId + " could be found");
            return "error";
        }
        this.commentService.deleteComment(this.comment, this.getResultsSummary());
        return "success";
    }

    public String getCommentContent() {
        return this.commentContent;
    }

    public void setCommentContent(String commentContent) {
        this.commentContent = commentContent;
    }

    public void setCommentId(long commentId) {
        this.commentId = commentId;
    }

    public Comment getComment() {
        return this.comment;
    }

    public void setComment(Comment comment) {
        this.comment = comment;
    }

    public void setCommentService(CommentService commentService) {
        this.commentService = commentService;
    }

    public void setGravatarService(GravatarService gravatarService) {
        this.gravatarService = gravatarService;
    }

    @Override
    public void setJiraIssueUtils(JiraIssueUtils jiraIssueUtils) {
        this.jiraIssueUtils = jiraIssueUtils;
    }
}

