/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.charts;

import com.atlassian.bamboo.charts.ChartManager;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jfree.data.xy.XYDataset;

public class ViewReportChart
extends BambooActionSupport {
    private static final Logger log = Logger.getLogger(ViewReportChart.class);
    private ChartManager chartManager;
    private Map<String, Object> chart;
    private XYDataset dataset;
    private String reportKey;

    public Map<String, Object> getChart() {
        if (this.chart == null) {
            String key = this.getReportKey();
            if (!StringUtils.isEmpty((CharSequence)key) && this.dataset != null) {
                log.trace((Object)String.format("Getting chart data for report key '%s', number of series: '%d'", this.reportKey, this.dataset.getSeriesCount()));
                this.chart = this.chartManager.getReportData(this.dataset, this.reportKey);
            } else {
                log.warn((Object)("Unable to generate chart: [" + key + "], dataset: [" + this.dataset + "]"));
            }
        }
        return this.chart;
    }

    public XYDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(XYDataset dataset) {
        this.dataset = dataset;
    }

    public String getReportKey() {
        return this.reportKey;
    }

    public void setReportKey(String reportKey) {
        this.reportKey = reportKey;
    }

    public void setChartManager(ChartManager chartManager) {
        this.chartManager = chartManager;
    }
}

