/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.charts;

import com.atlassian.bamboo.build.FilterController;
import com.atlassian.bamboo.charts.CombinedBuildSummaryByTimeChart;
import com.atlassian.bamboo.resultsummary.ResultStatisticsProvider;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.ww2.actions.BuildActionSupport;
import com.atlassian.bamboo.ww2.aware.ResultsListAware;
import com.atlassian.bamboo.ww2.aware.permissions.PlanReadSecurityAware;
import com.atlassian.core.i18n.I18nTextProvider;
import com.atlassian.xwork.ParameterSafe;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public class ViewCombinedByTimePeriodChart
extends BuildActionSupport
implements ResultsListAware,
PlanReadSecurityAware {
    public static final String BUILD_GROUP_BY = "bamboo.build.groupby.type";
    public static final String AUTO = "AUTO";
    private static final Logger log = Logger.getLogger(ViewCombinedByTimePeriodChart.class);
    private FilterController filterController;
    private List<ResultsSummary> buildResultsList;
    private Map<String, Object> combinedByTimeChart;
    private String groupSuccessFailureChartBy;
    private int height = 320;
    private int width = 400;

    public List<ResultsSummary> getResultsList() {
        return this.buildResultsList;
    }

    @Override
    public void setResultsList(List<? extends ResultsSummary> results) {
        this.buildResultsList = new ArrayList<ResultsSummary>(results);
    }

    @ParameterSafe
    public FilterController getFilterController() {
        return this.filterController;
    }

    public void setFilterController(FilterController filterController) {
        this.filterController = filterController;
    }

    public String getGroupSuccessFailureChartBy() {
        if (this.groupSuccessFailureChartBy == null) {
            String valueFromCookie = this.filterController.getValueFromCookie(BUILD_GROUP_BY);
            if (StringUtils.isNotBlank((CharSequence)valueFromCookie)) {
                this.groupSuccessFailureChartBy = valueFromCookie;
            } else {
                this.filterController.saveValueInCookie(BUILD_GROUP_BY, AUTO);
                this.groupSuccessFailureChartBy = AUTO;
            }
        }
        return this.groupSuccessFailureChartBy;
    }

    @Nullable
    public String getAutoPeriod() {
        List<ResultsSummary> resultsList = this.getResultsList();
        if (resultsList != null && !resultsList.isEmpty()) {
            ResultStatisticsProvider last = (ResultStatisticsProvider)resultsList.get(0);
            ResultStatisticsProvider first = (ResultStatisticsProvider)resultsList.get(resultsList.size() - 1);
            Date startDate = first.getStatDate();
            Date lastDate = last.getStatDate();
            return this.getAutoDate(startDate, lastDate);
        }
        return null;
    }

    String getAutoDate(Date startDate, Date lastDate) {
        DateTime start = new DateTime((Object)startDate);
        Interval threeMonths = new Interval((ReadableInstant)start, (ReadablePeriod)Period.months((int)3));
        Interval threeWeeks = new Interval((ReadableInstant)start, (ReadablePeriod)Period.weeks((int)3));
        if (!threeMonths.contains(lastDate.getTime())) {
            return "MONTH";
        }
        if (!threeWeeks.contains(lastDate.getTime())) {
            return "WEEK";
        }
        return "DAY";
    }

    public void setGroupSuccessFailureChartBy(String groupSuccessFailureChartBy) {
        this.filterController.saveValueInCookie(BUILD_GROUP_BY, groupSuccessFailureChartBy);
        this.groupSuccessFailureChartBy = groupSuccessFailureChartBy;
    }

    @Nullable
    public Map<String, Object> getCombinedByTimeChart() {
        if (this.combinedByTimeChart == null && this.buildResultsList != null) {
            List sortedResultsList = Comparators.getBuildDateOrdering().sortedCopy(this.buildResultsList);
            String groupSuccessFailureChartBy = this.getGroupSuccessFailureChartBy();
            if (AUTO.equals(groupSuccessFailureChartBy)) {
                groupSuccessFailureChartBy = this.getAutoPeriod();
            }
            CombinedBuildSummaryByTimeChart chart = new CombinedBuildSummaryByTimeChart(this.height, this.width, groupSuccessFailureChartBy, sortedResultsList, (I18nTextProvider)this);
            this.combinedByTimeChart = chart.generateChartParams();
        }
        return this.combinedByTimeChart;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }
}

