/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.charts;

import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.ww2.actions.BuildActionSupport;
import com.atlassian.bamboo.ww2.aware.ResultsListAware;
import com.atlassian.bamboo.ww2.aware.permissions.PlanReadSecurityAware;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ViewBuildNumberChart
extends BuildActionSupport
implements ResultsListAware,
PlanReadSecurityAware {
    private static final Logger log = Logger.getLogger(ViewBuildNumberChart.class);
    private List<ResultsSummary> resultsList;

    @Override
    @NotNull
    public JSONObject getJsonObject() throws JSONException {
        JSONObject json = super.getJsonObject();
        List sortedResultsList = Comparators.getResultsSummaryNumberOrdering().sortedCopy(this.resultsList);
        JSONObject results = new JSONObject();
        ArrayList failed = new ArrayList();
        ArrayList successful = new ArrayList();
        for (ResultsSummary result : sortedResultsList) {
            ArrayList<Long> data = new ArrayList<Long>();
            data.add(Long.valueOf(result.getBuildNumber()));
            data.add(result.getProcessingDuration());
            if (result.getBuildState() == BuildState.SUCCESS) {
                successful.add(data);
                continue;
            }
            if (result.getBuildState() != BuildState.FAILED) continue;
            failed.add(data);
        }
        results.put("failed", failed);
        results.put("successful", successful);
        return json.put("results", (Object)results);
    }

    public List<ResultsSummary> getResultsList() {
        return this.resultsList;
    }

    @Override
    public void setResultsList(List<? extends ResultsSummary> results) {
        this.resultsList = new ArrayList<ResultsSummary>(results);
    }
}

