/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.chains.admin.triggers;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.deployments.projects.service.DeploymentProjectService;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.struts.OgnlStackUtils;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.trigger.TriggerConfigurator;
import com.atlassian.bamboo.trigger.TriggerDefinition;
import com.atlassian.bamboo.trigger.TriggerModuleDescriptor;
import com.atlassian.bamboo.trigger.TriggerTypeManager;
import com.atlassian.bamboo.trigger.Triggerable;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.web.utils.ActionParamHandlingUtils;
import com.atlassian.bamboo.webwork.util.ActionParametersMapImpl;
import com.atlassian.bamboo.ww2.actions.build.admin.config.task.TaskRenderMode;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.struts.TextProvider;
import com.opensymphony.xwork2.ActionContext;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TriggerUIConfigBean {
    private static final Logger log = Logger.getLogger(TriggerUIConfigBean.class);
    public static final String CTX_DEPLOYMENT_PROJECT = "deploymentProject";
    public static final String CTX_ENVIRONMENT = "environment";
    public static final String CTX_CHAIN = "chain";
    public static final String CTX_TRIGGERABLE = "triggerable";
    private final TriggerTypeManager triggerTypeManager;
    private final TemplateRenderer templateRenderer;
    private final TextProvider textProvider;
    private final DeploymentProjectService deploymentProjectService;

    public TriggerUIConfigBean(TriggerTypeManager triggerTypeManager, DeploymentProjectService deploymentProjectService, TemplateRenderer templateRenderer, TextProvider textProvider) {
        this.triggerTypeManager = triggerTypeManager;
        this.templateRenderer = templateRenderer;
        this.textProvider = textProvider;
        this.deploymentProjectService = deploymentProjectService;
    }

    @NotNull
    public String prepareCreateHtml(@NotNull TriggerModuleDescriptor triggerDescriptor, @NotNull TaskRenderMode renderMode, @Nullable Triggerable triggerable) {
        TriggerConfigurator triggerConfigurator = triggerDescriptor.getTriggerConfigurator();
        if (triggerConfigurator != null) {
            Map<String, Object> contextParams = this.triggerableToContextMap(triggerable);
            triggerConfigurator.populateContextForCreate(contextParams);
            return this.renderEditHtml(triggerDescriptor, contextParams, renderMode);
        }
        return "";
    }

    @NotNull
    public String prepareCreateHtml(@NotNull TriggerModuleDescriptor triggerDescriptor, @NotNull TaskRenderMode renderMode, @NotNull DeploymentProject deploymentProject) {
        TriggerConfigurator triggerConfigurator = triggerDescriptor.getTriggerConfigurator();
        if (triggerConfigurator != null) {
            Map<String, Object> contextParams = this.deploymentProjectToContextMap(deploymentProject);
            triggerConfigurator.populateContextForCreate(contextParams);
            return this.renderEditHtml(triggerDescriptor, contextParams, renderMode);
        }
        return "";
    }

    @NotNull
    public String prepareEditHtml(@NotNull TriggerModuleDescriptor triggerDescriptor, @NotNull TriggerDefinition triggerDefinition, @NotNull TaskRenderMode renderMode, @NotNull Triggerable triggerable) {
        TriggerConfigurator triggerConfigurator = triggerDescriptor.getTriggerConfigurator();
        if (triggerConfigurator != null) {
            Map<String, Object> contextParams = this.triggerableToContextMap(triggerable);
            triggerConfigurator.populateContextForEdit(contextParams, triggerDefinition);
            return this.renderEditHtml(triggerDescriptor, contextParams, renderMode);
        }
        return "";
    }

    @NotNull
    public String prepareViewHtml(@NotNull TriggerModuleDescriptor triggerDescriptor, @NotNull TriggerDefinition triggerDefinition, @Nullable Triggerable triggerable) {
        TriggerConfigurator triggerConfigurator = triggerDescriptor.getTriggerConfigurator();
        if (triggerConfigurator != null) {
            Map<String, Object> contextParams = this.triggerableToContextMap(triggerable);
            return this.renderViewHtml(triggerDescriptor, contextParams);
        }
        return "";
    }

    public void validateTriggerConfiguration(@NotNull TriggerModuleDescriptor triggerDescriptor, @NotNull ErrorCollection errorCollection) {
        TriggerConfigurator triggerConfigurator = triggerDescriptor.getTriggerConfigurator();
        if (triggerConfigurator != null) {
            triggerConfigurator.validate((ActionParametersMap)new ActionParametersMapImpl(ActionContext.getContext(), true), errorCollection);
        }
    }

    @NotNull
    public Map<String, String> getTriggerConfigurationMap(@NotNull TriggerModuleDescriptor triggerDescriptor, @Nullable TriggerDefinition previousTriggerDefinition) {
        TriggerConfigurator triggerConfigurator = triggerDescriptor.getTriggerConfigurator();
        if (triggerConfigurator != null) {
            return triggerConfigurator.generateTriggerConfigMap((ActionParametersMap)new ActionParametersMapImpl(ActionContext.getContext(), true), previousTriggerDefinition);
        }
        return new HashMap<String, String>();
    }

    @NotNull
    private String renderEditHtml(@NotNull TriggerModuleDescriptor triggerDescriptor, @NotNull Map<String, Object> contextParams, TaskRenderMode renderMode) {
        if (renderMode == TaskRenderMode.ERROR) {
            ActionParamHandlingUtils.appendContextTo(contextParams);
        }
        OgnlStackUtils.putAll(contextParams);
        ResourceLocation resourceLocation = triggerDescriptor.getResourceLocation("freemarker", "edit");
        if (resourceLocation != null) {
            String templatePath = resourceLocation.getLocation();
            String html = this.templateRenderer.render(templatePath, contextParams);
            return StringUtils.defaultString((String)html, (String)"");
        }
        return "";
    }

    @NotNull
    private String renderViewHtml(@NotNull TriggerModuleDescriptor triggerDescriptor, @NotNull Map<String, Object> contextParams) {
        OgnlStackUtils.putAll(contextParams);
        ResourceLocation resourceLocation = triggerDescriptor.getResourceLocation("freemarker", "view");
        if (resourceLocation != null) {
            String templatePath = resourceLocation.getLocation();
            String html = this.templateRenderer.render(templatePath, contextParams);
            return StringUtils.defaultString((String)html, (String)"");
        }
        return "";
    }

    private Map<String, Object> triggerableToContextMap(Triggerable triggerable) {
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        if (triggerable != null) {
            contextMap.put(CTX_TRIGGERABLE, triggerable);
            if (triggerable instanceof ImmutableChain) {
                contextMap.put(CTX_CHAIN, triggerable);
            } else if (triggerable instanceof Environment) {
                contextMap.put(CTX_ENVIRONMENT, triggerable);
                contextMap.put(CTX_DEPLOYMENT_PROJECT, this.deploymentProjectService.getDeploymentProject(((Environment)triggerable).getDeploymentProjectId()));
            }
        }
        return contextMap;
    }

    private Map<String, Object> deploymentProjectToContextMap(DeploymentProject deploymentProject) {
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        contextMap.put(CTX_DEPLOYMENT_PROJECT, deploymentProject);
        return contextMap;
    }

    public static class TriggerSelector {
        private final String key;
        private final String name;
        private final String description;
        private final String html;

        public TriggerSelector(@NotNull String key, @NotNull String name, @Nullable String description, @NotNull String html) {
            this.key = key;
            this.name = name;
            this.description = description;
            this.html = html;
        }

        @NotNull
        public String getKey() {
            return this.key;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @Nullable
        public String getDescription() {
            return this.description;
        }

        @NotNull
        public String getHtml() {
            return this.html;
        }
    }
}

