/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.chains.admin.triggers;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.google.common.base.Function;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Internal
public class RepositoryTriggerSelector {
    private static final Logger log = Logger.getLogger(RepositoryTriggerSelector.class);
    long id;
    String name;
    boolean buildTrigger;

    public RepositoryTriggerSelector(long id, String name, boolean buildTrigger) {
        this.id = id;
        this.name = name;
        this.buildTrigger = buildTrigger;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isBuildTrigger() {
        return this.buildTrigger;
    }

    public static class Transform2TriggerSelector
    implements Function<PlanRepositoryDefinition, RepositoryTriggerSelector> {
        private final Set<Long> triggeringRepositories;

        public Transform2TriggerSelector(@NotNull Set<Long> triggeringRepositories) {
            this.triggeringRepositories = triggeringRepositories;
        }

        public Transform2TriggerSelector() {
            this.triggeringRepositories = null;
        }

        public RepositoryTriggerSelector apply(PlanRepositoryDefinition input) {
            if (this.triggeringRepositories != null) {
                return new RepositoryTriggerSelector(input.getId(), input.getName(), this.triggeringRepositories.contains(input.getId()));
            }
            return new RepositoryTriggerSelector(input.getId(), input.getName(), true);
        }
    }
}

