/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.chains.admin.triggers;

import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.trigger.Triggerable;
import com.atlassian.bamboo.ww2.actions.build.admin.config.task.TaskRenderMode;
import com.atlassian.bamboo.ww2.actions.chains.admin.triggers.ConfigureChainTrigger;
import com.atlassian.bamboo.ww2.aware.RssConfigurationAware;
import com.google.common.collect.Lists;
import java.util.Collections;

public class EditChainTrigger
extends ConfigureChainTrigger {
    private String editHtml;

    public String input() {
        this.validatePlan();
        if (this.triggerDefinition == null) {
            this.addActionError(this.getText("chain.trigger.edit.error.missingConfiguration"));
            return "error";
        }
        if (this.triggerDescriptor == null) {
            this.addActionError(this.getText("triggers.edit.error.missingPlugin", Lists.newArrayList((Object[])new String[]{this.triggerDefinition.getPluginKey()})));
            return "invalidPlugin";
        }
        if (this.hasErrors()) {
            return "error";
        }
        this.triggerDisabled = !this.triggerDefinition.isEnabled();
        this.editHtml = this.triggerUIConfigBean.prepareEditHtml(this.triggerDescriptor, this.triggerDefinition, TaskRenderMode.SUCCESS, (Triggerable)((ImmutableChain)this.getImmutablePlan()));
        return "input";
    }

    @RssConfigurationAware
    public String execute() {
        try {
            this.triggerDefinition = this.triggerConfigurationService.editTrigger(this.getImmutablePlan().getPlanKey(), this.triggerId, this.userDescription, !this.triggerDisabled, this.triggeringRepositoriesFromInput(), this.triggerUIConfigBean.getTriggerConfigurationMap(this.triggerDescriptor, this.triggerDefinition), this.triggerConditionsConfigurationFromInput());
        }
        catch (Exception e) {
            this.addActionError(e);
            return "error";
        }
        this.triggerAnalyticsEvent();
        return "success";
    }

    public void validate() {
        this.validatePlan();
        if (this.triggerDescriptor == null) {
            this.addActionError(this.getText("triggers.edit.error.missingPlugin", Collections.singletonList(this.triggerDefinition.getPluginKey())));
        }
        this.validateDescription();
        this.validateTriggerConditions();
        if (this.triggerDescriptor != null) {
            this.triggerUIConfigBean.validateTriggerConfiguration(this.triggerDescriptor, this);
            if (this.hasErrors() && this.triggerDefinition != null) {
                this.editHtml = this.triggerUIConfigBean.prepareEditHtml(this.triggerDescriptor, this.triggerDefinition, TaskRenderMode.ERROR, (Triggerable)((ImmutableChain)this.getImmutablePlan()));
            }
        }
    }

    public String getSubmitAction() {
        return "updateChainTrigger";
    }

    public String getEditHtml() {
        return this.editHtml;
    }
}

