/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.chains.admin.triggers;

import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.trigger.Triggerable;
import com.atlassian.bamboo.ww2.actions.build.admin.config.task.TaskRenderMode;
import com.atlassian.bamboo.ww2.actions.chains.admin.triggers.ConfigureChainTrigger;
import com.atlassian.bamboo.ww2.aware.RssConfigurationAware;
import com.google.common.collect.Lists;
import com.opensymphony.xwork2.Preparable;
import java.util.Collections;

public class CreateChainTrigger
extends ConfigureChainTrigger
implements Preparable {
    private String createTriggerKey;
    private String editHtml;

    public String input() {
        this.validatePlan();
        if (this.hasErrors()) {
            return "error";
        }
        if (this.triggerDescriptor == null) {
            this.addActionError(this.getText("triggers.add.error.missingPlugin", Lists.newArrayList((Object[])new String[]{this.createTriggerKey})));
            return "invalidPlugin";
        }
        this.editHtml = this.triggerUIConfigBean.prepareCreateHtml(this.triggerDescriptor, TaskRenderMode.SUCCESS, (Triggerable)((ImmutableChain)this.getImmutablePlan()));
        return "input";
    }

    @Override
    public void prepare() throws Exception {
        super.prepare();
        this.triggerDescriptor = this.triggerTypeManager.getTriggerDescriptor(this.createTriggerKey);
    }

    @RssConfigurationAware
    public String execute() {
        try {
            this.triggerDefinition = this.triggerConfigurationService.createTrigger(this.getImmutablePlan().getPlanKey(), this.triggerDescriptor, this.userDescription, !this.triggerDisabled, this.triggeringRepositoriesFromInput(), this.triggerUIConfigBean.getTriggerConfigurationMap(this.triggerDescriptor, null), this.triggerConditionsConfigurationFromInput());
        }
        catch (Exception e) {
            this.addActionError(e);
            return "error";
        }
        this.triggerAnalyticsEvent();
        return "success";
    }

    public void validate() {
        this.validatePlan();
        if (this.triggerDescriptor == null) {
            this.addActionError(this.getText("triggers.add.error.missingPlugin", Collections.singletonList(this.createTriggerKey)));
        }
        this.validateDescription();
        this.validateTriggerConditions();
        if (this.triggerDescriptor != null) {
            this.triggerUIConfigBean.validateTriggerConfiguration(this.triggerDescriptor, this);
            if (this.hasErrors()) {
                this.editHtml = this.triggerUIConfigBean.prepareCreateHtml(this.triggerDescriptor, TaskRenderMode.ERROR, (Triggerable)((ImmutableChain)this.getImmutablePlan()));
            }
        }
    }

    public String getSubmitAction() {
        return "createChainTrigger";
    }

    public String getCreateTriggerKey() {
        return this.createTriggerKey;
    }

    public void setCreateTriggerKey(String createTriggerKey) {
        this.createTriggerKey = createTriggerKey;
    }

    public String getEditHtml() {
        return this.editHtml;
    }
}

