/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.chains.admin.triggers;

import com.atlassian.bamboo.build.BuildTriggerCondition;
import com.atlassian.bamboo.build.creation.BuildTriggerConditionConfigHelper;
import com.atlassian.bamboo.event.analytics.PlanConfigurationChangedAnalyticsEvent;
import com.atlassian.bamboo.plan.PlanClassHelper;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plugin.web.PlanConfigurationUIPluginHelper;
import com.atlassian.bamboo.trigger.TriggerConfigurationService;
import com.atlassian.bamboo.trigger.TriggerConfigurationUtils;
import com.atlassian.bamboo.trigger.TriggerConfigurator;
import com.atlassian.bamboo.trigger.TriggerDefinition;
import com.atlassian.bamboo.trigger.TriggerModuleDescriptor;
import com.atlassian.bamboo.trigger.TriggerTypeManager;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.BambooFunctions;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.ww2.actions.build.admin.BuildConfigurationSupport;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.bamboo.ww2.actions.chains.admin.triggers.RepositoryTriggerSelector;
import com.atlassian.bamboo.ww2.actions.chains.admin.triggers.TriggerUIConfigBean;
import com.atlassian.bamboo.ww2.aware.permissions.PlanEditSecurityAware;
import com.atlassian.bamboo.ww2.common.BuildConfigurationActionHelper;
import com.atlassian.struts.Preparable;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import com.opensymphony.xwork.ValidationAware;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureChainTrigger
extends BuildConfigurationSupport
implements Preparable,
PlanEditSecurityAware {
    protected static final String INVALID_PLUGIN = "invalidPlugin";
    protected long triggerId = -1L;
    protected String userDescription;
    protected Long[] repositoryTrigger;
    protected TriggerDefinition triggerDefinition;
    protected TriggerUIConfigBean triggerUIConfigBean;
    protected TriggerConfigurationService triggerConfigurationService;
    protected TriggerModuleDescriptor triggerDescriptor;
    protected BuildConfiguration buildConfiguration = new BuildConfiguration();
    private PlanConfigurationUIPluginHelper planConfigurationUIPluginHelper;
    protected TriggerTypeManager triggerTypeManager;
    protected BuildTriggerConditionConfigHelper buildTriggerConditionConfigHelper;
    protected boolean triggerDisabled;

    public void prepare() throws Exception {
        if (this.triggerId >= 0L) {
            this.triggerDefinition = this.getTriggerDefinitionById(this.triggerId);
        }
        if (this.triggerDefinition != null) {
            if (this.userDescription == null) {
                this.userDescription = this.triggerDefinition.getUserDescription();
            }
            this.triggerDescriptor = this.triggerTypeManager.getTriggerDescriptor(this.triggerDefinition.getPluginKey());
            TriggerConfigurationUtils.triggerConditionsToConfiguration((HierarchicalConfiguration)this.buildConfiguration, (TriggerDefinition)this.triggerDefinition);
        } else {
            this.buildTriggerConditionConfigHelper.addDefaultsToConfig(this.buildConfiguration);
        }
        ActionInvocation actionInvocation = ActionContext.getContext().getActionInvocation();
        BuildConfigurationActionHelper.copyParamsToBuildConfiguration(actionInvocation, this.buildConfiguration);
    }

    @Nullable
    private ImmutableChain getChain() {
        return (ImmutableChain)Narrow.downTo((Object)this.getImmutablePlan(), ImmutableChain.class);
    }

    protected void validatePlan() {
        ImmutablePlan plan = this.getImmutablePlan();
        if (plan == null) {
            this.addActionError(this.getText("repository.plan.noPlan"));
        } else if (!PlanClassHelper.isChain((ImmutablePlan)plan)) {
            this.addActionError(this.getText("repository.plan.notTopLevelPlan", Lists.newArrayList((Object[])new String[]{plan.getName()})));
        }
    }

    protected void triggerAnalyticsEvent() {
        this.eventPublisher.publish((Object)new PlanConfigurationChangedAnalyticsEvent());
    }

    protected void validateDescription() {
        this.checkFieldXssSafety("userDescription", this.userDescription);
    }

    protected void validateTriggerConditions() {
        this.buildTriggerConditionConfigHelper.prepareConfig(this.buildConfiguration);
        this.buildTriggerConditionConfigHelper.validateConfig((ValidationAware)this, this.buildConfiguration);
    }

    @Override
    @NotNull
    public JSONObject getJsonObject() throws JSONException {
        JSONObject jsonObject = this.buildJsonObject();
        if (this.triggerDefinition != null) {
            jsonObject.put("triggerResult", (Object)this.getJsonObject(this.triggerDefinition));
        }
        return jsonObject;
    }

    private JSONObject getJsonObject(TriggerDefinition triggerDefinition) throws JSONException {
        return new JSONObject().put("id", triggerDefinition.getId()).put("name", (Object)triggerDefinition.getName()).put("description", (Object)triggerDefinition.getUserDescription()).put("isEnabled", triggerDefinition.isEnabled());
    }

    @NotNull
    public String getTriggerConditionEditHtml() {
        return this.planConfigurationUIPluginHelper.getEditHtml(this.getBuildConfiguration(), this.getMutablePlan(), BuildTriggerCondition.class);
    }

    protected TriggerDefinition getTriggerDefinitionById(long id) {
        List buildStrategies = this.getImmutablePlan().getBuildDefinition().getTriggerDefinitions();
        for (TriggerDefinition buildStrategy : buildStrategies) {
            if (buildStrategy.getId() != id) continue;
            return buildStrategy;
        }
        return null;
    }

    public boolean isUseStandardRepositorySelector() {
        return this.triggerDescriptor.getTriggerConfigurator() != null && TriggerConfigurator.RepositorySelectionMode.SELECTED.equals((Object)this.triggerDescriptor.getTriggerConfigurator().getRepositorySelectionMode());
    }

    private boolean useAllRepositories() {
        return this.triggerDescriptor.getTriggerConfigurator() != null && TriggerConfigurator.RepositorySelectionMode.ALL.equals((Object)this.triggerDescriptor.getTriggerConfigurator().getRepositorySelectionMode());
    }

    @Nullable
    protected Set<Long> triggeringRepositoriesFromInput() {
        Set<Long> triggeringRepositories = null;
        if (this.repositoryTrigger != null && this.isUseStandardRepositorySelector()) {
            triggeringRepositories = new HashSet<Long>(Arrays.asList(this.repositoryTrigger));
        } else if (this.useAllRepositories()) {
            triggeringRepositories = this.getChain().getPlanRepositoryDefinitions().stream().map(arg_0 -> ((Function)BambooFunctions.getBambooObjectId()).apply(arg_0)).collect(Collectors.toSet());
        }
        return triggeringRepositories;
    }

    @NotNull
    protected Map<String, String> triggerConditionsConfigurationFromInput() {
        return TriggerConfigurationUtils.extractTriggerConditionConfiguration((HierarchicalConfiguration)this.buildConfiguration);
    }

    @Nullable
    private List<PlanRepositoryDefinition> getSelectablePlanRepositoryDefinitions() {
        Preconditions.checkNotNull((Object)this.triggerDescriptor);
        if (this.getChain() != null) {
            if (this.triggerDescriptor.getTriggerConfigurator() != null) {
                return this.getChain().getPlanRepositoryDefinitions().stream().filter(arg_0 -> ((TriggerConfigurator)this.triggerDescriptor.getTriggerConfigurator()).isRepositorySelectable(arg_0)).collect(Collectors.toList());
            }
            return this.getChain().getPlanRepositoryDefinitions();
        }
        return null;
    }

    public List<RepositoryTriggerSelector> getRepositoryTriggerSelectors() {
        Preconditions.checkNotNull((Object)this.triggerDescriptor);
        List<PlanRepositoryDefinition> selectablePlanRepositoryDefinitions = this.getSelectablePlanRepositoryDefinitions();
        if (selectablePlanRepositoryDefinitions != null) {
            if (this.repositoryTrigger != null) {
                HashSet<Long> triggeringRepositories = new HashSet<Long>();
                triggeringRepositories.addAll(Arrays.asList(this.repositoryTrigger));
                return ImmutableList.copyOf((Iterable)Iterables.transform(selectablePlanRepositoryDefinitions, (Function)new RepositoryTriggerSelector.Transform2TriggerSelector(triggeringRepositories)));
            }
            if (this.isUseStandardRepositorySelector()) {
                if (this.triggerDefinition != null) {
                    return ImmutableList.copyOf((Iterable)Iterables.transform(selectablePlanRepositoryDefinitions, (Function)new RepositoryTriggerSelector.Transform2TriggerSelector(this.triggerDefinition.getTriggeringRepositories())));
                }
                return ImmutableList.copyOf((Iterable)Iterables.transform(selectablePlanRepositoryDefinitions, (Function)new RepositoryTriggerSelector.Transform2TriggerSelector()));
            }
        }
        return null;
    }

    public List<PlanRepositoryDefinition> getRepositoryDefinitions() {
        ImmutableChain chain = (ImmutableChain)Narrow.downTo((Object)this.getImmutablePlan(), ImmutableChain.class);
        if (chain != null) {
            return chain.getPlanRepositoryDefinitions();
        }
        return null;
    }

    public long getTriggerId() {
        return this.triggerId;
    }

    public void setTriggerId(long triggerId) {
        this.triggerId = triggerId;
    }

    public String getUserDescription() {
        return this.userDescription;
    }

    public void setUserDescription(String userDescription) {
        this.userDescription = userDescription;
    }

    public void setPlanConfigurationUIPluginHelper(PlanConfigurationUIPluginHelper planConfigurationUIPluginHelper) {
        this.planConfigurationUIPluginHelper = planConfigurationUIPluginHelper;
    }

    public void setTriggerTypeManager(TriggerTypeManager triggerTypeManager) {
        this.triggerTypeManager = triggerTypeManager;
    }

    public void setBuildTriggerConditionConfigHelper(BuildTriggerConditionConfigHelper buildTriggerConditionConfigHelper) {
        this.buildTriggerConditionConfigHelper = buildTriggerConditionConfigHelper;
    }

    public void setTriggerUIConfigBean(TriggerUIConfigBean triggerUIConfigBean) {
        this.triggerUIConfigBean = triggerUIConfigBean;
    }

    public void setTriggerConfigurationService(TriggerConfigurationService triggerConfigurationService) {
        this.triggerConfigurationService = triggerConfigurationService;
    }

    public void setRepositoryTrigger(Long[] repositoryTrigger) {
        this.repositoryTrigger = repositoryTrigger;
    }

    @Override
    public BuildConfiguration getBuildConfiguration() {
        return this.buildConfiguration;
    }

    public boolean isTriggerDisabled() {
        return this.triggerDisabled;
    }

    public void setTriggerDisabled(boolean triggerDisabled) {
        this.triggerDisabled = triggerDisabled;
    }

    public TriggerDefinition getTriggerDefinition() {
        return this.triggerDefinition;
    }
}

