/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.chains.admin;

import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.filter.Pager;
import com.atlassian.bamboo.persister.AuditLogEntry;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.ww2.actions.ChainActionSupport;
import com.atlassian.bamboo.ww2.aware.LazyPaginationAware;
import com.atlassian.bamboo.ww2.aware.permissions.PlanAdminSecurityAware;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;

public class ViewChainAuditLog
extends ChainActionSupport
implements LazyPaginationAware,
PlanAdminSecurityAware {
    private static final int DEFAULT_AUDIT_LOG_PAGE_SIZE = 100;
    private Map<String, JobEntry> jobMap;
    private Pager auditHistoryPager;
    private long filterStart = -1L;
    private long filterEnd = -1L;
    @Inject
    private AuditLogService auditLogService;

    public String execute() {
        if (this.getImmutableChain() == null) {
            return this.planNotFound();
        }
        this.jobMap = new HashMap<String, JobEntry>();
        List stages = this.getImmutableChain().getAllStages();
        for (ImmutableChainStage stage : stages) {
            for (ImmutableJob job : stage.getJobs()) {
                this.jobMap.put(job.getKey(), new JobEntry(this.getBaseUrl() + "/build/admin/edit/editBuildDetails.action?buildKey=" + job.getKey(), job.getBuildName()));
            }
        }
        return "success";
    }

    public boolean isEnabled() {
        return this.auditLogService.isEnabled();
    }

    public Pager getPager() {
        return this.auditHistoryPager;
    }

    public void setPager(Pager pager) {
        this.auditHistoryPager = pager;
        this.auditHistoryPager.setPageSize(100);
    }

    @NotNull
    public List<AuditLogEntry> getFilteredResultsList(int firstResult, int maxResults) {
        if (this.hasActionErrors()) {
            return Collections.emptyList();
        }
        return this.auditLogService.getAuditLogMessagesForPlan((ImmutablePlan)this.getImmutableChain(), this.filterStart, this.filterEnd, firstResult, maxResults);
    }

    @Override
    public int getResultsCount() {
        return (int)this.auditLogService.countAuditLogMessagesForPlan((ImmutablePlan)this.getImmutableChain(), this.filterStart, this.filterEnd);
    }

    public Map<String, JobEntry> getJobMap() {
        return this.jobMap;
    }

    public void setFilterStart(long filterStart) {
        this.filterStart = filterStart;
    }

    public long getFilterStart() {
        return this.filterStart;
    }

    public void setFilterEnd(long filterEnd) {
        this.filterEnd = filterEnd;
    }

    public long getFilterEnd() {
        return this.filterEnd;
    }

    public Date getFilterStartDate() {
        return new Date(this.filterStart);
    }

    public Date getFilterEndDate() {
        return new Date(this.filterEnd);
    }

    public static class JobEntry {
        private final String url;
        private final String name;

        public JobEntry(String url, String name) {
            this.url = url;
            this.name = name;
        }

        public String getUrl() {
            return this.url;
        }

        public String getName() {
            return this.name;
        }
    }
}

