/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.chains.admin;

import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.event.NotificationAddedToPlanEvent;
import com.atlassian.bamboo.event.analytics.PlanConfigurationChangedAnalyticsEvent;
import com.atlassian.bamboo.instantmessagingserver.InstantMessagingServerManager;
import com.atlassian.bamboo.notification.NotificationManager;
import com.atlassian.bamboo.notification.NotificationRecipient;
import com.atlassian.bamboo.notification.NotificationRule;
import com.atlassian.bamboo.notification.NotificationSet;
import com.atlassian.bamboo.notification.NotificationType;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.util.ActionParamsUtils;
import com.atlassian.bamboo.util.UrlBuilder;
import com.atlassian.bamboo.ww2.actions.ChainActionSupport;
import com.atlassian.bamboo.ww2.actions.build.admin.create.UIConfigSupport;
import com.atlassian.bamboo.ww2.aware.RssConfigurationAware;
import com.atlassian.bamboo.ww2.aware.permissions.PlanEditSecurityAware;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.user.Group;
import com.google.common.collect.Iterables;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ConfigureChainNotification
extends ChainActionSupport
implements PlanEditSecurityAware {
    private String notificationRecipientType;
    private String conditionKey;
    private long notificationId;
    private long lastModified;
    private NotificationManager notificationManager;
    private InstantMessagingServerManager instantMessagingServerManager;
    private final Map<String, NotificationType> notificationTypes = new TreeMap<String, NotificationType>();
    private final Map<String, NotificationRecipient> notificationRecipients = new TreeMap<String, NotificationRecipient>();
    private String edit;
    private String previousTypeData;
    private String redirectUrl;
    private boolean saved;
    @Inject
    private UIConfigSupport uiConfigBean;
    @Inject
    private EventPublisher eventPublisher;

    @Override
    public String doDefault() throws Exception {
        NotificationType notificationType;
        if (StringUtils.isNotBlank((CharSequence)this.conditionKey) && (notificationType = this.notificationManager.getNotificationTypeFromKey(this.conditionKey)) != null) {
            notificationType.setConfigurationData(this.previousTypeData);
            this.getNotificationTypes().put(notificationType.getKey(), notificationType);
        }
        return "input";
    }

    public String addNotification() {
        this.validateNotification();
        if (this.hasErrors()) {
            return "input";
        }
        Chain mutableChain = this.getMutableChain();
        NotificationSet notificationSet = mutableChain.getNotificationSet();
        try {
            NotificationRule newRule = this.notificationManager.createNotificationRuleFromAction(this.conditionKey, this.notificationRecipientType, ConfigureChainNotification.getActionParameters());
            notificationSet.addNotification(newRule);
            this.planManager.savePlan((Plan)mutableChain);
            this.lastModified = newRule.getId();
            this.previousTypeData = newRule.getConditionData();
            this.redirectUrl = new UrlBuilder().setUrl("/chain/admin/config/defaultChainNotification.action").addParameter("buildKey", this.getImmutablePlan().getKey()).addParameter("lastModified", (Number)this.lastModified).addParameter("conditionKey", this.conditionKey).addParameter("notificationRecipientType", this.notificationRecipientType).addParameter("previousTypeData", this.previousTypeData).addParameter("saved", "true").toString();
            this.triggerAnalyticsEvent();
            this.eventPublisher.publish((Object)new NotificationAddedToPlanEvent(mutableChain.getPlanKey(), this.notificationRecipientType, newRule.getId()));
            return "success";
        }
        catch (IllegalArgumentException e) {
            this.addActionError(e);
            return "error";
        }
    }

    private void triggerAnalyticsEvent() {
        this.eventPublisher.publish((Object)new PlanConfigurationChangedAnalyticsEvent());
    }

    @Override
    @NotNull
    protected JSONObject buildJsonObject() throws JSONException {
        JSONObject json = super.buildJsonObject();
        json.put("redirectUrl", (Object)this.redirectUrl);
        return json;
    }

    private static Map<String, String[]> getActionParameters() {
        return ActionParamsUtils.getStringArrayMap();
    }

    @RssConfigurationAware
    public String delete() {
        Chain chain = this.getMutableChain();
        chain.getNotificationSet().removeNotificationRule(this.notificationId);
        this.planManager.savePlan((Plan)chain);
        this.triggerAnalyticsEvent();
        return "success";
    }

    @RssConfigurationAware
    public String deleteAll() {
        Chain chain = this.getMutableChain();
        NotificationSet notificationSet = chain.getNotificationSet();
        List notificationRules = notificationSet.getSortedNotificationRules();
        for (NotificationRule notificationRule : notificationRules) {
            notificationSet.removeNotificationRule(notificationRule.getId());
        }
        this.planManager.savePlan((Plan)chain);
        this.triggerAnalyticsEvent();
        return "success";
    }

    public String edit() {
        NotificationSet notificationSet = this.getImmutableChain().getNotificationSet();
        NotificationRule notificationRule = notificationSet.getNotificationRuleById(this.notificationId);
        if (notificationRule == null) {
            this.addActionError("Could not find notification rule with id: " + this.notificationId);
            return "error";
        }
        this.notificationRecipientType = StringUtils.defaultString((String)notificationRule.getRecipientType());
        this.conditionKey = StringUtils.defaultString((String)notificationRule.getConditionKey());
        this.updateObjectsForEdit(notificationRule);
        this.lastModified = this.notificationId;
        return "input";
    }

    public String update() {
        this.validateNotification();
        if (this.hasAnyErrors()) {
            return "input";
        }
        Chain chain = this.getMutableChain();
        NotificationSet notificationSet = chain.getNotificationSet();
        try {
            NotificationRule newRule = this.notificationManager.createNotificationRuleFromAction(this.conditionKey, this.notificationRecipientType, ConfigureChainNotification.getActionParameters());
            this.notificationManager.replaceNotificationRule(notificationSet, this.notificationId, newRule);
            this.lastModified = newRule.getId();
            this.redirectUrl = new UrlBuilder().setUrl("/chain/admin/config/defaultChainNotification.action").addParameter("buildKey", this.getBuildKey()).addParameter("lastModified", (Number)this.lastModified).addParameter("saved", "true").toString();
            this.triggerAnalyticsEvent();
            return "success";
        }
        catch (IllegalArgumentException e) {
            this.addActionError(e);
            return "error";
        }
    }

    public void validateNotification() {
        NotificationType notificationType = this.notificationManager.getNotificationTypeFromKey(this.conditionKey);
        if (notificationType != null) {
            this.addErrorCollection(notificationType.validate(ConfigureChainNotification.getActionParameters()));
            if (this.hasAnyErrors()) {
                return;
            }
        } else {
            this.addActionError("Failed to save notification, could not find associated plugin module for. " + this.conditionKey);
            return;
        }
        this.getNotificationTypes().put(notificationType.getKey(), notificationType);
        notificationType.populate(ConfigureChainNotification.getActionParameters());
        String configData = notificationType.getConfigurationData();
        NotificationRecipient notificationRecipient = this.notificationManager.getNotificationRecipientFromKey(this.notificationRecipientType);
        this.addErrorCollection(notificationRecipient.validate(ConfigureChainNotification.getActionParameters()));
        if (this.hasAnyErrors()) {
            return;
        }
        this.getAvailableRecipientTypes().put(notificationRecipient.getKey(), notificationRecipient);
        NotificationSet notificationSet = this.getImmutableChain().getNotificationSet();
        NotificationRule newRule = this.notificationManager.createNotificationRule(this.conditionKey, configData, notificationRecipient.getRecipientConfig(), this.notificationRecipientType);
        for (NotificationRule oldRule : notificationSet.getNotificationRules()) {
            if (!oldRule.equals(newRule) || this.notificationId == oldRule.getId()) continue;
            this.addActionError("Notification already exists for this build");
        }
    }

    private void updateObjectsForEdit(NotificationRule rule) {
        NotificationRecipient notificationRecipient;
        NotificationType notificationType = this.notificationManager.getNotificationType(rule);
        if (notificationType != null) {
            this.getNotificationTypes().put(notificationType.getKey(), notificationType);
        }
        if ((notificationRecipient = this.notificationManager.getNotificationRecipient(rule)) != null) {
            this.getAvailableRecipientTypes().put(notificationRecipient.getKey(), notificationRecipient);
        }
    }

    public Map<String, NotificationRecipient> getAvailableRecipientTypes() {
        if (this.notificationRecipients.isEmpty()) {
            this.notificationManager.getAllNotificationRecipients().stream().filter(recipient -> recipient.getScopes().isEmpty() || recipient.getScopes().contains(NotificationRecipient.Scope.CHAIN)).forEach(recipient -> this.notificationRecipients.put(recipient.getKey(), (NotificationRecipient)recipient));
        }
        return this.notificationRecipients;
    }

    private Map<String, NotificationType> getNotificationTypes() {
        if (this.notificationTypes.isEmpty()) {
            for (NotificationType type : Iterables.concat((Iterable)this.notificationManager.getChainNotificationTypes(), (Iterable)this.notificationManager.getPlanNotificationTypes())) {
                this.notificationTypes.put(type.getKey(), type);
            }
        }
        return this.notificationTypes;
    }

    public List<NotificationRecipient> getAllNotificationRecipientTypes() {
        return this.getAvailableRecipientTypes().values().stream().sorted().collect(Collectors.toList());
    }

    public List<NotificationType> getAllNotificationEventTypes() {
        return this.getNotificationTypes().values().stream().sorted().collect(Collectors.toList());
    }

    public List<Group> getAvailableGroups() {
        return this.uiConfigBean.getAvailableGroups();
    }

    public List<String> getAvailableUsers() {
        return this.uiConfigBean.getAvailableUserNames();
    }

    public long getNotificationId() {
        return this.notificationId;
    }

    public void setNotificationId(long notificationRowId) {
        this.notificationId = notificationRowId;
    }

    public String getEdit() {
        return this.edit;
    }

    public void setEdit(String edit) {
        this.edit = edit;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public String getNotificationRecipientType() {
        return this.notificationRecipientType;
    }

    public void setNotificationRecipientType(String notificationRecipientType) {
        this.notificationRecipientType = notificationRecipientType;
    }

    public String getConditionKey() {
        return this.conditionKey;
    }

    public void setConditionKey(String conditionKey) {
        this.conditionKey = conditionKey;
    }

    public void setNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    public boolean isMailServerConfigured() {
        return this.getMailServerManager().isDefaultSMTPMailServerDefined();
    }

    public void setInstantMessagingServerManager(InstantMessagingServerManager instantMessagingServerManager) {
        this.instantMessagingServerManager = instantMessagingServerManager;
    }

    public boolean isJabberServerConfigured() {
        Collection instantMessagingServers = this.instantMessagingServerManager.getAllInstantMessagingServers();
        return instantMessagingServers != null && !instantMessagingServers.isEmpty();
    }

    protected MailServerManager getMailServerManager() {
        return MailFactory.getServerManager();
    }

    public String getPreviousTypeData() {
        return this.previousTypeData;
    }

    public void setPreviousTypeData(String previousTypeData) {
        this.previousTypeData = previousTypeData;
    }

    public boolean isSaved() {
        return this.saved;
    }

    public void setSaved(boolean saved) {
        this.saved = saved;
    }
}

