/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.chains;

import com.atlassian.bamboo.build.tests.TestCaseForDisplay;
import com.atlassian.bamboo.plan.branch.ChainBranchUtils;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.resultsummary.tests.TestCase;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResult;
import com.atlassian.bamboo.resultsummary.tests.TestQuarantineManager;
import com.atlassian.bamboo.resultsummary.tests.TestsManager;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.ww2.actions.PlanActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.PlanReadSecurityAware;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class ViewQuarantinedTests
extends PlanActionSupport
implements PlanReadSecurityAware {
    private static final Logger log = Logger.getLogger(ViewQuarantinedTests.class);
    private TestQuarantineManager testQuarantineManager;
    private TestsManager testsManager;
    private List<TestCaseForDisplay> quarantinedTestCases;
    private UserManager userManager;

    @Override
    public String doDefault() {
        if (this.getImmutablePlan() == null) {
            this.addActionError(this.getText("chain.error.noChain", Lists.newArrayList((Object[])new String[]{this.getPlanKey()})));
            return "error";
        }
        return "success";
    }

    public List<TestCaseForDisplay> getQuarantinedTestCases() {
        ImmutableChain chain;
        if (this.quarantinedTestCases == null && (chain = (ImmutableChain)Narrow.downTo((Object)this.getImmutablePlan(), ImmutableChain.class)) != null) {
            this.quarantinedTestCases = this.testQuarantineManager.getCurrentlyQuarantinedTests(chain).stream().map(testCase -> {
                ImmutableJob job = ChainBranchUtils.findJobByMasterId((ImmutableChain)chain, (long)testCase.getTestClass().getMasterJobId());
                if (job == null) {
                    return null;
                }
                return new TestCaseForDisplay((TestCase)testCase, job);
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return this.quarantinedTestCases;
    }

    public User getQuarantiningUser(TestCase testCase) throws EntityException {
        String username = testCase.getQuarantineStatistics().getQuarantiningUsername();
        return this.userManager.getUser(username);
    }

    public List<TestCaseResult> getTestCaseHistory(TestCase testCase) {
        ArrayList<TestCaseResult> testResults = new ArrayList<TestCaseResult>();
        int tenBuildsPrev = Math.max(testCase.getLastRanBuildNumber() - 9, 1);
        int currentBuildNumber = testCase.getLastRanBuildNumber();
        List testCaseResults = this.testsManager.getTestCaseResults(testCase, (long)currentBuildNumber);
        while (currentBuildNumber >= tenBuildsPrev && !testCaseResults.isEmpty() && ((TestCaseResult)testCaseResults.get(0)).isQuarantined()) {
            testResults.add(0, (TestCaseResult)testCaseResults.get(0));
            testCaseResults = this.testsManager.getTestCaseResults(testCase, (long)(--currentBuildNumber));
        }
        return testResults;
    }

    public void setTestQuarantineManager(TestQuarantineManager testQuarantineManager) {
        this.testQuarantineManager = testQuarantineManager;
    }

    public void setTestsManager(TestsManager testsManager) {
        this.testsManager = testsManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }
}

