/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.chains;

import com.atlassian.bamboo.build.ChainResultsAction;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.webhook.WebhookResponse;
import com.atlassian.bamboo.webhook.WebhookResponseService;
import com.atlassian.bamboo.webhook.WebhookResponseStatus;
import com.atlassian.bamboo.webhooks.WebhookResponseUtils;
import com.google.common.collect.Lists;
import java.util.List;
import org.acegisecurity.acls.Permission;
import org.springframework.beans.factory.annotation.Autowired;

public class ViewChainWebhookResponses
extends ChainResultsAction {
    private List<WebhookResponse> webhookResponses;
    @Autowired
    private WebhookResponseService webhookResponseService;
    @Autowired
    private BambooPermissionManager bambooPermissionManager;

    public String execute() throws Exception {
        String superResult = super.execute();
        this.checkChain();
        if ("error".equals(superResult)) {
            return "error";
        }
        if (this.hasAnyErrors()) {
            return "error";
        }
        this.prepareWebhookResponses(PlanKeys.getPlanResultKey((String)this.getPlanKey(), (int)this.getBuildNumber()).getKey());
        return "success";
    }

    private void prepareWebhookResponses(String planResultKey) {
        this.webhookResponses = this.webhookResponseService.findWebhookResponsesForPlanResultKey(planResultKey);
    }

    private void checkChain() {
        if (this.getImmutableChain() == null || this.getImmutableChain().isMarkedForDeletion()) {
            this.addActionError(this.getText("chain.error.noChain", Lists.newArrayList((Object[])new String[]{this.getPlanKey()})));
        } else if (this.getChainResult() == null) {
            if (this.getChainResultNumber() > 0) {
                PlanResultKey planResultKey = PlanKeys.getPlanResultKey((PlanKey)this.getImmutableChain().getPlanKey(), (int)this.getChainResultNumber());
                ChainResultsSummary chainResult = (ChainResultsSummary)this.resultsSummaryManager.getResultsSummary(planResultKey, ChainResultsSummary.class);
                if (chainResult == null) {
                    this.addActionError(this.getText("chain.error.noChainResult", Lists.newArrayList((Object[])new String[]{this.getPlanKey() + "-" + this.getChainResultNumber()})));
                } else {
                    this.setChainResult(chainResult);
                }
            } else {
                this.addActionError(this.getText("chain.error.noChainResult", Lists.newArrayList((Object[])new String[]{this.getPlanKey() + "-" + this.getChainResultNumber()})));
            }
        }
    }

    @Override
    public boolean hasAdminPermission() {
        return this.bambooPermissionManager.hasPlanPermission((Permission)BambooPermission.ADMINISTRATION, PlanKeys.getPlanKey((String)this.getPlanKey()));
    }

    public List<WebhookResponse> getWebhookResponses() {
        return this.webhookResponses;
    }

    public String codeColor(int statusCode) {
        return WebhookResponseUtils.codeColor(statusCode);
    }

    public String statusColor(WebhookResponseStatus status) {
        return WebhookResponseUtils.statusColor(status);
    }
}

