/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.chains;

import com.atlassian.bamboo.artifact.Artifact;
import com.atlassian.bamboo.build.FilterController;
import com.atlassian.bamboo.build.artifact.ArtifactHandlingUtils;
import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.build.artifact.ArtifactLinkManager;
import com.atlassian.bamboo.build.statistics.StatisticsCollector;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.deployments.environments.EnvironmentStatus;
import com.atlassian.bamboo.deployments.projects.DeploymentProjectWithEnvironmentStatuses;
import com.atlassian.bamboo.deployments.projects.service.DeploymentProjectService;
import com.atlassian.bamboo.deployments.results.DeploymentResult;
import com.atlassian.bamboo.deployments.versions.DeploymentVersion;
import com.atlassian.bamboo.deployments.versions.service.DeploymentVersionService;
import com.atlassian.bamboo.filter.Pager;
import com.atlassian.bamboo.plan.ExecutionStatus;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.utils.DurationUtils;
import com.atlassian.bamboo.ww2.actions.ChainActionSupport;
import com.atlassian.bamboo.ww2.aware.StatisticsAware;
import com.atlassian.bamboo.ww2.aware.permissions.PlanReadSecurityAware;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class ViewChainSummary
extends ChainActionSupport
implements PlanReadSecurityAware,
StatisticsAware {
    private static final Logger log = Logger.getLogger(ViewChainSummary.class);
    private static final int NUMBER_OF_RESULTS = 10;
    private StatisticsCollector statistics;
    private List<ResultsSummary> resultsList;
    private FilterController filterController;
    private Pager pager;
    private ResultsSummary lastSuccessfulSummary;
    private ResultsSummary lastSummary;
    private List<DeploymentProjectWithEnvironmentStatuses> relatedDeploymentProjects;
    private Set<VersionWithPlanResultKeys> relatedVersions;
    @Autowired
    private DeploymentProjectService deploymentProjectService;
    protected DeploymentVersionService deploymentVersionService;
    @Autowired
    private ArtifactLinkManager artifactLinkManager;

    @Override
    public String doDefault() {
        if (this.getImmutableChain() == null || this.getImmutableChain().isMarkedForDeletion()) {
            this.addActionError(this.getText("chain.error.noChain", Lists.newArrayList((Object[])new String[]{this.getPlanKey()})));
            return "error";
        }
        return "success";
    }

    public List<ExecutionStatus> getCurrentlyExecutingList() {
        if (this.getImmutablePlan() != null) {
            return new ArrayList<ExecutionStatus>(this.planExecutionManager.getExecutionStatus(this.getImmutablePlan().getPlanKey()));
        }
        return Collections.emptyList();
    }

    @Override
    public StatisticsCollector getStatistics() {
        return this.statistics;
    }

    @Override
    public void setStatistics(StatisticsCollector statistics) {
        this.statistics = statistics;
    }

    @Override
    public List<? extends ResultsSummary> getResultsList() {
        return this.resultsList;
    }

    @Override
    public void setResultsList(List<? extends ResultsSummary> results) {
        this.resultsList = new ArrayList<ResultsSummary>(results);
    }

    public FilterController getFilterController() {
        return this.filterController;
    }

    public void setFilterController(FilterController filterController) {
        this.filterController = filterController;
    }

    public Pager getPager() {
        if (this.pager == null) {
            this.pager = new Pager();
            this.pager.setPageFromList(this.resultsSummaryManager.getFinalizedResultSummariesForPlan(this.getImmutableChain().getPlanKey(), ChainResultsSummary.class, 0, 10));
        }
        return this.pager;
    }

    @Nullable
    public ResultsSummary getLastSuccessfulSummary() {
        if (this.lastSuccessfulSummary == null) {
            this.lastSuccessfulSummary = this.resultsSummaryManager.findLastResultSummaryWithState(this.getImmutablePlan().getPlanKey(), BuildState.SUCCESS, ResultsSummary.class);
        }
        return this.lastSuccessfulSummary;
    }

    @Nullable
    public ResultsSummary getLatestSummary() {
        if (this.lastSummary == null) {
            this.lastSummary = this.resultsSummaryManager.getLastResultsSummary(this.getImmutablePlan().getPlanKey().getKey(), ResultsSummary.class);
        }
        return this.lastSummary;
    }

    @Nullable
    public String getRelativeDateString(@Nullable Date date) {
        if (date != null) {
            return DurationUtils.getRelativeDate((Date)date, (Date)new Date()) + " " + "ago";
        }
        return null;
    }

    public Set<VersionWithPlanResultKeys> getRelatedVersions() {
        if (this.relatedVersions == null) {
            this.relatedVersions = new HashSet<VersionWithPlanResultKeys>();
            ImmutablePlan masterPlan = PlanHelper.getMasterPlan((ImmutablePlan)this.getImmutablePlan());
            Set allBranchKeys = this.cachedPlanManager.getBranchesOfChain(masterPlan.getPlanKey()).map(PlanIdentifier::getPlanKey).collect(Collectors.toCollection(HashSet::new));
            allBranchKeys.add(masterPlan.getPlanKey());
            for (DeploymentProjectWithEnvironmentStatuses deploymentProjectWithEnvironmentStatuses : this.getRelatedDeploymentProjects()) {
                for (EnvironmentStatus environmentStatus : deploymentProjectWithEnvironmentStatuses.getEnvironmentStatuses()) {
                    DeploymentVersion deploymentVersion;
                    DeploymentResult deploymentResult = environmentStatus.getDeploymentResult();
                    if (deploymentResult == null || (deploymentVersion = deploymentResult.getDeploymentVersion()) == null) continue;
                    HashSet<ResultsSummary> relatedPlanResults = new HashSet<ResultsSummary>();
                    for (PlanResultKey planResultKey : this.deploymentVersionService.getRelatedPlanResultKeys(deploymentVersion.getId())) {
                        ResultsSummary resultsSummary;
                        if (!allBranchKeys.contains(planResultKey.getPlanKey()) || (resultsSummary = this.resultsSummaryManager.getResultsSummary(planResultKey)) == null) continue;
                        relatedPlanResults.add(resultsSummary);
                    }
                    this.relatedVersions.add(new VersionWithPlanResultKeys(deploymentVersion, relatedPlanResults));
                }
            }
        }
        return this.relatedVersions;
    }

    @Nullable
    public final String getArtifactLinkUrl(ArtifactLink artifactLink) {
        return ArtifactHandlingUtils.getArtifactUrl((ArtifactLinkManager)this.artifactLinkManager, (Artifact)artifactLink.getArtifact(), (String)this.getBambooUrl().rootContext());
    }

    public List<DeploymentProjectWithEnvironmentStatuses> getRelatedDeploymentProjects() {
        if (this.relatedDeploymentProjects == null) {
            this.relatedDeploymentProjects = this.deploymentProjectService.getDeploymentProjectsWithStatusesRelatedToPlanOrBranches(this.getImmutablePlan().getPlanKey());
        }
        return this.relatedDeploymentProjects;
    }

    public void setDeploymentVersionService(DeploymentVersionService deploymentVersionService) {
        this.deploymentVersionService = deploymentVersionService;
    }

    public class VersionWithPlanResultKeys {
        DeploymentVersion deploymentVersion;
        Set<ResultsSummary> relatedPlanResults;

        VersionWithPlanResultKeys(DeploymentVersion deploymentVersion, Set<ResultsSummary> relatedPlanResultKeys) {
            this.deploymentVersion = deploymentVersion;
            this.relatedPlanResults = relatedPlanResultKeys;
        }

        public DeploymentVersion getDeploymentVersion() {
            return this.deploymentVersion;
        }

        public Set<ResultsSummary> getRelatedPlanResults() {
            return this.relatedPlanResults;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VersionWithPlanResultKeys that = (VersionWithPlanResultKeys)o;
            return !(this.deploymentVersion != null ? !this.deploymentVersion.equals(that.deploymentVersion) : that.deploymentVersion != null);
        }

        public int hashCode() {
            return this.deploymentVersion != null ? this.deploymentVersion.hashCode() : 0;
        }
    }
}

