/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.chains;

import com.atlassian.bamboo.build.ChainResultsAction;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.build.artifact.ArtifactLinkPredicates;
import com.atlassian.bamboo.chains.ChainFilteredTestResults;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ContinuableStageHelper;
import com.atlassian.bamboo.comment.Comment;
import com.atlassian.bamboo.comment.CommentService;
import com.atlassian.bamboo.deployments.projects.DeploymentProjectStatusForResultSummary;
import com.atlassian.bamboo.deployments.projects.service.DeploymentProjectService;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.StageIdentifier;
import com.atlassian.bamboo.results.warning.BuildWarningSummary;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultSummaryPredicates;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.tests.FilteredTestResults;
import com.atlassian.bamboo.resultsummary.tests.TestClassResultDescriptor;
import com.atlassian.bamboo.resultsummary.tests.TestQuarantineManager;
import com.atlassian.bamboo.resultsummary.tests.TestsManager;
import com.atlassian.bamboo.resultsummary.warning.BuildResultWarningSummaryManager;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.ww2.aware.permissions.PlanReadSecurityAware;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class ViewChainResult
extends ChainResultsAction
implements PlanReadSecurityAware {
    private static final Logger log = Logger.getLogger(ViewChainResult.class);
    private static final int DEFAULT_DISPLAY_LINES = 25;
    private static final String BAMBOO_MAX_DISPLAY_LINES = "BAMBOO-MAX-DISPLAY-LINES";
    private FilteredTestResults<TestClassResultDescriptor> filteredTestResults;
    private boolean commentMode;
    private int linesToDisplay;
    private String jobResultKeyForLogDisplay;
    private List<DeploymentProjectStatusForResultSummary> relatedDeployments;
    private Map<Long, List<Comment>> commentsByEntity;
    private Collection<BuildWarningSummary> warnings;
    @Autowired
    private DeploymentProjectService deploymentProjectService;
    @Autowired
    private CommentService commentService;
    @Autowired
    private BuildResultWarningSummaryManager buildResultWarningSummaryManager;

    @Nullable
    public Job getJobForKey(String planKey) {
        return (Job)this.planManager.getPlanByKey(planKey, Job.class);
    }

    public String execute() throws Exception {
        if (this.getImmutableChain() == null || this.getImmutableChain().isMarkedForDeletion()) {
            this.addActionError(this.getText("chain.error.noChain", Lists.newArrayList((Object[])new String[]{this.getPlanKey()})));
            return "error";
        }
        if (this.getChainResult() == null) {
            if (this.getChainResultNumber() > 0) {
                PlanResultKey planResultKey = PlanKeys.getPlanResultKey((PlanKey)this.getImmutableChain().getPlanKey(), (int)this.getChainResultNumber());
                ChainResultsSummary chainResult = (ChainResultsSummary)this.resultsSummaryManager.getResultsSummary(planResultKey, ChainResultsSummary.class);
                if (chainResult == null) {
                    this.addActionError(this.getText("chain.error.noChainResult", Lists.newArrayList((Object[])new String[]{this.getPlanKey() + "-" + this.getChainResultNumber()})));
                    return "error";
                }
                this.setChainResult(chainResult);
            } else {
                this.addActionError(this.getText("chain.error.noChainResult", Lists.newArrayList((Object[])new String[]{this.getPlanKey() + "-" + this.getChainResultNumber()})));
                return "error";
            }
        }
        if (this.linesToDisplay <= 0) {
            this.linesToDisplay = NumberUtils.toInt((String)this.cookieCutter.getValueFromCookie(BAMBOO_MAX_DISPLAY_LINES), (int)25);
        }
        if (this.linesToDisplay <= 0) {
            this.linesToDisplay = 25;
        }
        this.cookieCutter.saveValueInCookie(BAMBOO_MAX_DISPLAY_LINES, String.valueOf(this.linesToDisplay));
        this.commentsByEntity = this.commentService.getAllCommentsForPlanResult(this.getChainResult());
        return super.execute();
    }

    public FilteredTestResults<TestClassResultDescriptor> getFilteredTestResults() {
        if (this.filteredTestResults == null) {
            this.filteredTestResults = ChainFilteredTestResults.newInstance((TestsManager)this.testsManager, (TestQuarantineManager)this.testQuarantineManager, (ChainResultsSummary)this.getChainResult(), (int)0, (int)this.getDefaultPageSizeForTests());
        }
        return this.filteredTestResults;
    }

    public Collection<BuildWarningSummary> getWarnings() {
        if (this.warnings == null) {
            this.warnings = this.buildResultWarningSummaryManager.findByResultSummary(this.getChainResult().getId());
        }
        return this.warnings;
    }

    public long getWarningsCount() {
        return this.getWarnings().stream().mapToLong(warning -> warning.getHighPriorityCount() + warning.getNormalPriorityCount() + warning.getLowPriorityCount()).sum();
    }

    public List<ResultsSummary> getJobResultSummaries() {
        return this.getChainResult().getOrderedJobResultSummaries();
    }

    public Collection<ArtifactLink> getSharedArtifactLinks(BuildResultsSummary jobResults) {
        return jobResults.getProducedArtifactLinks().stream().filter(ArtifactLinkPredicates::isSharedArtifact).collect(Collectors.toCollection(LinkedList::new));
    }

    public boolean hasSharedArtifacts(ChainResultsSummary chainResultsSummary) {
        return !chainResultsSummary.getArtifactLinks().isEmpty();
    }

    @Nullable
    public BuildAgent getAgent(@Nullable Long agentId) {
        if (agentId == null) {
            return null;
        }
        return this.agentManager.getAgent(agentId.longValue());
    }

    protected int getDefaultPageSizeForTests() {
        return 50;
    }

    public boolean isCommentMode() {
        return this.commentMode;
    }

    public void setCommentMode(boolean commentMode) {
        this.commentMode = commentMode;
    }

    public int getLinesToDisplay() {
        return this.linesToDisplay;
    }

    public void setLinesToDisplay(int linesToDisplay) {
        this.linesToDisplay = linesToDisplay;
    }

    public StageIdentifier getStageToRestart() {
        return ContinuableStageHelper.getStageToRestart(this.getChainResult());
    }

    public String getJobResultKeyForLogDisplay() {
        if (this.jobResultKeyForLogDisplay == null && this.getChainResult().isInProgress()) {
            this.jobResultKeyForLogDisplay = this.getChainResult().getStageResults().stream().flatMap(stageResult -> stageResult.getBuildResults().stream()).filter(ResultSummaryPredicates::isInProgress).findFirst().map(resultsSummary -> resultsSummary.getPlanKey().getKey()).orElse(null);
        }
        return this.jobResultKeyForLogDisplay;
    }

    public List<DeploymentProjectStatusForResultSummary> getRelatedDeployments() {
        if (this.relatedDeployments == null) {
            this.relatedDeployments = this.deploymentProjectService.getDeploymentProjectsWithStatusesRelatedToPlanResult((ResultsSummary)this.getChainResult());
        }
        return this.relatedDeployments;
    }

    public Map<Long, List<Comment>> getCommentsByEntityId() {
        return this.commentsByEntity;
    }
}

