/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.chains;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.BuildOutputLogEntry;
import com.atlassian.bamboo.build.ErrorLogEntry;
import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.logger.BuildLogFileAccessor;
import com.atlassian.bamboo.build.logger.BuildLogFileAccessorFactory;
import com.atlassian.bamboo.build.logger.BuildLoggerWithoutLogAccess;
import com.atlassian.bamboo.configuration.external.RepositoryStoredSpecsLogService;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.ww2.actions.chains.ViewChainResult;
import com.google.common.collect.Lists;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.apache.log4j.Logger;

public class ViewChainLogs
extends ViewChainResult {
    private static final Logger log = Logger.getLogger(ViewChainLogs.class);
    @Inject
    private BuildLogFileAccessorFactory buildLogFileAccessorFactory;
    @Inject
    private RepositoryStoredSpecsLogService repositoryStoredSpecsLogService;
    @Inject
    private BuildLoggerManager buildLoggerManager;
    private int logLines = 25;

    public List<LogEntry> retrieveBuildLogs(BuildResultsSummary buildResultsSummary) {
        try {
            BuildLogFileAccessor fileAccessor = this.buildLogFileAccessorFactory.createBuildLogFileAccessor((Key)buildResultsSummary.getPlanKey(), buildResultsSummary.getBuildNumber());
            return fileAccessor.getLastNLogsOfType(this.logLines, (Collection)Lists.newArrayList((Object[])new Class[]{BuildOutputLogEntry.class, ErrorLogEntry.class}));
        }
        catch (FileNotFoundException e) {
            log.warn((Object)("Failed to load build log as file doesn't exist yet " + this.getPlanKey() + "-" + buildResultsSummary.getBuildNumber()));
        }
        catch (Exception e) {
            log.error((Object)("Failed to load build logs for build " + this.getPlanKey() + "-" + buildResultsSummary.getBuildNumber()), (Throwable)e);
        }
        return Collections.emptyList();
    }

    public boolean isLogFileAccessible(BuildResultsSummary buildResultsSummary) {
        if (buildResultsSummary.isFinished()) {
            return true;
        }
        if (buildResultsSummary.isInProgress()) {
            BuildLoggerWithoutLogAccess buildLogger = this.buildLoggerManager.getLoggerWithoutLogAccess((Key)buildResultsSummary.getPlanResultKey());
            return buildLogger.isPersistent();
        }
        return false;
    }

    public List<LogEntry> retrieveBambooSpecsExecutionLogs() {
        try {
            RepositoryStoredSpecsLogService.RepositoryStoredSpecsLogAccessor logAccessor = this.repositoryStoredSpecsLogService.getBambooSpecsExecutionLogAccessor(this.getChainResult().getPlanResultKey());
            if (logAccessor != null) {
                return logAccessor.getLastN(this.logLines);
            }
        }
        catch (IOException | IllegalStateException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return Collections.emptyList();
    }

    public boolean isSpecExecutionLogExists() {
        Path logFile = this.repositoryStoredSpecsLogService.getBambooSpecsExecutionLogFile(this.getChainResult().getPlanResultKey());
        return logFile != null && Files.exists(logFile, new LinkOption[0]);
    }

    public boolean isSpecsExecutionDatePresent() {
        try {
            RepositoryStoredSpecsLogService.RepositoryStoredSpecsLogAccessor logAccessor = this.repositoryStoredSpecsLogService.getBambooSpecsExecutionLogAccessor(this.getChainResult().getPlanResultKey());
            if (logAccessor != null) {
                return logAccessor.isDatePresent();
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public int getLogLines() {
        return this.logLines;
    }

    public void setLogLines(int logLines) {
        this.logLines = logLines;
    }
}

