/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.chains;

import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.build.artifact.ArtifactLinkPredicates;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.ww2.actions.chains.ViewChainResult;
import com.atlassian.bamboo.ww2.aware.permissions.PlanReadSecurityAware;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class ViewChainArtifacts
extends ViewChainResult
implements PlanReadSecurityAware {
    private static final Logger log = Logger.getLogger(ViewChainArtifacts.class);

    public Collection<ArtifactLink> getJobArtifactLinks(BuildResultsSummary jobResults) {
        return jobResults.getArtifactLinks();
    }

    public Collection<ArtifactLink> getOrphanedArtifactLinks(ChainResultsSummary chainResults) {
        return chainResults.getArtifactLinks().stream().filter(ArtifactLinkPredicates::isOrphanedArtifact).collect(Collectors.toCollection(LinkedList::new));
    }

    public boolean hasFinishedJobs(ChainResultsSummary chainResultsSummary) {
        ChainStageResult stageResult = (ChainStageResult)Iterables.getFirst((Iterable)chainResultsSummary.getStageResults(), null);
        if (stageResult != null) {
            return stageResult.getBuildResults().stream().anyMatch(ImmutableResultsSummary::isFinished);
        }
        return false;
    }

    public boolean hasJobArtifacts(ChainResultsSummary chainResultsSummary) {
        for (ChainStageResult stageResult : chainResultsSummary.getStageResults()) {
            for (BuildResultsSummary resultsSummary : stageResult.getBuildResults()) {
                if (resultsSummary.getArtifactLinks().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }
}

