/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.chains;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.agent.elastic.server.ElasticFunctionalityFacade;
import com.atlassian.bamboo.build.creation.PlanValidationService;
import com.atlassian.bamboo.chains.ChainStage;
import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.deployments.projects.service.DeploymentProjectService;
import com.atlassian.bamboo.event.analytics.PlanConfigurationChangedAnalyticsEvent;
import com.atlassian.bamboo.persister.AuditLogEntity;
import com.atlassian.bamboo.persister.AuditLogEntityType;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.plan.branch.ChainStagePropagatingFacade;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.ww2.actions.ChainActionSupport;
import com.atlassian.bamboo.ww2.actions.plans.AgentAvailabilityHintHelper;
import com.atlassian.bamboo.ww2.aware.permissions.PlanEditSecurityAware;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.struts.ValidationAware;
import com.google.common.collect.Lists;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class StageAction
extends ChainActionSupport
implements PlanEditSecurityAware {
    private static final Logger log = Logger.getLogger(StageAction.class);
    protected String stageId;
    protected String stageName;
    protected String stageDescription;
    protected boolean stageManual;
    protected boolean finalStage;
    private static final String STAGE_NAME = "stageName";
    private static final String STAGE_DESCRIPTION = "stageDescription";
    private List<DeploymentProject> relatedDeploymentProjects;
    private PlanValidationService planValidationService;
    private ElasticFunctionalityFacade elasticFunctionalityFacade;
    protected AuditLogService auditLogService;
    @Autowired
    private DeploymentProjectService deploymentProjectService;
    @Autowired
    private EventPublisher eventPublisher;

    public String execute() throws Exception {
        ChainStage paramChainStage = this.getMutableChainStage();
        if (paramChainStage == null) {
            this.addActionError("Could not edit stage, no stage found");
            return "error";
        }
        ChainStagePropagatingFacade stages = new ChainStagePropagatingFacade(this.chainBranchManager, paramChainStage);
        String oldName = stages.getName();
        String oldDescription = stages.getDescription();
        boolean oldIsManual = stages.isManual();
        boolean oldIsFinal = stages.isFinal();
        stages.setName(this.stageName);
        stages.setDescription(StringUtils.defaultString((String)this.stageDescription));
        stages.setManual(this.stageManual);
        stages.setFinal(this.finalStage);
        stages.savePlan(this.planManager);
        this.auditLogService.log(STAGE_NAME, oldName, this.stageName, (Key)this.getImmutablePlan().getPlanKey(), AuditLogEntityType.PLAN, new AuditLogEntity(AuditLogEntityType.STAGE, this.stageName));
        this.auditLogService.log(STAGE_DESCRIPTION, oldDescription, StringUtils.defaultString((String)this.stageDescription), (Key)this.getImmutablePlan().getPlanKey(), AuditLogEntityType.PLAN, new AuditLogEntity(AuditLogEntityType.STAGE, this.stageName));
        this.auditLogService.log("isManualStage", Boolean.toString(oldIsManual), Boolean.toString(this.stageManual), (Key)this.getImmutablePlan().getPlanKey(), AuditLogEntityType.PLAN, new AuditLogEntity(AuditLogEntityType.STAGE, this.stageName));
        this.auditLogService.log("isFinalStage", Boolean.toString(oldIsFinal), Boolean.toString(this.finalStage), (Key)this.getImmutablePlan().getPlanKey(), AuditLogEntityType.PLAN, new AuditLogEntity(AuditLogEntityType.STAGE, this.stageName));
        this.triggerAnalyticsEvent();
        return "success";
    }

    protected void triggerAnalyticsEvent() {
        this.eventPublisher.publish((Object)new PlanConfigurationChangedAnalyticsEvent());
    }

    @NotNull
    protected JSONObject buildStageJsonObject() throws JSONException {
        ImmutableChainStage chainStage = this.getImmutableChainStage();
        return new JSONObject().put("id", chainStage.getId()).put("name", (Object)chainStage.getName()).put("description", (Object)chainStage.getDescription()).put("manual", chainStage.isManual()).put("finalStage", chainStage.isFinal());
    }

    @Override
    @NotNull
    protected JSONObject buildJsonObject() throws JSONException {
        return super.buildJsonObject().put("stage", (Object)this.buildStageJsonObject());
    }

    @Override
    public String doDefault() throws Exception {
        if (this.isEdit()) {
            ImmutableChainStage chainStage = this.getImmutableChainStage();
            if (chainStage == null) {
                this.addActionError("Could not edit stage, no stage found");
                return "error";
            }
            this.setStageName(chainStage.getName());
            this.setStageDescription(chainStage.getDescription());
            this.setStageManual(chainStage.isManual());
            this.setFinalStage(chainStage.isFinal());
        }
        return "input";
    }

    public void validate() {
        if (this.getImmutableChain() == null) {
            this.addActionError(this.getText("chain.error.noChain", Lists.newArrayList((Object[])new String[]{this.getPlanKey()})));
            return;
        }
        this.planValidationService.validateName((ValidationAware)this, STAGE_NAME, "stage", this.stageName);
        this.stageName = StringUtils.trim((String)this.stageName);
        if (!(this.isEdit() && this.getImmutableChainStage().getName().equals(this.stageName) || !this.getImmutableChain().containsStage(this.stageName))) {
            this.addFieldError(STAGE_NAME, this.getText("stage.name.exists"));
        }
        this.planValidationService.validateDescription((ValidationAware)this, STAGE_DESCRIPTION, this.stageDescription);
    }

    @Nullable
    public String getAgentUnavailabilityHint(@NotNull ImmutableJob job) {
        return AgentAvailabilityHintHelper.getAgentUnavailabilityHint(this.executableAgentsHelper, this.elasticFunctionalityFacade, this.administrationConfigurationAccessor, this, job, true);
    }

    public List<DeploymentProject> getRelatedDeploymentProjects() {
        if (this.relatedDeploymentProjects == null) {
            this.relatedDeploymentProjects = this.deploymentProjectService.getDeploymentProjectsRelatedToPlan(this.getImmutablePlan().getPlanKey());
        }
        return this.relatedDeploymentProjects;
    }

    private boolean isEdit() {
        return this.getImmutableChainStage() != null;
    }

    @Nullable
    public String getStageName() {
        return this.stageName;
    }

    public void setStageName(String stageName) {
        this.stageName = stageName;
    }

    @Nullable
    public String getStageDescription() {
        return this.stageDescription;
    }

    public void setStageDescription(String stageDescription) {
        this.stageDescription = stageDescription;
    }

    public boolean isStageManual() {
        return this.stageManual;
    }

    public void setStageManual(boolean stageManual) {
        this.stageManual = stageManual;
    }

    public boolean isFinalStage() {
        return this.finalStage;
    }

    public void setFinalStage(boolean finalStage) {
        this.finalStage = finalStage;
    }

    public String getStageId() {
        return this.stageId;
    }

    public void setStageId(String stageId) {
        this.stageId = stageId;
    }

    public void setPlanValidationService(PlanValidationService planValidationService) {
        this.planValidationService = planValidationService;
    }

    public void setElasticFunctionalityFacade(ElasticFunctionalityFacade elasticFunctionalityFacade) {
        this.elasticFunctionalityFacade = elasticFunctionalityFacade;
    }

    public void setAuditLogService(AuditLogService auditLogService) {
        this.auditLogService = auditLogService;
    }
}

