/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.chains;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.chains.ChainStage;
import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.exception.WebValidationException;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscription;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.stage.StageService;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.ww2.actions.ChainActionSupport;
import com.atlassian.bamboo.ww2.aware.RssConfigurationAware;
import com.atlassian.bamboo.ww2.aware.permissions.PlanAdminSecurityAware;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class MoveStageAction
extends ChainActionSupport
implements PlanAdminSecurityAware {
    private int index = -1;
    private long stageId;
    private List<ArtifactSubscription> invalidSubscriptions;
    private boolean removeBrokenSubscriptions;
    @Autowired
    private ArtifactSubscriptionManager artifactSubscriptionManager;
    @Autowired
    private StageService stageService;

    public void validate() {
        ImmutableChainStage stage;
        super.validate();
        if (this.index < 0) {
            this.addActionError(this.getText("stage.move.invalidIndex"));
        }
        if ((stage = this.getImmutableChainStage()) == null) {
            this.addActionError(this.getText("stage.move.noStage"));
        } else {
            ImmutableChain chain = stage.getChain();
            if (!chain.getStages().contains(stage)) {
                this.addActionError(this.getText("stage.move.wrongPlan", Arrays.asList(stage.getName(), this.getPlanKey())));
            }
        }
    }

    @Override
    @NotNull
    protected JSONObject buildJsonObject() throws JSONException {
        JSONObject result = super.buildJsonObject();
        if (!CollectionUtils.isEmpty(this.invalidSubscriptions)) {
            result.put("status", (Object)"confirm".toUpperCase());
        }
        return result;
    }

    @RssConfigurationAware
    @NotNull
    public String move() {
        ImmutableChainStage stage = this.getImmutableChainStage();
        this.invalidSubscriptions = this.artifactSubscriptionManager.validateSubscriptionsForMovedStage(stage, this.index);
        if (!this.invalidSubscriptions.isEmpty() && !this.removeBrokenSubscriptions) {
            return "confirm";
        }
        try {
            this.invalidSubscriptions.clear();
            this.stageService.moveStage(this.getTypedPlanKey(), this.stageId, this.index);
        }
        catch (WebValidationException e) {
            this.addErrorCollection(e.getErrorCollection());
            return "error";
        }
        return "success";
    }

    public String confirm() {
        ImmutableChainStage stage = this.getImmutableChainStage();
        this.invalidSubscriptions = this.artifactSubscriptionManager.validateSubscriptionsForMovedStage(stage, this.index);
        return "input";
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public long getStageId() {
        return this.stageId;
    }

    public void setStageId(long stageId) {
        this.stageId = stageId;
    }

    public boolean isRemoveBrokenSubscriptions() {
        return this.removeBrokenSubscriptions;
    }

    public void setRemoveBrokenSubscriptions(boolean removeBrokenSubscriptions) {
        this.removeBrokenSubscriptions = removeBrokenSubscriptions;
    }

    public Multimap<ChainStage, Job> getJobsContainingInvalidSubscriptions() {
        TreeMultimap result = TreeMultimap.create((Comparator)Ordering.explicit((List)this.getMutableChain().getStages()), (Comparator)Comparators.getNameProviderCaseInsensitiveOrdering());
        this.invalidSubscriptions.stream().map(ArtifactSubscription::getConsumerJob).collect(Collectors.toSet()).forEach(arg_0 -> MoveStageAction.lambda$getJobsContainingInvalidSubscriptions$0((Multimap)result, arg_0));
        return result;
    }

    private static /* synthetic */ void lambda$getJobsContainingInvalidSubscriptions$0(Multimap result, Job job) {
        result.put((Object)job.getStage(), (Object)job);
    }
}

