/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.chains;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.chains.ChainStage;
import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscription;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionManager;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionsFunctions;
import com.atlassian.bamboo.plan.branch.ChainBranchManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.ww2.actions.ChainActionSupport;
import com.atlassian.bamboo.ww2.aware.RssConfigurationAware;
import com.atlassian.bamboo.ww2.aware.permissions.PlanAdminSecurityAware;
import com.google.common.collect.Collections2;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class MoveJobAction
extends ChainActionSupport
implements PlanAdminSecurityAware {
    private String jobKey;
    private long stageId;
    private ArtifactSubscriptionManager artifactSubscriptionManager;
    private List<ArtifactSubscription> invalidSubscriptionsToJob;
    private List<ArtifactSubscription> invalidSubscriptionsOfJob;
    private boolean removeBrokenSubscriptions;
    private ChainBranchManager chainBranchManager;

    @Override
    @NotNull
    protected JSONObject buildJsonObject() throws JSONException {
        JSONObject result = super.buildJsonObject();
        if (!CollectionUtils.isEmpty(this.invalidSubscriptionsToJob) || !CollectionUtils.isEmpty(this.invalidSubscriptionsOfJob)) {
            result.put("status", (Object)"confirm".toUpperCase());
        }
        return result;
    }

    @RssConfigurationAware
    public String execute() {
        ImmutableChain chain = this.getImmutableChain();
        if (chain == null) {
            this.addActionError(this.getText("job.move.noPlan", Collections.singletonList(this.getPlanKey())));
            return "error";
        }
        Plan plan = this.planManager.getPlanByKey(this.jobKey, Plan.class);
        if (plan == null) {
            this.addActionError(this.getText("job.move.noJob", Collections.singletonList(this.jobKey)));
            return "error";
        }
        Job job = (Job)Narrow.to((Object)plan, Job.class);
        if (job == null) {
            this.addActionError(this.getText("job.move.isNotJob", Arrays.asList(plan.getClass(), this.jobKey)));
            return "error";
        }
        if (!chain.equals(job.getParent())) {
            this.addActionError(this.getText("job.move.wrongPlan", Collections.singletonList(this.getJobKey())));
            return "error";
        }
        ChainStage toStage = this.getMutableChainStage();
        if (toStage == null) {
            this.addActionError(this.getText("job.move.noStage"));
            return "error";
        }
        this.invalidSubscriptionsToJob = this.artifactSubscriptionManager.validateSubscribersForMovedJob((ImmutableJob)job, (ImmutableChainStage)toStage);
        if (this.invalidSubscriptionsToJob.isEmpty()) {
            this.invalidSubscriptionsOfJob = this.artifactSubscriptionManager.validateSubscriptions((ImmutableJob)job, chain, toStage.getName());
        }
        if (!this.invalidSubscriptionsToJob.isEmpty() || !this.invalidSubscriptionsOfJob.isEmpty()) {
            if (this.removeBrokenSubscriptions) {
                if (!this.invalidSubscriptionsToJob.isEmpty()) {
                    this.artifactSubscriptionManager.removeArtifactSubscriptions(this.invalidSubscriptionsToJob);
                    this.invalidSubscriptionsToJob.clear();
                } else {
                    this.artifactSubscriptionManager.removeArtifactSubscriptions(this.invalidSubscriptionsOfJob);
                    this.invalidSubscriptionsOfJob.clear();
                }
            } else {
                return "confirm";
            }
        }
        job.getStage().removeJob(job);
        toStage.addJob(job);
        this.planManager.savePlan((Plan)toStage.getChain());
        return "success";
    }

    public String confirm() {
        ImmutableChain chain = this.getImmutableChain();
        ImmutableChainStage toStage = this.getImmutableChainStage();
        Job job = (Job)this.planManager.getPlanByKey(this.jobKey, Job.class);
        if (job == null) {
            throw new IllegalStateException("Job cannot be null in doConfirm()");
        }
        this.invalidSubscriptionsToJob = this.artifactSubscriptionManager.validateSubscribersForMovedJob((ImmutableJob)job, toStage);
        if (this.invalidSubscriptionsToJob.isEmpty()) {
            this.invalidSubscriptionsOfJob = this.artifactSubscriptionManager.validateSubscriptions((ImmutableJob)job, chain, toStage.getName());
        }
        return "input";
    }

    public String getJobKey() {
        return this.jobKey;
    }

    public void setJobKey(String jobKey) {
        this.jobKey = jobKey;
    }

    public long getStageId() {
        return this.stageId;
    }

    public void setStageId(long stageId) {
        this.stageId = stageId;
    }

    public boolean isRemoveBrokenSubscriptions() {
        return this.removeBrokenSubscriptions;
    }

    public void setRemoveBrokenSubscriptions(boolean removeBrokenSubscriptions) {
        this.removeBrokenSubscriptions = removeBrokenSubscriptions;
    }

    public void setArtifactSubscriptionManager(ArtifactSubscriptionManager artifactSubscriptionManager) {
        this.artifactSubscriptionManager = artifactSubscriptionManager;
    }

    public Multimap<ChainStage, Job> getJobsContainingInvalidSubscriptions() {
        TreeMultimap result = TreeMultimap.create((Comparator)Ordering.explicit((List)this.getMutableChain().getStages()), (Comparator)Comparators.getNameProviderCaseInsensitiveOrdering());
        if (CollectionUtils.isEmpty(this.invalidSubscriptionsOfJob)) {
            for (Job job : Sets.newHashSet((Iterable)Collections2.transform(this.invalidSubscriptionsToJob, ArtifactSubscriptionsFunctions::getConsumerJob))) {
                result.put((Object)job.getStage(), (Object)job);
            }
        } else {
            result.put((Object)this.invalidSubscriptionsOfJob.get(0).getConsumerJob().getStage(), (Object)this.invalidSubscriptionsOfJob.get(0).getConsumerJob());
        }
        return result;
    }

    @Override
    public void setChainBranchManager(ChainBranchManager chainBranchManager) {
        this.chainBranchManager = chainBranchManager;
    }
}

