/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.chains;

import com.atlassian.bamboo.artifact.Artifact;
import com.atlassian.bamboo.build.artifact.ArtifactHandlingUtils;
import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.build.artifact.ArtifactLinkManager;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.filter.Pager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.ww2.actions.ChainActionSupport;
import com.atlassian.bamboo.ww2.aware.LazyPaginationAware;
import com.atlassian.bamboo.ww2.aware.permissions.PlanReadSecurityAware;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class ListChainResults
extends ChainActionSupport
implements LazyPaginationAware<ChainResultsSummary>,
PlanReadSecurityAware {
    private static final Logger log = Logger.getLogger(ListChainResults.class);
    private Pager pager;
    @Autowired
    private ArtifactLinkManager artifactLinkManager;

    @Override
    public Pager getPager() {
        return this.pager;
    }

    @Override
    public void setPager(Pager pager) {
        this.pager = pager;
    }

    public List<ChainResultsSummary> getResultsList() {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public List<ChainResultsSummary> getFilteredResultsList(int firstResult, int maxResults) {
        return this.resultsSummaryManager.getFinalizedResultSummariesForPlan(this.getImmutableChain().getPlanKey(), ChainResultsSummary.class, firstResult, maxResults);
    }

    @Override
    public int getResultsCount() {
        return (int)this.resultsSummaryManager.getNumberOfFinalizedResults((ImmutablePlan)this.getImmutableChain());
    }

    public String execute() throws Exception {
        return "success";
    }

    public String getDateFinished(@NotNull ChainResultsSummary chainResult) {
        BuildResultsSummary latestBuildResultSummary = null;
        for (ChainStageResult stageResult : chainResult.getStageResults()) {
            for (BuildResultsSummary buildResultsSummary : stageResult.getBuildResults()) {
                if (!LifeCycleState.isFinished((LifeCycleState)buildResultsSummary.getLifeCycleState()) || latestBuildResultSummary != null && (latestBuildResultSummary.getBuildCompletedDate() == null || buildResultsSummary.getBuildCompletedDate() == null || !latestBuildResultSummary.getBuildCompletedDate().before(buildResultsSummary.getBuildCompletedDate()))) continue;
                latestBuildResultSummary = buildResultsSummary;
            }
        }
        return latestBuildResultSummary != null ? latestBuildResultSummary.getRelativeBuildDate() : "";
    }

    public int getNumberOfBuildsRun(@NotNull ChainResultsSummary chainResult) {
        int numberOfBuildsRun = 0;
        for (ChainStageResult chainStageResult : chainResult.getStageResults()) {
            for (BuildResultsSummary buildResultSummary : chainStageResult.getBuildResults()) {
                if (!LifeCycleState.isFinished((LifeCycleState)buildResultSummary.getLifeCycleState())) continue;
                ++numberOfBuildsRun;
            }
        }
        return numberOfBuildsRun;
    }

    @Nullable
    public final String getArtifactLinkUrl(ArtifactLink artifactLink) {
        return ArtifactHandlingUtils.getArtifactUrl((ArtifactLinkManager)this.artifactLinkManager, (Artifact)artifactLink.getArtifact(), (String)this.getBambooUrl().rootContext());
    }
}

