/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.chains;

import com.atlassian.bamboo.build.BuildTriggerCondition;
import com.atlassian.bamboo.build.creation.PlanCreationTemplate;
import com.atlassian.bamboo.build.creation.PlanValidationService;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.event.analytics.PlanConfigurationChangedAnalyticsEvent;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanClassHelper;
import com.atlassian.bamboo.plan.branch.ImmutableChainPropagatingFacade;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plugin.web.PlanConfigurationUIPluginHelper;
import com.atlassian.bamboo.ww2.actions.ChainActionSupport;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.bamboo.ww2.aware.BuildConfigurationAware;
import com.atlassian.bamboo.ww2.aware.RssConfigurationAware;
import com.atlassian.bamboo.ww2.aware.permissions.PlanEditSecurityAware;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.struts.ValidationAware;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class EditChainDetails
extends ChainActionSupport
implements PlanEditSecurityAware,
BuildConfigurationAware {
    private static final Logger log = Logger.getLogger(EditChainDetails.class);
    private static final String CHAIN_NAME = "chainName";
    private static final String CHAIN_DESCRIPTION = "chainDescription";
    private String chainName;
    private String chainDescription;
    private boolean enabled;
    private boolean saved;
    private BuildConfiguration buildConfiguration;
    @Autowired
    private PlanValidationService planValidationService;
    @Autowired
    private PlanConfigurationUIPluginHelper planConfigurationUIPluginHelper;
    @Autowired
    private EventPublisher eventPublisher;

    @Override
    public String doDefault() {
        ImmutablePlan build = this.getImmutablePlan();
        if (!PlanClassHelper.isChain((ImmutablePlan)build)) {
            this.addActionError(this.getText("build.error.plan.not.exists", Collections.singletonList(this.getPlanKey())));
            return "error";
        }
        this.chainName = this.getImmutableChain().getBuildName();
        this.chainDescription = this.getImmutableChain().getDescription();
        this.enabled = !this.getImmutableChain().isSuspendedFromBuilding();
        return "input";
    }

    public void validate() {
        this.planValidationService.validateName((ValidationAware)this, CHAIN_NAME, "chain", this.chainName);
        this.planValidationService.validateDescription((ValidationAware)this, CHAIN_DESCRIPTION, this.chainDescription);
        boolean isNameConflicting = this.planManager.isChainNameConflicting(this.getImmutableChain().getProject().getKey(), this.getImmutableChain().getId(), this.chainName);
        if (isNameConflicting) {
            this.addFieldError(CHAIN_NAME, this.getText("chain.name.exists"));
        }
    }

    @RssConfigurationAware
    public String execute() throws Exception {
        Chain chain = this.getMutableChain();
        PlanCreationTemplate.cleanBuildConfiguration((BuildConfiguration)this.buildConfiguration);
        chain.setBuildName(this.chainName);
        chain.setDescription(this.chainDescription);
        chain.setSuspendedFromBuilding(!this.enabled);
        this.buildDefinitionManager.savePlanAndDefinition((Plan)chain, this.buildConfiguration);
        log.info((Object)("Build configuration for '" + this.getImmutableChain().getKey() + "' saved."));
        ImmutableChainPropagatingFacade chainPropagatingFacade = new ImmutableChainPropagatingFacade(this.cachedPlanManager, this.getImmutableChain());
        chainPropagatingFacade.publishBuildConfigurationUpdatedEvent(this.eventPublisher, (Object)this, true);
        this.eventPublisher.publish((Object)new PlanConfigurationChangedAnalyticsEvent());
        return "success";
    }

    @Override
    public BuildConfiguration getBuildConfiguration() {
        return this.buildConfiguration;
    }

    @Override
    public void setBuildConfiguration(BuildConfiguration buildConfiguration) {
        this.buildConfiguration = buildConfiguration;
    }

    @NotNull
    public String getTriggerConditionEditHtml() {
        return this.planConfigurationUIPluginHelper.getEditHtml(this.getBuildConfiguration(), this.getMutablePlan(), BuildTriggerCondition.class);
    }

    public boolean isSaved() {
        return this.saved;
    }

    public void setSaved(boolean saved) {
        this.saved = saved;
    }

    public String getChainName() {
        return this.chainName;
    }

    public void setChainName(String chainName) {
        this.chainName = chainName;
    }

    public String getChainDescription() {
        return this.chainDescription;
    }

    public void setChainDescription(String chainDescription) {
        this.chainDescription = chainDescription;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

