/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.chains;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.chains.ChainStage;
import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.deletion.DeletionService;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionManager;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionsFunctions;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.ww2.actions.chains.StageAction;
import com.atlassian.bamboo.ww2.aware.RssConfigurationAware;
import com.atlassian.bamboo.ww2.aware.permissions.PlanAdminSecurityAware;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class DeleteStageAction
extends StageAction
implements PlanAdminSecurityAware {
    private DeletionService deletionService;
    private ArtifactSubscriptionManager artifactSubscriptionManager;

    @Override
    public String doDefault() throws Exception {
        ImmutableChainStage stage = this.getImmutableChainStage();
        if (stage == null) {
            this.addActionError("Could not delete stage, no stage found");
            return "error";
        }
        this.setStageName(stage.getName());
        this.setStageDescription(stage.getDescription());
        return "input";
    }

    @RssConfigurationAware
    public String delete() {
        ImmutableChainStage stage = this.getImmutableChainStage();
        if (stage == null) {
            this.addActionError("Could not delete stage, no stage found");
            return "error";
        }
        this.deletionService.deleteStage(stage);
        this.triggerAnalyticsEvent();
        return "success";
    }

    public Multimap<ChainStage, Job> getJobsContainingInvalidSubscriptions() {
        ArrayList invalidSubscriptions = new ArrayList();
        for (Job job : this.getMutableChainStage().getJobs()) {
            invalidSubscriptions.addAll(this.artifactSubscriptionManager.findCurrentSubscriptionsForPlan((ImmutableJob)job));
        }
        TreeMultimap result = TreeMultimap.create((Comparator)Ordering.explicit((List)this.getMutableChain().getStages()), (Comparator)Comparators.getNameProviderCaseInsensitiveOrdering());
        if (!CollectionUtils.isEmpty(invalidSubscriptions)) {
            for (Job job : invalidSubscriptions.stream().map(ArtifactSubscriptionsFunctions::getConsumerJob).collect(Collectors.toSet())) {
                result.put((Object)job.getStage(), (Object)job);
            }
        }
        return result;
    }

    public void setDeletionService(DeletionService deletionService) {
        this.deletionService = deletionService;
    }

    public void setArtifactSubscriptionManager(ArtifactSubscriptionManager artifactSubscriptionManager) {
        this.artifactSubscriptionManager = artifactSubscriptionManager;
    }
}

