/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.chains;

import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.build.PlanCreationDeniedException;
import com.atlassian.bamboo.build.PlanCreationException;
import com.atlassian.bamboo.build.creation.JobCreationService;
import com.atlassian.bamboo.build.creation.PlanCreationService;
import com.atlassian.bamboo.build.docker.BuildEnvironmentType;
import com.atlassian.bamboo.build.docker.DockerConfigurationProviders;
import com.atlassian.bamboo.builder.JdkManager;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainStage;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.event.analytics.PlanConfigurationChangedAnalyticsEvent;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanPredicates;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscription;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionManager;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionsFunctions;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.webwork.util.ActionParametersMapImpl;
import com.atlassian.bamboo.ww2.actions.ChainActionSupport;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.bamboo.ww2.actions.build.admin.create.UIConfigSupport;
import com.atlassian.bamboo.ww2.aware.BuildConfigurationAware;
import com.atlassian.bamboo.ww2.aware.PlanLimitAware;
import com.atlassian.bamboo.ww2.aware.RssConfigurationAware;
import com.atlassian.bamboo.ww2.aware.permissions.PlanAdminSecurityAware;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.struts.ValidationAware;
import com.google.common.collect.Collections2;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import com.opensymphony.xwork2.ActionContext;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateJob
extends ChainActionSupport
implements PlanLimitAware,
PlanAdminSecurityAware,
BuildConfigurationAware {
    private static final Logger log = Logger.getLogger(CreateJob.class);
    private static final String PERMISSION_DENIED_ERROR = "planCreationDeniedError";
    public static final String EXISTING_STAGE = "existingStage";
    public static final String BUILD_KEY = "buildKey";
    public static final String CLONE_JOB = "cloneJob";
    public static final String JOB_KEY_TO_CLONE = "jobKeyToClone";
    public static final String CHAIN_KEY_TO_CLONE = "chainKeyToClone";
    private BuildConfiguration buildConfiguration;
    private String subBuildKey;
    private boolean planLimitReached = false;
    private boolean allowStageCreation = false;
    private JobCreationService jobCreationService;
    private UIConfigSupport uiConfigBean;
    private ArtifactSubscriptionManager artifactSubscriptionManager;
    private String isolationType = BuildEnvironmentType.AGENT.name();
    private List<DockerConfigurationProviders.Config> dockerHandlers;
    private JdkManager jdkManager;
    private Collection<String> availableJdks;
    private Collection<ImmutableChain> chainsToClone;
    private ImmutableChain defaultChainToClone;
    private boolean ignoreUnclonableSubscriptions;
    private List<ArtifactSubscription> unclonableSubscriptions;
    @Inject
    private EventPublisher eventPublisher;
    @Inject
    private DockerConfigurationProviders dockerConfigurationProviders;

    @Override
    public String doDefault() throws Exception {
        if (this.planLimitReached) {
            this.planLimitReached = false;
            return PERMISSION_DENIED_ERROR;
        }
        this.dockerHandlers = this.dockerConfigurationProviders.getConfigs((BuildDefinition)null, true);
        return "input";
    }

    public void validate() {
        this.jobCreationService.validatePlan((ValidationAware)this, this.dockerConfigurationProviders.appendToConfiguration(this.getBuildConfiguration(), this.isolationType, this.getWebFragmentsContextMap()), (ActionParametersMap)new ActionParametersMapImpl(ActionContext.getContext()));
        if (!this.ignoreUnclonableSubscriptions) {
            this.unclonableSubscriptions = this.getUnclonableSubscriptions((ActionParametersMap)new ActionParametersMapImpl(ActionContext.getContext()));
            if (!CollectionUtils.isEmpty(this.unclonableSubscriptions)) {
                this.addFieldError(JOB_KEY_TO_CLONE, this.getText("plan.clone.job.unclonable"));
            }
        }
    }

    @RssConfigurationAware
    public String createJob() {
        if (!this.planManager.isPlanCreationAllowed()) {
            return PERMISSION_DENIED_ERROR;
        }
        try {
            List jobAndBranches = this.jobCreationService.createJobAndBranches(this.dockerConfigurationProviders.appendToConfiguration(this.getBuildConfiguration(), this.isolationType, this.getWebFragmentsContextMap()), (ActionParametersMap)new ActionParametersMapImpl(ActionContext.getContext()), PlanCreationService.EnablePlan.ENABLED);
            for (PlanKey jobOrBranch : jobAndBranches) {
                this.jobCreationService.triggerCreationCompleteEvents(jobOrBranch);
            }
            log.info((Object)("New Jobs(s) created with key(s) " + jobAndBranches));
            this.subBuildKey = ((PlanKey)jobAndBranches.get(0)).toString();
        }
        catch (PlanCreationDeniedException e) {
            log.error((Object)"Plan creation failed.", (Throwable)e);
            return PERMISSION_DENIED_ERROR;
        }
        catch (PlanCreationException e) {
            this.addActionError("Plan creation failed: " + e.getMessage());
            log.error((Object)"Plan creation failed.", (Throwable)e);
            return "error";
        }
        this.eventPublisher.publish((Object)new PlanConfigurationChangedAnalyticsEvent());
        return "success";
    }

    @RssConfigurationAware
    public String cloneJob() {
        if (!this.planManager.isPlanCreationAllowed()) {
            return PERMISSION_DENIED_ERROR;
        }
        if (!this.ignoreUnclonableSubscriptions) {
            this.unclonableSubscriptions = this.getUnclonableSubscriptions((ActionParametersMap)new ActionParametersMapImpl(ActionContext.getContext()));
            if (!CollectionUtils.isEmpty(this.unclonableSubscriptions)) {
                return "input";
            }
        } else {
            this.unclonableSubscriptions = null;
        }
        try {
            List jobAndBranches = this.jobCreationService.createJobAndBranches(this.getBuildConfiguration(), (ActionParametersMap)new ActionParametersMapImpl(ActionContext.getContext()), PlanCreationService.EnablePlan.ENABLED);
            this.subBuildKey = ((PlanKey)jobAndBranches.get(0)).toString();
            for (PlanKey jobOrBranch : jobAndBranches) {
                this.jobCreationService.triggerCreationCompleteEvents(jobOrBranch);
            }
            log.info((Object)("New Jobs(s) created with key(s) " + jobAndBranches));
        }
        catch (PlanCreationDeniedException e) {
            log.error((Object)"Plan creation failed.", (Throwable)e);
            return PERMISSION_DENIED_ERROR;
        }
        catch (PlanCreationException e) {
            this.addActionError("Plan creation failed: " + e.getMessage());
            log.error((Object)"Plan creation failed.", (Throwable)e);
            return "error";
        }
        return "success";
    }

    @Nullable
    private List<ArtifactSubscription> getUnclonableSubscriptions(@NotNull ActionParametersMap params) {
        String chainKey = StringUtils.upperCase((String)params.getString(BUILD_KEY, "").trim());
        String existingStage = params.getString(EXISTING_STAGE, "").trim();
        String jobKeyToClone = params.getString(JOB_KEY_TO_CLONE, "");
        boolean cloneJob = params.getBoolean(CLONE_JOB);
        if (cloneJob && StringUtils.isNotBlank((CharSequence)jobKeyToClone)) {
            Chain chain = (Chain)this.planManager.getPlanByKey(chainKey, Chain.class);
            if (chain == null) {
                throw new IllegalStateException("Can't figure out which plan to add the job to (plan key: " + chainKey + ")");
            }
            Job job = (Job)this.planManager.getPlanByKey(jobKeyToClone, Job.class);
            if (job == null) {
                throw new IllegalStateException("Can't find job with key " + jobKeyToClone);
            }
            return this.artifactSubscriptionManager.validateSubscriptions((ImmutableJob)job, (ImmutableChain)chain, existingStage);
        }
        return null;
    }

    public Collection<ImmutableChain> getChainsToClone() {
        if (this.chainsToClone == null) {
            this.chainsToClone = Collections2.filter((Collection)this.cachedPlanManager.getPlansForClone(), PlanPredicates::hasJobs);
        }
        return this.chainsToClone;
    }

    @NotNull
    public List<ImmutableJob> getJobsToClone() {
        ImmutableChain chain = Optional.ofNullable(this.getChainKeyToClone()).map(PlanKeys::getPlanKey).map(key -> (ImmutableChain)this.cachedPlanManager.getPlanByKeyIfOfType(key, ImmutableChain.class)).orElseGet(this::getDefaultChainToClone);
        return chain.getAllJobs().stream().sorted(Comparators::jobStagePlanNameCaseInsensitiveCompare).collect(Collectors.toList());
    }

    @Override
    public BuildConfiguration getBuildConfiguration() {
        if (this.buildConfiguration == null) {
            this.buildConfiguration = this.jobCreationService.getBuildConfigurationWithDefaults();
        }
        return this.buildConfiguration;
    }

    @Override
    public void setBuildConfiguration(BuildConfiguration buildConfiguration) {
        this.buildConfiguration = buildConfiguration;
    }

    public String getSubBuildKey() {
        return this.subBuildKey;
    }

    public void setSubBuildKey(String subBuildKey) {
        this.subBuildKey = subBuildKey;
    }

    public String getIsolationType() {
        return this.isolationType;
    }

    public void setIsolationType(String jobRunEnvironmentIsolation) {
        this.isolationType = jobRunEnvironmentIsolation;
    }

    public String getChainKeyToClone() {
        String chainKeyToClone = new ActionParametersMapImpl(ActionContext.getContext()).getString(CHAIN_KEY_TO_CLONE, "");
        if (StringUtils.isBlank((CharSequence)chainKeyToClone)) {
            ImmutableChain chain = this.getDefaultChainToClone();
            chainKeyToClone = chain != null ? chain.getKey() : null;
        }
        return chainKeyToClone;
    }

    @Override
    public boolean isPlanLimitReached() {
        return this.planLimitReached;
    }

    @Override
    public void setPlanLimitReached() {
        this.planLimitReached = true;
    }

    public List<ArtifactSubscription> getUnclonableSubscriptions() {
        return this.unclonableSubscriptions;
    }

    public boolean isIgnoreUnclonableSubscriptions() {
        return this.ignoreUnclonableSubscriptions;
    }

    public void setIgnoreUnclonableSubscriptions(boolean ignoreUnclonableSubscriptions) {
        this.ignoreUnclonableSubscriptions = ignoreUnclonableSubscriptions;
    }

    public UIConfigSupport getUiConfigBean() {
        return this.uiConfigBean;
    }

    public void setUiConfigBean(UIConfigSupport uiConfigBean) {
        this.uiConfigBean = uiConfigBean;
    }

    public void setJdkManager(JdkManager jdkManager) {
        this.jdkManager = jdkManager;
    }

    public void setArtifactSubscriptionManager(ArtifactSubscriptionManager artifactSubscriptionManager) {
        this.artifactSubscriptionManager = artifactSubscriptionManager;
    }

    public Collection<String> getAvailableJdks() {
        if (this.availableJdks == null) {
            this.availableJdks = this.jdkManager.getJdkLabels();
        }
        return this.availableJdks;
    }

    public boolean isAllowStageCreation() {
        return this.allowStageCreation;
    }

    public void setAllowStageCreation(boolean allowStageCreation) {
        this.allowStageCreation = allowStageCreation;
    }

    public void setJobCreationService(JobCreationService jobCreationService) {
        this.jobCreationService = jobCreationService;
    }

    @Nullable
    private ImmutableChain getDefaultChainToClone() {
        boolean currentChainHasJobs;
        boolean bl = currentChainHasJobs = !this.getImmutableChain().getAllJobs().isEmpty();
        if (currentChainHasJobs) {
            this.defaultChainToClone = this.getImmutableChain();
        } else if (this.defaultChainToClone == null) {
            this.defaultChainToClone = this.getChainsToClone().isEmpty() ? null : this.getChainsToClone().iterator().next();
        }
        return this.defaultChainToClone;
    }

    public Multimap<ChainStage, Job> getJobsContainingInvalidSubscriptions() {
        this.unclonableSubscriptions = this.getUnclonableSubscriptions((ActionParametersMap)new ActionParametersMapImpl(ActionContext.getContext()));
        TreeMultimap result = TreeMultimap.create((Comparator)Ordering.explicit((List)this.unclonableSubscriptions.get(0).getArtifactDefinition().getProducerJob().getParent().getStages()), (Comparator)Comparators.getNameProviderCaseInsensitiveOrdering());
        if (!CollectionUtils.isEmpty(this.unclonableSubscriptions)) {
            for (Job job : Sets.newHashSet((Iterable)Collections2.transform(this.unclonableSubscriptions, ArtifactSubscriptionsFunctions::getProducerJob))) {
                result.put((Object)job.getStage(), (Object)job);
            }
        }
        return result;
    }

    public Map<String, String> getEnvironmentIsolationOptions() {
        return this.dockerConfigurationProviders.getIsolationTypeLabels(this.getTextProvider());
    }

    public List<DockerConfigurationProviders.Config> getDockerHandlers() {
        if (this.dockerHandlers == null) {
            this.dockerHandlers = this.dockerConfigurationProviders.getConfigs(this.getWebFragmentsContextMap(), true);
        }
        return this.dockerHandlers;
    }
}

