/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.chains;

import com.atlassian.bamboo.artifact.Artifact;
import com.atlassian.bamboo.build.PlanResultsAction;
import com.atlassian.bamboo.build.artifact.ArtifactFileData;
import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.build.artifact.ArtifactLinkDataProvider;
import com.atlassian.bamboo.build.artifact.TrampolineArtifactFileData;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.util.Narrow;
import com.google.common.collect.Iterables;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactUrlRedirectAction
extends PlanResultsAction {
    private String artifactName;
    private String tag;
    private Iterable<ArtifactFileData> artifactFiles;

    public String execute() throws Exception {
        if (!this.validateResultSummary()) {
            return "error";
        }
        Artifact artifactLink = this.getArtifactLink(this.artifactName);
        if (artifactLink == null) {
            this.addActionError("Artifact " + this.artifactName + " not found in " + this.resultsSummary.getPlanResultKey());
            return "error";
        }
        ArtifactLinkDataProvider artifactLinkDataProvider = this.artifactLinkManager.getArtifactLinkDataProvider(artifactLink);
        if (artifactLinkDataProvider == null) {
            this.addActionError("Unable to find artifact link data provider for artifact link");
            return "error";
        }
        String sanitisedTag = StringUtils.remove((String)this.tag, (String)"..");
        this.artifactFiles = artifactLinkDataProvider.listObjects(sanitisedTag);
        if (Iterables.isEmpty(this.artifactFiles)) {
            if (artifactLinkDataProvider.exists()) {
                this.addActionError("Unable to generate URL for artifact, the file does not exist");
            } else {
                this.addActionError("Artifact handler was unable to generate an URL to the artifact");
            }
            return "error";
        }
        ArtifactFileData singleDownloadableFile = this.getSingleDownloadableFile(this.artifactFiles);
        if (singleDownloadableFile == null) {
            return "success";
        }
        TrampolineArtifactFileData trampolineProvider = (TrampolineArtifactFileData)Narrow.downTo((Object)singleDownloadableFile, TrampolineArtifactFileData.class);
        if (trampolineProvider != null) {
            this.artifactFiles = Collections.singletonList(trampolineProvider.getDelegate());
        }
        return "none";
    }

    @Nullable
    private ArtifactFileData getSingleDownloadableFile(@NotNull Iterable<ArtifactFileData> urls) {
        boolean isSingleFile = BambooIterables.hasSize(urls, (int)1);
        if (!isSingleFile) {
            return null;
        }
        ArtifactFileData singleFile = (ArtifactFileData)Iterables.getOnlyElement(urls);
        boolean isSingleDownloadableFile = singleFile.getFileType() == ArtifactFileData.FileType.REGULAR_FILE;
        return isSingleDownloadableFile ? singleFile : null;
    }

    @Nullable
    private Artifact getArtifactLink(String artifactName) {
        return this.resultsSummary.getArtifactLinks().stream().map(ArtifactLink::getArtifact).filter(a -> artifactName.equals(a.getLabel())).findFirst().orElse(null);
    }

    public Iterable<ArtifactFileData> getArtifactFiles() {
        return this.artifactFiles;
    }

    public String getDirectUrl() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((ArtifactFileData)Iterables.getOnlyElement(this.artifactFiles)).getUrl(), (CharSequence)"NO_URL_PROVIDED");
    }

    public void setArtifactName(String artifactName) {
        this.artifactName = artifactName;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getTag() {
        return this.tag;
    }
}

