/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.chains;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainStage;
import com.atlassian.bamboo.persister.AuditLogEntity;
import com.atlassian.bamboo.persister.AuditLogEntityType;
import com.atlassian.bamboo.plan.branch.ChainPropagatingFacade;
import com.atlassian.bamboo.ww2.actions.chains.StageAction;
import com.atlassian.bamboo.ww2.aware.RssConfigurationAware;
import com.atlassian.bamboo.ww2.aware.permissions.PlanAdminSecurityAware;
import com.atlassian.event.api.EventPublisher;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class AddStageAction
extends StageAction
implements PlanAdminSecurityAware {
    private static final Logger log = Logger.getLogger(AddStageAction.class);
    @Autowired
    private EventPublisher eventPublisher;
    private ChainStage chainStage;

    @Override
    public String doDefault() throws Exception {
        if (this.getImmutableChain() == null) {
            this.addActionError("Could not add stage, no plan found");
            return "error";
        }
        return "input";
    }

    @Override
    @RssConfigurationAware
    public String execute() throws Exception {
        Chain chain = this.getMutableChain();
        if (chain == null) {
            this.addActionError("Could not add stage, no plan found");
            return "error";
        }
        ChainPropagatingFacade chainAndBranches = new ChainPropagatingFacade(this.chainBranchManager, chain);
        this.chainStage = chainAndBranches.addAndSaveNewStage(this.planManager, this.eventPublisher, this.stageName, this.stageDescription, this.stageManual, this.finalStage);
        this.triggerAnalyticsEvent();
        this.auditLogService.log("Stage has been created.", (Key)this.getImmutablePlan().getPlanKey(), AuditLogEntityType.PLAN, new AuditLogEntity(AuditLogEntityType.STAGE, this.stageName));
        return "success";
    }

    @Override
    @NotNull
    protected JSONObject buildStageJsonObject() throws JSONException {
        return new JSONObject().put("id", this.chainStage.getId()).put("name", (Object)this.chainStage.getName()).put("description", (Object)this.chainStage.getDescription()).put("manual", this.chainStage.isManual());
    }
}

