/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build.admin.create;

import com.atlassian.bamboo.build.BuildTriggerCondition;
import com.atlassian.bamboo.build.strategy.BuildStrategyManager;
import com.atlassian.bamboo.build.strategy.PollingBuildStrategy;
import com.atlassian.bamboo.builder.JdkManager;
import com.atlassian.bamboo.deployments.environments.DeploymentTriggerBranchSelectionMode;
import com.atlassian.bamboo.license.BambooLicenseManager;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectIdentifier;
import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.bamboo.repository.NameValuePair;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryManager;
import com.atlassian.bamboo.repository.RequiresRepositoryData;
import com.atlassian.bamboo.repository.StandaloneRepository;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.task.TaskManager;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.utils.BambooCollectors;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.vcs.configuration.service.VcsRepositoryConfigurationService;
import com.atlassian.bamboo.webrepository.WebRepositoryViewer;
import com.atlassian.bamboo.webrepository.WebRepositoryViewerManager;
import com.atlassian.bamboo.ww2.actions.build.admin.create.UIConfigSupport;
import com.atlassian.user.Group;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.PagerUtils;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import com.opensymphony.xwork2.TextProvider;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.acegisecurity.acls.Permission;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class UIConfigSupportImpl
implements UIConfigSupport {
    private static final Logger log = Logger.getLogger(UIConfigSupportImpl.class);
    private Map<String, String> deploymentTriggerBranchSelectionOptions;
    private final BambooLicenseManager bambooLicenseManager;
    private final BambooUserManager bambooUserManager;
    private final BuildStrategyManager buildStrategyManager;
    private final JdkManager jdkManager;
    private final PlanManager planManager;
    private final ProjectManager projectManager;
    private final RepositoryManager repositoryManager;
    private final TaskManager taskManager;
    private final TextProvider textProvider;
    private final WebRepositoryViewerManager webRepositoryViewerManager;
    private final BambooPermissionManager bambooPermissionManager;

    @Autowired
    public UIConfigSupportImpl(BambooLicenseManager bambooLicenseManager, BambooUserManager bambooUserManager, BuildStrategyManager buildStrategyManager, JdkManager jdkManager, PlanManager planManager, ProjectManager projectManager, RepositoryManager repositoryManager, TaskManager taskManager, TextProvider textProvider, WebRepositoryViewerManager webRepositoryViewerManager, BambooPermissionManager bambooPermissionManager) {
        this.bambooLicenseManager = bambooLicenseManager;
        this.bambooUserManager = bambooUserManager;
        this.buildStrategyManager = buildStrategyManager;
        this.jdkManager = jdkManager;
        this.planManager = planManager;
        this.projectManager = projectManager;
        this.repositoryManager = repositoryManager;
        this.taskManager = taskManager;
        this.textProvider = textProvider;
        this.webRepositoryViewerManager = webRepositoryViewerManager;
        this.bambooPermissionManager = bambooPermissionManager;
    }

    @Override
    public int getCurrentPlanCount() {
        return this.planManager.getPlanCount();
    }

    @Override
    public int getAllowedNumberOfPlans() {
        return this.bambooLicenseManager.getAllowedNumberOfPlans();
    }

    @Override
    public int getExistingProjectsCount() {
        return this.projectManager.getNonDeletedProjectCount().intValue();
    }

    @Override
    @NotNull
    public Collection<Project> getExistingProjects() {
        return Comparators.getNameProviderCaseInsensitiveOrdering().sortedCopy((Iterable)this.projectManager.getProjects());
    }

    @Override
    @NotNull
    public Collection<Project> getExistingProjectsForPlanCreation() {
        Collection<Project> allProjects = this.getExistingProjects();
        if (this.bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.CREATE)) {
            return allProjects;
        }
        return allProjects.stream().filter(project -> this.bambooPermissionManager.hasProjectPermission((Permission)BambooPermission.CREATE, project)).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public String getFirstProjectKey() {
        Collection<Project> projects = this.getExistingProjects();
        if (!projects.isEmpty()) {
            return projects.iterator().next().getKey();
        }
        return null;
    }

    @Override
    @Nullable
    public String getFirstProjectKeyForPlanCreation() {
        return this.getExistingProjectsForPlanCreation().stream().findFirst().map(ProjectIdentifier::getKey).orElse(null);
    }

    @Override
    @NotNull
    public List<WebRepositoryViewer> getWebRepositoryViewers() {
        return this.webRepositoryViewerManager.getWebRepositoryViewers();
    }

    @Override
    @NotNull
    public Collection<BuildTriggerCondition> getBuildTriggerConditions() {
        return this.buildStrategyManager.getBuildTriggerConditions();
    }

    @Override
    @NotNull
    public Map<String, String> getDeploymentTriggerBranchSelectionOptions() {
        if (this.deploymentTriggerBranchSelectionOptions == null) {
            this.deploymentTriggerBranchSelectionOptions = Stream.of(DeploymentTriggerBranchSelectionMode.INHERITED.name(), DeploymentTriggerBranchSelectionMode.CUSTOM.name()).collect(Collectors.toMap(k -> k, k -> this.textProvider.getText(String.format("deployment.trigger.branch.selection.option.%s", k))));
        }
        return this.deploymentTriggerBranchSelectionOptions;
    }

    @Override
    @NotNull
    public Collection<NameValuePair> getFilterOptions() {
        return this.repositoryManager.getFilterOptions();
    }

    @Override
    @NotNull
    public Map<String, String> getExecutableLabelTypeMap() {
        TreeMap<String, String> executableLabelTypeMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        executableLabelTypeMap.putAll(this.taskManager.getExecutableLabelTypeMap());
        return executableLabelTypeMap;
    }

    @Override
    @NotNull
    public Map<String, String> getExecutableLabelTypeMap(String ... shortKey) {
        return (Map)this.getExecutablesWithShortKey(shortKey).collect(BambooCollectors.toMap());
    }

    @Override
    @NotNull
    public Map<String, String> getCapabilityKeyToLabelMap(String ... executableType) {
        Collector<String, ?, TreeMap> toTreeMap = Collectors.toMap(c -> c, UIConfigSupportImpl::capabilityKeyToExecutableLabel, BambooCollectors.throwingMerger(), TreeMap::new);
        return this.taskManager.getCapabilitiesWithExecutables((Set)Sets.newHashSet((Object[])executableType)).stream().collect(toTreeMap);
    }

    public static String capabilityKeyToExecutableLabel(String capabilityKey) {
        return StringUtils.split((String)capabilityKey, (String)".", (int)4)[3];
    }

    public static String capabilityKeyToExecutableType(String capabilityKey) {
        return StringUtils.split((String)capabilityKey, (String)".", (int)4)[2];
    }

    @Override
    @NotNull
    public List<String> getExecutableLabels(@NotNull String shortKey) {
        return this.getExecutablesWithShortKey(shortKey).map(Map.Entry::getKey).sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.toList());
    }

    private Stream<Map.Entry<String, String>> getExecutablesWithShortKey(String ... shortKey) {
        HashSet shortKeys = Sets.newHashSet((Object[])shortKey);
        return this.taskManager.getExecutableLabelTypeMap().entrySet().stream().filter(entry -> shortKeys.contains(entry.getValue()));
    }

    @Override
    public String getWebRepositoryJson() throws Exception {
        JSONObject jsonObject = new JSONObject();
        ArrayList<JSONObject> repos = new ArrayList<JSONObject>();
        for (WebRepositoryViewer viewer : this.getWebRepositoryViewers()) {
            JSONObject webRepoObject = new JSONObject();
            webRepoObject.put("value", (Object)viewer.getKey());
            webRepoObject.put("text", (Object)viewer.getName());
            Collection supportedRepos = viewer.getSupportedRepositories();
            if (supportedRepos == null || supportedRepos.isEmpty()) {
                webRepoObject.put("supportedValues", (Object)"");
            } else {
                webRepoObject.put("supportedValues", (Object)supportedRepos.toArray());
            }
            repos.add(webRepoObject);
        }
        jsonObject.put("data", repos);
        StringWriter stringWriter = new StringWriter();
        jsonObject.write((Writer)stringWriter);
        return stringWriter.toString();
    }

    @Override
    public List<Pair<String, String>> getPollingTypes() {
        ArrayList<Pair<String, String>> types = new ArrayList<Pair<String, String>>();
        types.add(Pair.make((Object)PollingBuildStrategy.PollingStrategy.PERIOD.name(), (Object)"Periodically"));
        types.add(Pair.make((Object)PollingBuildStrategy.PollingStrategy.CRON.name(), (Object)"Scheduled"));
        return types;
    }

    @Override
    @NotNull
    public String getPollingTypeName(@NotNull String pollingTypeKey) {
        List<Pair<String, String>> pollingTypes = this.getPollingTypes();
        for (Pair<String, String> pollingType : pollingTypes) {
            if (!((String)pollingType.first).equals(pollingTypeKey)) continue;
            return (String)pollingType.second;
        }
        throw new IllegalArgumentException(String.format("Unknown polling type [%s]", pollingTypeKey));
    }

    @Override
    @NotNull
    public List<String> getJdkLabels() {
        return this.jdkManager.getJdkLabels();
    }

    @Override
    public boolean isJdkLabelValid(@Nullable String label) {
        return this.getJdkLabels().contains(label);
    }

    @Override
    public String getDefaultJdkLabel() {
        String defaultJdk = this.jdkManager.getDefaultJdkLabel();
        if (this.isJdkLabelValid(defaultJdk)) {
            return defaultJdk;
        }
        return (String)Iterables.getLast(this.getJdkLabels(), (Object)"");
    }

    @NotNull
    public List<String> getLinkedRepositoryAccessOptions() {
        VcsRepositoryConfigurationService.LinkedRepositoryAccess[] values = VcsRepositoryConfigurationService.LinkedRepositoryAccess.values();
        return ImmutableList.copyOf((Iterable)Iterables.transform(Arrays.asList(values), (Function)Functions.toStringFunction()));
    }

    @Override
    @NotNull
    public List<Repository> getRepositories() {
        return this.repositoryManager.getRepositories();
    }

    @Override
    @NotNull
    public List<StandaloneRepository> getStandaloneRepositories() {
        return this.repositoryManager.getRepositories().stream().filter(StandaloneRepository.class::isInstance).map(StandaloneRepository.class::cast).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public List<Group> getAvailableGroups() {
        Pager groups = this.bambooUserManager.getGroups();
        if (groups != null) {
            return PagerUtils.toList((Pager)groups);
        }
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public List<String> getAvailableUserNames() {
        Pager users = this.bambooUserManager.getUserNames();
        if (users != null) {
            return PagerUtils.toList((Pager)users);
        }
        return Collections.emptyList();
    }

    public boolean requiresRepositoryDataOnView(@NotNull Repository repository) {
        return repository instanceof RequiresRepositoryData;
    }
}

