/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build.admin.create;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.repository.RepositoryData;
import com.atlassian.bamboo.repository.nullrepository.NullRepository;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.opensymphony.xwork2.TextProvider;
import javax.annotation.concurrent.Immutable;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Immutable
@Internal
public class RepositoryOption {
    private static final Logger log = Logger.getLogger(RepositoryOption.class);
    private final String key;
    private final String name;
    private final String group;
    private final String icon;
    private final String tooltipKey;
    private final boolean primary;
    private final int weight;
    private String optionDescription;
    private boolean shared;

    public RepositoryOption(@NotNull VcsRepositoryModuleDescriptor repositoryModuleDescriptor) {
        this.key = repositoryModuleDescriptor.getCompleteKey();
        this.name = repositoryModuleDescriptor.getName();
        this.group = "";
        this.optionDescription = repositoryModuleDescriptor.getOptionDescription();
        this.icon = repositoryModuleDescriptor.getIcon();
        this.tooltipKey = repositoryModuleDescriptor.getTooltipKey();
        this.weight = repositoryModuleDescriptor.getWeight();
        this.primary = repositoryModuleDescriptor.isPrimary();
    }

    public RepositoryOption(@NotNull VcsRepositoryData repositoryData, @NotNull String groupName, boolean shared) {
        this.key = Long.toString(repositoryData.getId());
        this.name = repositoryData.getName();
        VcsRepositoryModuleDescriptor repositoryModuleDescriptor = ((VcsRepositoryManager)ComponentAccessor.VCS_REPOSITORY_MANAGER.get()).getVcsRepositoryModuleDescriptor(repositoryData.getPluginKey());
        this.group = groupName;
        this.icon = repositoryModuleDescriptor.getIcon();
        this.tooltipKey = repositoryModuleDescriptor.getTooltipKey();
        this.weight = repositoryModuleDescriptor.getWeight();
        this.primary = repositoryModuleDescriptor.isPrimary();
        this.shared = shared;
    }

    @Deprecated
    public RepositoryOption(@NotNull RepositoryData repositoryData, @NotNull String groupName, boolean shared) {
        this(repositoryData, groupName);
        this.shared = shared;
    }

    @Deprecated
    public RepositoryOption(@NotNull RepositoryData repositoryData, @NotNull String groupName) {
        this.key = Long.toString(repositoryData.getId());
        this.name = repositoryData.getName();
        VcsRepositoryModuleDescriptor repositoryModuleDescriptor = ((VcsRepositoryManager)ComponentAccessor.VCS_REPOSITORY_MANAGER.get()).getVcsRepositoryModuleDescriptor(repositoryData.getPluginKey());
        this.group = groupName;
        this.icon = repositoryModuleDescriptor.getIcon();
        this.tooltipKey = repositoryModuleDescriptor.getTooltipKey();
        this.weight = repositoryModuleDescriptor.getWeight();
        this.primary = repositoryModuleDescriptor.isPrimary();
    }

    public RepositoryOption(@NotNull String textOnly, @NotNull String groupName) {
        this.key = "0";
        this.name = textOnly;
        this.group = groupName;
        this.icon = null;
        this.primary = false;
        this.tooltipKey = null;
        this.weight = Integer.MAX_VALUE;
    }

    private RepositoryOption(NullRepository nullRepository) {
        this.key = nullRepository.getKey();
        this.name = nullRepository.getName();
        this.group = "";
        this.icon = null;
        this.primary = false;
        this.tooltipKey = null;
        this.weight = Integer.MAX_VALUE;
    }

    public static RepositoryOption getNullRepositoryOption(@NotNull TextProvider textProvider) {
        return new RepositoryOption(new NullRepository(textProvider));
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getTooltipKey() {
        return this.tooltipKey;
    }

    public int getWeight() {
        return this.weight;
    }

    public String getGroup() {
        return this.group;
    }

    public boolean isShared() {
        return this.shared;
    }

    public String getOptionDescription() {
        return this.optionDescription;
    }
}

