/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build.admin.create;

import com.atlassian.bamboo.applinks.JiraApplinksService;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.build.creation.ChainCreationService;
import com.atlassian.bamboo.build.docker.BuildEnvironmentType;
import com.atlassian.bamboo.build.docker.DockerConfigurationProviders;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.deletion.DeletionService;
import com.atlassian.bamboo.event.DeletionFinishedEvent;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanClassHelper;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.ww2.actions.build.admin.config.task.ConfigureBuildTasks;
import com.atlassian.bamboo.ww2.aware.RssConfigurationAware;
import com.atlassian.event.api.EventPublisher;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CreateTasksChainWizard
extends ConfigureBuildTasks {
    private static final Logger log = Logger.getLogger(CreateTasksChainWizard.class);
    private static final String SUCCESS_PLAN_DISABLED = "successPlanDisabled";
    private boolean chainEnabled;
    private String isolationType = BuildEnvironmentType.AGENT.name();
    private List<DockerConfigurationProviders.Config> dockerHandlers;
    private static final boolean IS_DOCKER_CREATE = true;
    private String parentKey;
    private ChainCreationService chainCreationService;
    private DeletionService deletionService;
    private DockerConfigurationProviders dockerConfigurationProviders;
    private EventPublisher eventPublisher;
    private JiraApplinksService jiraApplinksService;
    private boolean newProject;

    @Override
    public String doDefault() {
        if (!PlanClassHelper.isJob((ImmutablePlan)this.getImmutablePlan())) {
            this.addActionError(this.getText("plan.create.tasks.error.noJob"));
            return "error";
        }
        ImmutableJob build = (ImmutableJob)this.getImmutablePlan();
        this.dockerHandlers = this.dockerConfigurationProviders.getConfigs(build.getBuildDefinition(), true);
        this.isolationType = this.dockerHandlers.stream().filter(t -> t.isSelected()).map(t -> t.getIsolationType()).findFirst().orElse(BuildEnvironmentType.AGENT.name());
        return "input";
    }

    public String cancel() {
        Job job = (Job)Narrow.to((Object)this.getMutablePlan(), Job.class);
        if (job == null) {
            this.addActionError(this.getText("plan.create.cancel.error"));
            return "error";
        }
        Chain parent = job.getParent();
        Project project = parent.getProject();
        boolean isProjectApplinkDefined = false;
        try {
            if (!Iterables.isEmpty((Iterable)this.jiraApplinksService.getJiraEntityLinksForProject(project))) {
                isProjectApplinkDefined = true;
            }
        }
        catch (IllegalArgumentException e) {
            log.debug((Object)("Checking project applink before remove project:" + e));
        }
        this.deletionService.deletePlan((Plan)parent);
        if (this.newProject && !isProjectApplinkDefined && this.planManager.getPlansByProject(project).isEmpty()) {
            this.deletionService.deleteProject(project);
        }
        this.eventPublisher.publish((Object)new DeletionFinishedEvent());
        return "success";
    }

    @RssConfigurationAware
    public String execute() {
        Job job = (Job)Narrow.to((Object)this.getMutablePlan(), Job.class);
        if (job == null) {
            this.addActionError(this.getText("plan.create.finalise.error"));
            return "error";
        }
        Chain parent = job.getParent();
        this.parentKey = parent.getKey();
        if (this.chainEnabled) {
            this.planManager.setPlanSuspendedState(parent.getPlanKey(), false);
        }
        this.addErrorCollection(this.dockerConfigurationProviders.validateAndSaveSelectedConfig(job, true, this.isolationType, this.getWebFragmentsContextMap()));
        if (this.hasAnyErrors()) {
            return "error";
        }
        this.chainCreationService.triggerCreationCompleteEvents(parent.getPlanKey());
        this.triggerAnalyticsEvent();
        if (!this.chainEnabled) {
            return SUCCESS_PLAN_DISABLED;
        }
        return "success";
    }

    public String getParentKey() {
        return this.parentKey;
    }

    public boolean isChainEnabled() {
        return this.chainEnabled;
    }

    public void setChainEnabled(boolean chainEnabled) {
        this.chainEnabled = chainEnabled;
    }

    public String getIsolationType() {
        return this.isolationType;
    }

    public void setIsolationType(String isolationType) {
        this.isolationType = isolationType;
    }

    public void setChainCreationService(ChainCreationService chainCreationService) {
        this.chainCreationService = chainCreationService;
    }

    public void setDeletionService(DeletionService deletionService) {
        this.deletionService = deletionService;
    }

    public void setDockerConfigurationProviders(DockerConfigurationProviders dockerConfigurationProviders) {
        this.dockerConfigurationProviders = dockerConfigurationProviders;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void setJiraApplinksService(JiraApplinksService jiraApplinksService) {
        this.jiraApplinksService = jiraApplinksService;
    }

    public boolean isNewProject() {
        return this.newProject;
    }

    public void setNewProject(boolean newProject) {
        this.newProject = newProject;
    }

    public Map<String, String> getEnvironmentIsolationOptions() {
        return this.dockerConfigurationProviders.getIsolationTypeLabels(this.getTextProvider());
    }

    public List<DockerConfigurationProviders.Config> getDockerHandlers() {
        if (this.dockerHandlers == null) {
            this.dockerHandlers = this.dockerConfigurationProviders.getConfigs(this.getWebFragmentsContextMap(), true);
        }
        return this.dockerHandlers;
    }
}

