/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build.admin.create;

import com.atlassian.bamboo.configuration.external.RssDetectionService;
import com.atlassian.bamboo.configuration.repository.VcsUIConfigBean;
import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.deployments.projects.service.DeploymentProjectService;
import com.atlassian.bamboo.event.analytics.GenericAnalyticsEvent;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.bamboo.repository.CachedRepositoryDefinitionManager;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.security.BambooCachingPermissionManagerFacade;
import com.atlassian.bamboo.security.BambooCachingPermissionManagerFacadeFactory;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.specs.RssPermissionManager;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutor;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutorFactory;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.service.VcsConfigurationHelper;
import com.atlassian.bamboo.vcs.configuration.service.VcsRepositoryConfigurationService;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.actions.build.admin.config.task.TaskRenderMode;
import com.atlassian.bamboo.ww2.actions.build.admin.create.UIConfigSupport;
import com.atlassian.bamboo.ww2.aware.permissions.AuthenticatedUserSecurityAware;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.struts.ValidationAware;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.acegisecurity.acls.Permission;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class CreateSpecs
extends BambooActionSupport
implements AuthenticatedUserSecurityAware {
    private static final Logger log = Logger.getLogger(CreateSpecs.class);
    private static final String RSS_DISABLED = "rssDisabled";
    private static final String BUILD = "BUILD";
    private static final String DEPLOYMENT = "DEPLOYMENT";
    private static final String PROJECT_TYPE = "projectTypeOption";
    private long repositoryId;
    private String selectedRepository;
    private String repositoryName;
    private String linkedRepositoryAccessOption;
    private String projectTypeOption;
    private String selectProjectKey;
    private String selectProjectName;
    private String selectDeploymentKey;
    private String selectDeploymentName;
    private String buildProjectKey;
    private List<VcsUIConfigBean.VcsTypeSelector> vcsTypeSelectors;
    @Inject
    private BambooCachingPermissionManagerFacadeFactory bambooCachingPermissionManagerFacadeFactory;
    @Inject
    private CachedRepositoryDefinitionManager cachedRepositoryDefinitionManager;
    @Inject
    private CustomVariableContext customVariableContext;
    @Inject
    private DeploymentProjectService deploymentProjectService;
    @Inject
    private EventPublisher eventPublisher;
    @Inject
    private ProjectManager projectManager;
    @Inject
    private RepositoryDefinitionManager repositoryDefinitionManager;
    @Inject
    private RssDetectionService rssDetectionService;
    @Inject
    private RssPermissionManager rssPermissionManager;
    @Inject
    private UIConfigSupport uiConfigBean;
    @Inject
    private VariableSubstitutorFactory variableSubstitutorFactory;
    @Inject
    private VcsConfigurationHelper vcsConfigurationHelper;
    @Inject
    private VcsRepositoryConfigurationService vcsRepositoryConfigurationService;
    @Inject
    private VcsRepositoryManager vcsRepositoryManager;
    @Inject
    private VcsUIConfigBean vcsUIConfigBean;

    public String input() throws Exception {
        if (!this.featureManager.isRepositoryStoredSpecsEnabled()) {
            return RSS_DISABLED;
        }
        this.linkedRepositoryAccessOption = VcsRepositoryConfigurationService.LinkedRepositoryAccess.ALL_USERS.name();
        this.initVcsTypeSelectors(TaskRenderMode.SUCCESS);
        this.eventPublisher.publish((Object)new GenericAnalyticsEvent("bamboo.repository.stored.specs.wizard.started"));
        return "input";
    }

    public String execute() throws Exception {
        if (!this.featureManager.isRepositoryStoredSpecsEnabled()) {
            return RSS_DISABLED;
        }
        this.enableRss();
        this.grantProjectAccess();
        this.triggerSpecsDetection();
        this.eventPublisher.publish((Object)new GenericAnalyticsEvent("bamboo.repository.stored.specs.wizard.complete"));
        return this.hasAnyErrors() ? "error" : "success";
    }

    private void triggerSpecsDetection() {
        VcsRepositoryData vcsRepositoryData = this.cachedRepositoryDefinitionManager.getVcsRepositoryData(this.repositoryId);
        Preconditions.checkState((vcsRepositoryData != null ? 1 : 0) != 0);
        ErrorCollection errorCollection = this.rssDetectionService.canEnqueue(vcsRepositoryData);
        if (errorCollection.hasAnyErrors()) {
            this.addActionError(String.join((CharSequence)"; ", errorCollection.getErrorMessages()));
        } else {
            this.rssDetectionService.enqueue(this.repositoryId, vcsRepositoryData.getBranch().getVcsBranch(), true);
        }
    }

    public void validate() {
        this.validateProject();
        if (!this.hasAnyErrors()) {
            this.validateRepository();
        }
        if (this.hasAnyErrors()) {
            this.initVcsTypeSelectors(TaskRenderMode.ERROR);
        }
    }

    private void validateProject() {
        if (BUILD.equals(this.projectTypeOption)) {
            if (StringUtils.isBlank((CharSequence)this.selectProjectKey)) {
                this.addFieldError(PROJECT_TYPE, this.getText("rss.specs.onboarding.creation.error.no.project.choosen"));
            } else {
                Project project = this.projectManager.getProjectByKey(this.selectProjectKey);
                if (project == null) {
                    this.addFieldError(PROJECT_TYPE, this.getText("rss.specs.onboarding.creation.error.project.doesnt.exist", Collections.singletonList(this.selectProjectKey)));
                } else if (!this.bambooPermissionManager.hasProjectPermission((Permission)BambooPermission.ADMINISTRATION, project)) {
                    this.addFieldError(PROJECT_TYPE, this.getText("rss.specs.onboarding.creation.error.project.no.permissions"));
                }
            }
        } else if (DEPLOYMENT.equals(this.projectTypeOption)) {
            if (StringUtils.isBlank((CharSequence)this.selectDeploymentKey)) {
                this.addFieldError(PROJECT_TYPE, this.getText("rss.specs.onboarding.creation.error.no.project.choosen"));
            } else {
                DeploymentProject deployment = this.deploymentProjectService.getDeploymentProject(Long.parseLong(this.selectDeploymentKey));
                if (deployment == null) {
                    this.addFieldError(PROJECT_TYPE, this.getText("rss.specs.onboarding.creation.error.deployment.doesnt.exist", Collections.singletonList(this.selectDeploymentKey)));
                } else if (!this.bambooPermissionManager.hasPermission((Permission)BambooPermission.WRITE, (Object)deployment, null)) {
                    this.addFieldError(PROJECT_TYPE, this.getText("rss.specs.onboarding.creation.error.project.no.permissions"));
                }
            }
        } else {
            this.addFieldError(PROJECT_TYPE, this.getText("rss.specs.onboarding.creation.error.no.project.choosen"));
        }
    }

    private void validateRepository() {
        if (StringUtils.isBlank((CharSequence)this.selectedRepository)) {
            this.addFieldError("selectedRepository", this.getText("repository.not.selected"));
        } else if (NumberUtils.isCreatable((String)this.selectedRepository)) {
            long repositoryId = Long.parseLong(this.selectedRepository);
            PartialVcsRepositoryData vcsRepositoryData = this.repositoryDefinitionManager.getVcsRepositoryDataForEditing(repositoryId);
            if (vcsRepositoryData == null) {
                this.addFieldError("selectedRepository", this.getText("repository.shared.idNotExists", Collections.singletonList(String.valueOf(repositoryId))));
            } else if (!this.bambooPermissionManager.hasPermission((Permission)BambooPermission.ADMINISTRATION, (Object)vcsRepositoryData, null)) {
                this.addFieldError("selectedRepository", this.getText("repository.shared.noPermission", Collections.singletonList(vcsRepositoryData.getName())));
            } else {
                VcsRepositoryModuleDescriptor vcsModuleDesc = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(vcsRepositoryData.getPluginKey());
                if (vcsModuleDesc == null || vcsModuleDesc.getBambooSpecsHandler() == null) {
                    this.addFieldError("selectedRepository", this.getText("rss.specs.onboarding.creation.error.repository.rss.not.supported"));
                }
            }
        } else if (!this.vcsConfigurationHelper.currentUserHasPermissionToCreateSharedRepository()) {
            this.addFieldError("selectedRepository", this.getText("plan.create.repository.no.permission"));
        } else {
            VcsRepositoryModuleDescriptor vcsModuleDesc = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(this.selectedRepository);
            if (vcsModuleDesc == null || vcsModuleDesc.getBambooSpecsHandler() == null) {
                this.addFieldError("selectedRepository", this.getText("rss.specs.onboarding.creation.error.repository.rss.not.supported"));
            } else {
                VariableSubstitutor variableSubstitutor = this.variableSubstitutorFactory.newSubstitutorForGlobalContext();
                this.vcsConfigurationHelper.validateSharedRepositoryName(this.repositoryName, (ValidationAware)this);
                SimpleErrorCollection errorCollection = new SimpleErrorCollection();
                VcsRepositoryModuleDescriptor vcsRepositoryModuleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(this.selectedRepository);
                this.customVariableContext.withVariableSubstitutor(variableSubstitutor, () -> this.lambda$validateRepository$0(vcsRepositoryModuleDescriptor, (ErrorCollection)errorCollection));
                this.addErrorCollection((ErrorCollection)errorCollection);
            }
        }
    }

    private void enableRss() {
        PartialVcsRepositoryData vcsRepositoryData;
        if (NumberUtils.isCreatable((String)this.selectedRepository)) {
            this.repositoryId = Long.parseLong(this.selectedRepository);
            vcsRepositoryData = this.repositoryDefinitionManager.getVcsRepositoryDataForEditing(this.repositoryId);
        } else {
            VcsRepositoryModuleDescriptor vcsRepositoryModuleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(this.selectedRepository);
            VariableSubstitutor variableSubstitutor = this.variableSubstitutorFactory.newSubstitutorForGlobalContext();
            PartialVcsRepositoryData newRepositoryData = (PartialVcsRepositoryData)this.customVariableContext.withVariableSubstitutor(variableSubstitutor, () -> this.vcsUIConfigBean.getPartialVcsConfigurationFromActionData(vcsRepositoryModuleDescriptor, this.repositoryName, "", null, false, VcsConfigurationHelper.OVERRIDE_ALL));
            VcsRepositoryConfigurationService.LinkedRepositoryAccess repositoryAccess = VcsRepositoryConfigurationService.LinkedRepositoryAccess.valueOf((String)(this.linkedRepositoryAccessOption != null ? this.linkedRepositoryAccessOption : VcsRepositoryConfigurationService.LinkedRepositoryAccess.ALL_USERS.name()));
            vcsRepositoryData = this.vcsRepositoryConfigurationService.createLinkedRepository(newRepositoryData, this.getUser(), repositoryAccess);
            this.repositoryId = vcsRepositoryData.getId();
            log.info((Object)String.format("New linked repository '%s' created", this.repositoryName));
        }
        this.vcsRepositoryConfigurationService.configureRssDetection(this.repositoryId, vcsRepositoryData, true);
        log.info((Object)("RSS enabled for repository " + this.repositoryId));
    }

    private void grantProjectAccess() {
        if (BUILD.equals(this.projectTypeOption)) {
            Project project = this.projectManager.getProjectByKey(this.selectProjectKey);
            long projectId = project.getId();
            if (!this.rssPermissionManager.getRepositoriesWithAccessToProject(projectId).contains(this.repositoryId)) {
                this.rssPermissionManager.grantProjectAccess(projectId, this.repositoryId);
            }
            this.buildProjectKey = project.getKey();
        } else {
            long deploymentId = Long.parseLong(this.selectDeploymentKey);
            if (!this.rssPermissionManager.getRepositoriesWithAccessToDeploymentProject(deploymentId).contains(this.repositoryId)) {
                this.rssPermissionManager.grantDeploymentProjectAccess(deploymentId, this.repositoryId);
            }
            this.buildProjectKey = null;
        }
    }

    private void initVcsTypeSelectors(@NotNull TaskRenderMode renderMode) {
        List vcsRepositoryModuleDescriptors = this.vcsRepositoryManager.getAvailableRepositoryDescriptors();
        this.vcsTypeSelectors = vcsRepositoryModuleDescriptors.stream().filter(descriptor -> descriptor.getBambooSpecsHandler() != null).map(input -> new VcsUIConfigBean.VcsTypeSelector((VcsRepositoryModuleDescriptor)input, this.vcsUIConfigBean.prepareCreateHtmlFragments((VcsRepositoryModuleDescriptor)input, input.getCompleteKey().equals(this.selectedRepository) ? renderMode : TaskRenderMode.SUCCESS, null))).collect(Collectors.toList());
    }

    public boolean canChooseAnyBuildProject() {
        BambooCachingPermissionManagerFacade bambooCachingPermissionManagerFacade = this.bambooCachingPermissionManagerFacadeFactory.create();
        return this.projectManager.getAllProjects().stream().anyMatch(project -> bambooCachingPermissionManagerFacade.hasPermission((Permission)BambooPermission.ADMINISTRATION, project));
    }

    public boolean canChooseAnyDeploymentProject() {
        BambooCachingPermissionManagerFacade bambooCachingPermissionManagerFacade = this.bambooCachingPermissionManagerFacadeFactory.create();
        return this.deploymentProjectService.getAllDeploymentProjects().stream().anyMatch(deployment -> bambooCachingPermissionManagerFacade.hasPermission((Permission)BambooPermission.WRITE, deployment));
    }

    public long getRepositoryId() {
        return this.repositoryId;
    }

    public String getSelectedRepository() {
        return this.selectedRepository;
    }

    public void setSelectedRepository(String selectedRepository) {
        this.selectedRepository = selectedRepository;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public String getLinkedRepositoryAccessOption() {
        return this.linkedRepositoryAccessOption;
    }

    public void setLinkedRepositoryAccessOption(String linkedRepositoryAccessOption) {
        this.linkedRepositoryAccessOption = linkedRepositoryAccessOption;
    }

    public void setProjectTypeOption(String projectTypeOption) {
        this.projectTypeOption = projectTypeOption;
    }

    public String getSelectProjectKey() {
        return this.selectProjectKey;
    }

    public void setSelectProjectKey(String selectProjectKey) {
        this.selectProjectKey = selectProjectKey;
    }

    public String getSelectProjectName() {
        return this.selectProjectName;
    }

    public void setSelectProjectName(String selectProjectName) {
        this.selectProjectName = selectProjectName;
    }

    public String getSelectDeploymentKey() {
        return this.selectDeploymentKey;
    }

    public void setSelectDeploymentKey(String selectDeploymentKey) {
        this.selectDeploymentKey = selectDeploymentKey;
    }

    public String getSelectDeploymentName() {
        return this.selectDeploymentName;
    }

    public void setSelectDeploymentName(String selectDeploymentName) {
        this.selectDeploymentName = selectDeploymentName;
    }

    public String getBuildProjectKey() {
        return this.buildProjectKey;
    }

    public UIConfigSupport getUiConfigBean() {
        return this.uiConfigBean;
    }

    public VcsUIConfigBean getVcsUIConfigBean() {
        return this.vcsUIConfigBean;
    }

    public List<VcsUIConfigBean.VcsTypeSelector> getVcsTypeSelectors() {
        return this.vcsTypeSelectors;
    }

    private /* synthetic */ void lambda$validateRepository$0(VcsRepositoryModuleDescriptor vcsRepositoryModuleDescriptor, ErrorCollection errorCollection) {
        this.vcsUIConfigBean.validateVcsConfiguration(vcsRepositoryModuleDescriptor, null, errorCollection, VcsConfigurationHelper.OVERRIDE_ALL);
    }
}

