/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build.admin.create;

import com.atlassian.bamboo.event.analytics.GenericAnalyticsEvent;
import com.atlassian.bamboo.project.ProjectConfigurationService;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalCreatePlanSecurityAware;
import com.atlassian.event.api.EventPublisher;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class CreateProject
extends BambooActionSupport
implements GlobalCreatePlanSecurityAware {
    private String projectName;
    private String projectKey;
    private String projectDescription;
    private boolean projectAccessPublic;
    @Autowired
    private ProjectConfigurationService projectConfigurationService;
    @Autowired
    private EventPublisher eventPublisher;

    public String save() throws Exception {
        this.projectConfigurationService.createProject(this.projectKey, this.projectName, this.projectDescription, this.projectAccessPublic);
        this.eventPublisher.publish((Object)new GenericAnalyticsEvent("bamboo.admin.project.created.empty"));
        return "success";
    }

    public void validate() {
        this.addErrorCollection(this.projectConfigurationService.validateProjectForCreation(this.projectKey, this.projectName, this.projectDescription));
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = StringUtils.upperCase((String)projectKey);
    }

    public void setProjectDescription(String projectDescription) {
        this.projectDescription = projectDescription;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectDescription() {
        return this.projectDescription;
    }

    public boolean isProjectAccessPublic() {
        return this.projectAccessPublic;
    }

    public void setProjectAccessPublic(boolean projectAccessPublic) {
        this.projectAccessPublic = projectAccessPublic;
    }
}

