/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build.admin.create;

import com.atlassian.bamboo.build.PlanCreationDeniedException;
import com.atlassian.bamboo.build.PlanCreationException;
import com.atlassian.bamboo.build.creation.BuildTriggerConditionConfigHelper;
import com.atlassian.bamboo.build.creation.ChainCreationService;
import com.atlassian.bamboo.build.creation.ChainParamMapHelper;
import com.atlassian.bamboo.build.creation.JobCreationConstants;
import com.atlassian.bamboo.build.creation.JobCreationService;
import com.atlassian.bamboo.build.creation.JobParamMapHelper;
import com.atlassian.bamboo.build.creation.PlanConfigHelper;
import com.atlassian.bamboo.build.creation.PlanConfigHelpers;
import com.atlassian.bamboo.build.creation.PlanCreationService;
import com.atlassian.bamboo.builder.JdkManager;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.collections.SimpleActionParametersMap;
import com.atlassian.bamboo.configuration.repository.VcsUIConfigBean;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.trigger.TriggerConfigurationUtils;
import com.atlassian.bamboo.trigger.TriggerConfigurator;
import com.atlassian.bamboo.trigger.TriggerDefinition;
import com.atlassian.bamboo.trigger.TriggerDefinitionImpl;
import com.atlassian.bamboo.trigger.TriggerModuleDescriptor;
import com.atlassian.bamboo.trigger.TriggerTypeManager;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutor;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutorFactory;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.service.RawRepositoryConfigurationXmlConverter;
import com.atlassian.bamboo.vcs.configuration.service.VcsConfigurationHelper;
import com.atlassian.bamboo.vcs.configuration.service.VcsRepositoryConfigurationService;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.webwork.util.ActionParametersMapImpl;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.actions.build.admin.config.task.TaskRenderMode;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.bamboo.ww2.actions.build.admin.create.UIConfigSupport;
import com.atlassian.bamboo.ww2.aware.BuildConfigurationAware;
import com.atlassian.bamboo.ww2.aware.PlanLimitAware;
import com.atlassian.bamboo.ww2.aware.permissions.AuthenticatedUserSecurityAware;
import com.atlassian.struts.ValidationAware;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.opensymphony.xwork2.ActionContext;
import io.atlassian.util.concurrent.Lazy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class CreateChain
extends BambooActionSupport
implements AuthenticatedUserSecurityAware,
PlanLimitAware,
BuildConfigurationAware {
    private static final Logger log = Logger.getLogger(CreateChain.class);
    @VisibleForTesting
    public static final String PERMISSION_DENIED_ERROR = "planCreationDeniedError";
    private static final String SUCCESS_PLAN_DISABLED = "successPlanDisabled";
    private static final String TMP_CREATE_AS_ENABLED_PROPERTY = "tmp.createAsEnabled";
    private static final String WARN_ELASTIC_NOT_CONFIGURED = "elasticNotConfigured";
    public static final String STAGE_NAME = "Default Stage";
    public static final String JOB_NAME = "Default Job";
    public static final String JOB_KEY = "JOB1";
    private BuildConfiguration buildConfigurationFromUI;
    private ImmutablePlan plan;
    private String buildKey;
    private String jobKey;
    private boolean planLimitReached = false;
    private boolean clonePlan;
    private boolean newProject;
    private boolean chainEnabled;
    private String planKeyToClone;
    private String existingProjectKey;
    private String repositoryName;
    private List<VcsUIConfigBean.VcsTypeSelector> vcsTypeSelectors;
    @Autowired
    private UIConfigSupport uiConfigBean;
    @Autowired
    private JdkManager jdkManager;
    private Collection<String> availableJdks;
    @Autowired
    private JobCreationService jobCreationService;
    @Autowired
    private ChainCreationService chainCreationService;
    @Autowired
    private BuildTriggerConditionConfigHelper buildTriggerConditionConfigHelper;
    private final Supplier<Plan> mutablePlan = Lazy.supplier((Supplier)new Supplier<Plan>(){

        @Override
        @Nullable
        public Plan get() {
            return CreateChain.this.plan == null ? null : CreateChain.this.planManager.getPlanById(CreateChain.this.plan.getId());
        }
    });
    @Autowired
    private CustomVariableContext customVariableContext;
    @Autowired
    private VariableSubstitutorFactory variableSubstitutorFactory;
    @Autowired
    private VcsRepositoryManager vcsRepositoryManager;
    @Autowired
    private VcsUIConfigBean vcsUIConfigBean;
    @Autowired
    protected VcsRepositoryConfigurationService vcsRepositoryConfigurationService;
    @Autowired
    private RawRepositoryConfigurationXmlConverter rawRepositoryConfigurationXmlConverter;
    @Autowired
    private RepositoryDefinitionManager repositoryDefinitionManager;
    @Autowired
    protected VcsConfigurationHelper vcsConfigurationHelper;

    @Override
    public String doDefault() throws Exception {
        if (this.isEc2ConfigurationWarningRequired()) {
            return WARN_ELASTIC_NOT_CONFIGURED;
        }
        if (this.planLimitReached) {
            this.planLimitReached = false;
            return PERMISSION_DENIED_ERROR;
        }
        this.initVcsTypeSelectors(TaskRenderMode.SUCCESS);
        if (StringUtils.isBlank((CharSequence)this.existingProjectKey)) {
            this.existingProjectKey = this.uiConfigBean.getFirstProjectKeyForPlanCreation();
        }
        return "input";
    }

    private void initVcsTypeSelectors(@NotNull TaskRenderMode renderMode) {
        Project projectByKey;
        AtomicReference<Long> projectId = new AtomicReference<Long>();
        if (!this.newProject && (projectByKey = this.projectManager.getProjectByKey(this.existingProjectKey)) != null) {
            projectId.set(projectByKey.getId());
        }
        String repositoryKey = this.buildConfigurationFromUI.getString("selectedRepository");
        List vcsRepositoryModuleDescriptors = this.vcsRepositoryManager.getAvailableRepositoryDescriptors();
        this.vcsTypeSelectors = vcsRepositoryModuleDescriptors.stream().map(input -> new VcsUIConfigBean.VcsTypeSelector((VcsRepositoryModuleDescriptor)input, this.vcsUIConfigBean.prepareCreateHtmlFragments((VcsRepositoryModuleDescriptor)input, input.getCompleteKey().equals(repositoryKey) ? renderMode : TaskRenderMode.SUCCESS, (Long)projectId.get()))).collect(Collectors.toList());
    }

    private void validatePermissions(ActionParametersMap parametersMap) {
        if (ChainParamMapHelper.isNewProject((ActionParametersMap)parametersMap)) {
            if (!this.bambooPermissionManager.canCreateProject()) {
                this.addActionError(this.getText("plan.create.error.insufficient.permissions.create.project"));
            }
        } else if (!this.bambooPermissionManager.canCreatePlanInProject(this.existingProjectKey)) {
            this.addActionError(this.getText("plan.create.error.insufficient.permissions.create.plan.in.project", Collections.singletonList(this.existingProjectKey)));
        }
    }

    public void validate() {
        ActionParametersMapImpl parametersMap = new ActionParametersMapImpl(ActionContext.getContext());
        this.validatePermissions((ActionParametersMap)parametersMap);
        if (!this.hasAnyErrors()) {
            this.chainCreationService.validateChainDetails((com.opensymphony.xwork.ValidationAware)this, (ActionParametersMap)parametersMap);
        }
        if (this.clonePlan && StringUtils.isNotBlank((CharSequence)this.planKeyToClone)) {
            this.chainCreationService.validateCloneDetails((com.opensymphony.xwork.ValidationAware)this, (ActionParametersMap)parametersMap);
        } else {
            String repositoryKey = this.buildConfigurationFromUI.getString("selectedRepository");
            if (!"nullRepository".equals(repositoryKey)) {
                if (StringUtils.isBlank((CharSequence)repositoryKey)) {
                    this.addFieldError("selectedRepository", this.getText("repository.not.selected"));
                } else {
                    VariableSubstitutor variableSubstitutor = this.variableSubstitutorFactory.newSubstitutorForGlobalContext();
                    this.customVariableContext.withVariableSubstitutor(variableSubstitutor, PlanConfigHelpers.getValidationRunnableForHelpers((ValidationAware)this, (BuildConfiguration)this.buildConfigurationFromUI, (PlanConfigHelper[])this.getComponentsOnPage()));
                    if (NumberUtils.isCreatable((String)repositoryKey)) {
                        VcsRepositoryModuleDescriptor moduleDescriptor;
                        long repositoryId = Long.parseLong(repositoryKey);
                        RepositoryDataEntity rde = this.vcsConfigurationHelper.validateRepositoryExistenceAndPermissions(repositoryId, (ValidationAware)this);
                        if (rde != null && (moduleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(rde.getPluginKey())) == null) {
                            this.addFieldError("selectedRepository", this.getText("repository.shared.missingPlugin", Collections.singletonList(rde.getPluginKey())));
                        }
                    } else {
                        this.vcsConfigurationHelper.validateSharedRepositoryName(this.repositoryName, (ValidationAware)this);
                        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
                        VcsRepositoryModuleDescriptor vcsRepositoryModuleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(repositoryKey);
                        this.customVariableContext.withVariableSubstitutor(variableSubstitutor, () -> this.lambda$validate$1(vcsRepositoryModuleDescriptor, (ErrorCollection)errorCollection));
                        this.addErrorCollection((ErrorCollection)errorCollection);
                    }
                }
            }
        }
        if (this.hasAnyErrors()) {
            this.initVcsTypeSelectors(TaskRenderMode.ERROR);
        }
    }

    public String cloneBuild() throws Exception {
        if (!this.planManager.isPlanCreationAllowed()) {
            return PERMISSION_DENIED_ERROR;
        }
        try {
            BuildConfiguration chainBuildConfiguration = new BuildConfiguration(this.buildConfigurationFromUI.asXml());
            ActionParametersMapImpl actionParametersMap = new ActionParametersMapImpl(ActionContext.getContext());
            this.newProject = ChainParamMapHelper.isNewProject((ActionParametersMap)actionParametersMap);
            this.buildKey = this.chainCreationService.createPlan(chainBuildConfiguration, (ActionParametersMap)actionParametersMap, PlanCreationService.EnablePlan.valueOf((boolean)this.chainEnabled));
            this.chainCreationService.triggerCreationCompleteEvents(PlanKeys.getPlanKey((String)this.buildKey));
        }
        catch (PlanCreationDeniedException e) {
            log.error((Object)this.getText("plan.create.error"), (Throwable)e);
            return PERMISSION_DENIED_ERROR;
        }
        catch (PlanCreationException e) {
            this.addActionError(this.getText("plan.create.error") + " " + e.getMessage());
            log.error((Object)this.getText("plan.create.error"), (Throwable)e);
            return "error";
        }
        log.info((Object)("New Plan created with key " + this.buildKey));
        return this.chainEnabled ? "success" : SUCCESS_PLAN_DISABLED;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String createBuild() throws Exception {
        if (!this.planManager.isPlanCreationAllowed()) {
            return PERMISSION_DENIED_ERROR;
        }
        try {
            BuildConfiguration chainBuildConfiguration = new BuildConfiguration(this.buildConfigurationFromUI.asXml());
            String repositoryKey = this.buildConfigurationFromUI.getString("selectedRepository");
            if (repositoryKey != null && !repositoryKey.equals("nullRepository")) {
                long repositoryId;
                TriggerModuleDescriptor triggerModuleDescriptor;
                if (!NumberUtils.isCreatable((String)repositoryKey)) {
                    if (!this.vcsConfigurationHelper.currentUserHasPermissionToCreateSharedRepository()) {
                        this.addActionError(this.getText("plan.create.repository.no.permission"));
                        return "error";
                    }
                    VcsRepositoryModuleDescriptor vcsRepositoryModuleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(repositoryKey);
                    triggerModuleDescriptor = ((TriggerTypeManager)ComponentAccessor.TRIGGER_TYPE_MANAGER.get()).getTriggerDescriptor(vcsRepositoryModuleDescriptor.getDefaultTriggerKey());
                    VariableSubstitutor variableSubstitutor = this.variableSubstitutorFactory.newSubstitutorForGlobalContext();
                    PartialVcsRepositoryData newRepositoryData = (PartialVcsRepositoryData)this.customVariableContext.withVariableSubstitutor(variableSubstitutor, () -> this.vcsUIConfigBean.getPartialVcsConfigurationFromActionData(vcsRepositoryModuleDescriptor, this.repositoryName, "", null, true, VcsConfigurationHelper.OVERRIDE_ALL));
                    try {
                        VcsRepositoryConfigurationService.LinkedRepositoryAccess repositoryAccess = VcsRepositoryConfigurationService.LinkedRepositoryAccess.valueOf((String)chainBuildConfiguration.getString("linkedRepositoryAccessOption", VcsRepositoryConfigurationService.LinkedRepositoryAccess.ALL_USERS.name()));
                        PartialVcsRepositoryData linkedRepository = this.vcsRepositoryConfigurationService.createLinkedRepository(newRepositoryData, this.getUser(), repositoryAccess);
                        repositoryId = linkedRepository.getId();
                    }
                    catch (Exception e) {
                        this.addActionError(e);
                        return "error";
                    }
                } else {
                    repositoryId = Long.parseLong(repositoryKey);
                    RepositoryDataEntity rde = this.repositoryDefinitionManager.getRepositoryDataEntity(repositoryId);
                    VcsRepositoryModuleDescriptor vcsRepositoryModuleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(rde.getPluginKey());
                    triggerModuleDescriptor = ((TriggerTypeManager)ComponentAccessor.TRIGGER_TYPE_MANAGER.get()).getTriggerDescriptor(vcsRepositoryModuleDescriptor.getDefaultTriggerKey());
                }
                chainBuildConfiguration.setProperty("selectedRepository", (Object)Long.toString(repositoryId));
                if (triggerModuleDescriptor != null) {
                    this.addDefaultTriggerToConfig(triggerModuleDescriptor, (HierarchicalConfiguration)chainBuildConfiguration);
                }
            }
            ActionParametersMapImpl actionParametersMap = new ActionParametersMapImpl(ActionContext.getContext());
            this.newProject = ChainParamMapHelper.isNewProject((ActionParametersMap)actionParametersMap);
            this.buildKey = this.chainCreationService.createPlan(chainBuildConfiguration, (ActionParametersMap)actionParametersMap, PlanCreationService.EnablePlan.DISABLED);
            this.jobKey = this.setupDefaultJobIfRequired();
        }
        catch (PlanCreationDeniedException e) {
            log.error((Object)this.getText("plan.create.error"), (Throwable)e);
            return PERMISSION_DENIED_ERROR;
        }
        catch (PlanCreationException e) {
            this.addActionError(this.getText("plan.create.error") + " " + e.getMessage());
            log.error((Object)this.getText("plan.create.error"), (Throwable)e);
            return "error";
        }
        log.info((Object)("New Plan created with key " + this.buildKey));
        return "success";
    }

    private void addDefaultTriggerToConfig(@NotNull TriggerModuleDescriptor triggerModuleDescriptor, @NotNull HierarchicalConfiguration configuration) {
        TriggerConfigurator triggerConfigurator = triggerModuleDescriptor.getTriggerConfigurator();
        if (triggerConfigurator != null) {
            HashMap fakeContext = new HashMap();
            triggerConfigurator.populateContextForCreate(fakeContext);
            Map cfgMap = triggerConfigurator.generateTriggerConfigMap((ActionParametersMap)new SimpleActionParametersMap(fakeContext), null);
            HashSet triggeringRepositories = new HashSet();
            TriggerDefinition triggerDefinition = new TriggerDefinitionImpl.Builder().fromDescriptor(triggerModuleDescriptor).id(1L).triggeringRepositories(triggeringRepositories).configuration(cfgMap).userDescription("").build();
            TriggerConfigurationUtils.addTriggerDefinitionsToConfig((Iterable)Lists.newArrayList((Object[])new TriggerDefinition[]{triggerDefinition}), (HierarchicalConfiguration)configuration);
        }
    }

    @Nullable
    private String setupDefaultJobIfRequired() throws PlanCreationDeniedException {
        ActionParametersMapImpl actionParametersMap = new ActionParametersMapImpl(new HashMap());
        JobParamMapHelper.setBuildKey((ActionParametersMap)actionParametersMap, (String)this.buildKey);
        JobParamMapHelper.setBuildName((ActionParametersMap)actionParametersMap, (String)JOB_NAME);
        JobParamMapHelper.setSubBuildKey((ActionParametersMap)actionParametersMap, (String)JOB_KEY);
        JobParamMapHelper.setStageName((ActionParametersMap)actionParametersMap, (String)STAGE_NAME);
        JobParamMapHelper.setExistingStage((ActionParametersMap)actionParametersMap, (String)JobCreationConstants.NEW_STAGE_MARKER);
        BuildConfiguration jobBuildConfiguration = new BuildConfiguration(this.buildConfigurationFromUI.asXml());
        jobBuildConfiguration.setProperty("inheritRepository", (Object)"true");
        String jobKey = this.jobCreationService.createPlan(jobBuildConfiguration, (ActionParametersMap)actionParametersMap, PlanCreationService.EnablePlan.ENABLED);
        this.jobCreationService.triggerCreationCompleteEvents(PlanKeys.getPlanKey((String)jobKey));
        return jobKey;
    }

    private BuildConfiguration getBuildConfigurationWithDefaults() {
        BuildConfiguration buildConfiguration = new BuildConfiguration();
        for (PlanConfigHelper helper : this.getComponentsOnPage()) {
            helper.addDefaultsToConfig(buildConfiguration);
        }
        buildConfiguration.setProperty("linkedRepositoryAccessOption", (Object)VcsRepositoryConfigurationService.LinkedRepositoryAccess.ALL_USERS.name());
        return buildConfiguration;
    }

    private PlanConfigHelper[] getComponentsOnPage() {
        return new PlanConfigHelper[]{this.buildTriggerConditionConfigHelper};
    }

    public Collection<String> getAvailableJdks() {
        if (this.availableJdks == null) {
            this.availableJdks = this.jdkManager.getJdkLabels();
        }
        return this.availableJdks;
    }

    @Override
    public BuildConfiguration getBuildConfiguration() {
        if (this.buildConfigurationFromUI == null) {
            this.buildConfigurationFromUI = this.getBuildConfigurationWithDefaults();
            this.buildConfigurationFromUI.setProperty(TMP_CREATE_AS_ENABLED_PROPERTY, (Object)true);
        }
        return this.buildConfigurationFromUI;
    }

    @NotNull
    public String getRepositoryPluginKeys() {
        StringBuilder sb = new StringBuilder();
        for (VcsRepositoryModuleDescriptor moduleDescriptor : this.vcsRepositoryManager.getAvailableRepositoryDescriptors()) {
            sb.append(moduleDescriptor.getCompleteKey());
            sb.append(" ");
        }
        return sb.toString();
    }

    @Override
    public void setBuildConfiguration(BuildConfiguration buildConfiguration) {
        this.buildConfigurationFromUI = buildConfiguration;
    }

    @Override
    public ImmutablePlan getImmutablePlan() {
        return this.plan;
    }

    @Override
    @Deprecated
    public Plan getPlan() {
        return this.getMutablePlan();
    }

    @Override
    public Plan getMutablePlan() {
        return this.mutablePlan.get();
    }

    @Override
    public void setPlan(ImmutablePlan plan) {
        this.plan = plan;
    }

    public String getBuildKey() {
        return this.buildKey;
    }

    public void setBuildKey(String buildKey) {
        this.buildKey = buildKey;
    }

    @Override
    public void setPlanLimitReached() {
        this.planLimitReached = true;
    }

    @Override
    public boolean isPlanLimitReached() {
        return this.planLimitReached;
    }

    public String getJobKey() {
        return this.jobKey;
    }

    public boolean isClonePlan() {
        return this.clonePlan;
    }

    public void setClonePlan(boolean clonePlan) {
        this.clonePlan = clonePlan;
    }

    public String getPlanKeyToClone() {
        return this.planKeyToClone;
    }

    public void setPlanKeyToClone(String planKeyToClone) {
        PlanKey planKey;
        PlanKey chainKeyIfJobKey;
        this.planKeyToClone = StringUtils.isNotBlank((CharSequence)planKeyToClone) ? ((chainKeyIfJobKey = PlanKeys.getChainKeyIfJobKey((PlanKey)(planKey = PlanKeys.getPlanKey((String)planKeyToClone)))) != null ? chainKeyIfJobKey.getKey() : planKeyToClone) : null;
    }

    public String getExistingProjectKey() {
        return this.existingProjectKey;
    }

    public void setExistingProjectKey(String existingProjectKey) {
        this.existingProjectKey = existingProjectKey;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public VcsUIConfigBean getVcsUIConfigBean() {
        return this.vcsUIConfigBean;
    }

    public boolean isChainEnabled() {
        return this.chainEnabled;
    }

    public void setChainEnabled(boolean chainEnabled) {
        this.chainEnabled = chainEnabled;
    }

    @NotNull
    public Collection<ImmutableChain> getPlansToClone() {
        return this.cachedPlanManager.getPlansForClone();
    }

    public List<VcsUIConfigBean.VcsTypeSelector> getVcsTypeSelectors() {
        return this.vcsTypeSelectors;
    }

    public List<VcsUIConfigBean.VcsTypeSelector> getPrimaryVcsTypeSelectors() {
        return this.vcsTypeSelectors.stream().filter(VcsUIConfigBean.VcsTypeSelector::isPrimary).collect(Collectors.toList());
    }

    public List<VcsUIConfigBean.VcsTypeSelector> getNonPrimaryVcsTypeSelectors() {
        return this.vcsTypeSelectors.stream().filter(input -> !input.isPrimary()).collect(Collectors.toList());
    }

    public UIConfigSupport getUiConfigBean() {
        return this.uiConfigBean;
    }

    public boolean isNewProject() {
        return this.newProject;
    }

    private /* synthetic */ void lambda$validate$1(VcsRepositoryModuleDescriptor vcsRepositoryModuleDescriptor, ErrorCollection errorCollection) {
        this.vcsUIConfigBean.validateVcsConfiguration(vcsRepositoryModuleDescriptor, null, errorCollection, VcsConfigurationHelper.OVERRIDE_ALL);
    }
}

