/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build.admin.config.variable;

import com.atlassian.bamboo.util.PasswordMaskingUtils;
import com.atlassian.bamboo.variable.EncryptedVariableDefinitionAccessor;
import com.atlassian.bamboo.variable.VariableConfigurationService;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.ww2.actions.build.admin.config.variable.ConfigurePlanVariables;
import com.atlassian.bamboo.ww2.aware.RssConfigurationAware;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;

public class UpdatePlanVariable
extends ConfigurePlanVariables {
    private VariableDefinition variableDefinitionFromDb;
    @Inject
    private VariableConfigurationService variableConfigurationService;
    @Inject
    private EncryptedVariableDefinitionAccessor variableDefinitionAccessor;

    public void validate() {
        this.validateId();
        if (!this.hasAnyErrors()) {
            VariableDefinition duplicateCandidate;
            this.variableDefinitionFromDb = (VariableDefinition)Preconditions.checkNotNull((Object)this.variableDefinitionAccessor.findVariableDefinition(this.getUnmaskedVariableId()));
            this.validateKeyAndValue();
            if (StringUtils.isNotEmpty((CharSequence)this.variableKey) && (duplicateCandidate = this.getVariableMap().get(this.variableKey)) != null && this.variableDefinitionFromDb.getId() != Math.abs(duplicateCandidate.getId())) {
                this.addFieldError("variableKey", this.getText("plan.variables.error.key.duplicate", new String[]{this.variableKey}));
            }
        }
    }

    @RssConfigurationAware
    public String execute() throws Exception {
        String previousValue = this.variableDefinitionFromDb.getValue();
        if (!PasswordMaskingUtils.shouldIgnoreValue((String)this.variableDefinitionFromDb.getKey(), (String)this.variableValue)) {
            this.variableDefinitionFromDb.setValue(this.variableValue);
        }
        this.variableDefinitionFromDb.setKey(this.variableKey);
        this.variableConfigurationService.updateVariableDefinition(this.variableDefinitionFromDb, previousValue);
        this.triggerAnalyticsEvent();
        return "success";
    }
}

