/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build.admin.config.variable;

import com.atlassian.bamboo.event.analytics.PlanConfigurationChangedAnalyticsEvent;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.util.PasswordMaskingUtils;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.variable.EncryptedVariableDefinitionAccessor;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableDefinitionImpl;
import com.atlassian.bamboo.variable.VariableUtils;
import com.atlassian.bamboo.variable.VariableValidationService;
import com.atlassian.bamboo.ww2.actions.build.admin.BuildConfigurationSupport;
import com.atlassian.bamboo.ww2.aware.permissions.PlanEditSecurityAware;
import com.atlassian.struts.ValidationAware;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;

public class ConfigurePlanVariables
extends BuildConfigurationSupport
implements PlanEditSecurityAware {
    private long variableId;
    protected String variableKey;
    protected String variableValue;
    private Collection<? extends VariableDefinition> variables;
    private List<VariableDefinition> masterVariables;
    private Map<String, VariableDefinition> variableMap;
    @Inject
    private EncryptedVariableDefinitionAccessor variableDefinitionAccessor;
    @Inject
    private VariableValidationService variableValidationService;

    protected void validateId() {
        this.variableValidationService.validateIdForPlanVariable((ValidationAware)this, this.getUnmaskedVariableId(), this.getImmutablePlan());
    }

    protected long getUnmaskedVariableId() {
        return Math.abs(this.variableId);
    }

    protected void validateKey() {
        this.variableValidationService.validateKey((ValidationAware)this, "variableKey", this.variableKey);
    }

    protected void validateKeyAndValue() {
        this.validateKey();
        if (!this.getFieldErrors().containsKey("variableKey")) {
            if (PasswordMaskingUtils.shouldBeMasked((String)this.variableKey)) {
                this.variableValidationService.validateValueForEncryptedVariable((ValidationAware)this, "variableValue_password", this.variableValue);
            } else {
                this.variableValidationService.validateValueForVariable((ValidationAware)this, "variableValue", this.variableValue);
            }
        }
    }

    public Collection<? extends VariableDefinition> getVariables() {
        if (this.variables == null) {
            this.variables = PasswordMaskingUtils.maskPasswordValues((Collection)this.variableDefinitionAccessor.getPlanVariables((PlanIdentifier)this.getImmutablePlan()), VariableDefinitionImpl::clone);
        }
        return this.variables;
    }

    public List<? extends VariableDefinition> getInheritedVariables() {
        if (this.masterVariables == null) {
            ImmutablePlan master = this.getImmutablePlan().getMaster();
            this.masterVariables = new ArrayList<VariableDefinition>(PasswordMaskingUtils.maskPasswordValues((Collection)this.variableDefinitionAccessor.getInheritedVariables((PlanIdentifier)this.getImmutablePlan()), VariableDefinitionImpl::clone));
        }
        return this.masterVariables;
    }

    public Map<String, VariableDefinition> getOverriddenVariablesMap() {
        return VariableUtils.buildVariableDefinitionMap(this.getInheritedVariables());
    }

    public List<? extends VariableDefinition> getInheritedNotOverriddenVariables() {
        return Comparators.getVariableDefinitionContextOrdering().sortedCopy(this.getAndMaskInheritedNotOverriddenVariables());
    }

    public List<? extends VariableDefinition> getInheritedNotOverriddenVariablesByName() {
        return Comparators.getVariableDefinitionOrdering().sortedCopy(this.getAndMaskInheritedNotOverriddenVariables());
    }

    @NotNull
    private Collection<? extends VariableDefinition> getAndMaskInheritedNotOverriddenVariables() {
        return PasswordMaskingUtils.maskPasswordValues((Collection)this.variableDefinitionAccessor.getInheritedNotOverriddenVariables((PlanIdentifier)this.getImmutablePlan()), VariableDefinitionImpl::clone);
    }

    public Map<String, VariableDefinition> getVariableMap() {
        if (this.variableMap == null) {
            this.variableMap = VariableUtils.buildVariableDefinitionMap(this.getVariables());
        }
        return this.variableMap;
    }

    protected void triggerAnalyticsEvent() {
        this.eventPublisher.publish((Object)new PlanConfigurationChangedAnalyticsEvent());
    }

    public long getVariableId() {
        return this.variableId;
    }

    public void setVariableId(long variableId) {
        this.variableId = variableId;
    }

    public String getVariableKey() {
        return this.variableKey;
    }

    public void setVariableKey(String variableKey) {
        this.variableKey = variableKey;
    }

    public String getVariableValue() {
        return this.variableValue;
    }

    public void setVariableValue(String variableValue) {
        this.variableValue = variableValue;
    }
}

