/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build.admin.config.task;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plugin.descriptor.TaskConditionModuleDescriptor;
import com.atlassian.bamboo.struts.OgnlStackUtils;
import com.atlassian.bamboo.task.DecoratedTaskDefinition;
import com.atlassian.bamboo.task.TaskConditionConfig;
import com.atlassian.bamboo.task.TaskConditionConfigImpl;
import com.atlassian.bamboo.task.TaskConfigurator;
import com.atlassian.bamboo.task.TaskContainer;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskModuleDescriptor;
import com.atlassian.bamboo.task.TaskService;
import com.atlassian.bamboo.task.condition.TaskCondition;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.BambooPredicates;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityGroup;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityHelper;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityRequirementSetDecorator;
import com.atlassian.bamboo.v2.build.agent.capability.DecoratedCapabilityRequirement;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementDecorator;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementDecoratorComparator;
import com.atlassian.bamboo.v2.build.requirement.ImmutableRequirement;
import com.atlassian.bamboo.web.utils.ActionParamHandlingUtils;
import com.atlassian.bamboo.webwork.util.ActionParametersMapImpl;
import com.atlassian.bamboo.ww2.actions.build.admin.config.task.TaskOwner;
import com.atlassian.bamboo.ww2.actions.build.admin.config.task.TaskRenderMode;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.struts.TextProvider;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import com.opensymphony.xwork2.ActionContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

@Internal
public class TaskUIConfigBean {
    private static final Logger log = Logger.getLogger(TaskUIConfigBean.class);
    @Autowired
    private TemplateRenderer templateRenderer;
    @Autowired
    private TextProvider textProvider;
    @Autowired
    private CapabilityHelper capabilityHelper;
    @Autowired
    private TaskService taskService;
    @Autowired
    private PluginAccessor pluginAccessor;

    public List<DecoratedTaskDefinition> getDecoratedTaskDefinitions(@NotNull ImmutableJob job) {
        return this.taskService.getDecoratedTaskDefinitions((TaskContainer)job).stream().filter(arg_0 -> ((Predicate)Predicates.not((Predicate)BambooPredicates.isFinalizingTaskDefinition())).apply(arg_0)).collect(Collectors.toCollection(ArrayList::new));
    }

    public List<DecoratedTaskDefinition> getDecoratedFinalisingTaskDefinitions(@NotNull ImmutableJob job) {
        return this.taskService.getDecoratedTaskDefinitions((TaskContainer)job).stream().filter(arg_0 -> ((Predicate)BambooPredicates.isFinalizingTaskDefinition()).apply(arg_0)).collect(Collectors.toCollection(ArrayList::new));
    }

    public List<DecoratedTaskDefinition> getDecoratedTaskDefinitions(@NotNull Environment environment) {
        return this.taskService.getDecoratedTaskDefinitions((TaskContainer)environment).stream().filter(arg_0 -> ((Predicate)Predicates.not((Predicate)BambooPredicates.isFinalizingTaskDefinition())).apply(arg_0)).collect(Collectors.toCollection(ArrayList::new));
    }

    public List<DecoratedTaskDefinition> getDecoratedFinalisingTaskDefinitions(@NotNull Environment environment) {
        return this.taskService.getDecoratedTaskDefinitions((TaskContainer)environment).stream().filter(arg_0 -> ((Predicate)BambooPredicates.isFinalizingTaskDefinition()).apply(arg_0)).collect(Collectors.toCollection(ArrayList::new));
    }

    @NotNull
    public String prepareCreateHtml(@NotNull TaskModuleDescriptor taskDescriptor, @NotNull TaskRenderMode renderMode, @NotNull TaskOwner taskOwner) {
        TaskConfigurator taskConfigurator = taskDescriptor.getTaskConfigurator();
        if (taskConfigurator != null) {
            Map<String, Object> contextParams = taskOwner.buildContextMap();
            taskConfigurator.populateContextForCreate(contextParams);
            return this.renderEditHtml(taskDescriptor, contextParams, renderMode);
        }
        return "";
    }

    @NotNull
    public String prepareEditHtml(@NotNull TaskModuleDescriptor taskDescriptor, @NotNull TaskDefinition taskDefinition, @NotNull TaskRenderMode renderMode, @NotNull TaskOwner taskOwner) {
        TaskConfigurator taskConfigurator = taskDescriptor.getTaskConfigurator();
        if (taskConfigurator != null) {
            Map<String, Object> context = taskOwner.buildContextMap();
            taskConfigurator.populateContextForEdit(context, taskDefinition);
            return this.renderEditHtml(taskDescriptor, context, renderMode);
        }
        return "";
    }

    @Deprecated
    public void validateTaskConfiguration(@NotNull TaskModuleDescriptor taskDescriptor, @NotNull ErrorCollection errorCollection) {
        this.validateTaskConfiguration(taskDescriptor, null, errorCollection);
    }

    public void validateTaskConfiguration(@NotNull TaskModuleDescriptor taskDescriptor, @Nullable List<TaskConditionConfig> conditions, @NotNull ErrorCollection errorCollection) {
        TaskConfigurator taskConfigurator = taskDescriptor.getTaskConfigurator();
        if (taskConfigurator != null) {
            ActionParametersMapImpl actionParametersMap = new ActionParametersMapImpl(ActionContext.getContext(), true);
            taskConfigurator.validate((ActionParametersMap)actionParametersMap, errorCollection);
            if (conditions != null) {
                for (TaskConditionConfig taskCondition : conditions) {
                    TaskConditionModuleDescriptor taskConditionDescriptor = (TaskConditionModuleDescriptor)Narrow.to((Object)this.pluginAccessor.getEnabledPluginModule(taskCondition.getConditionPluginKey()), TaskConditionModuleDescriptor.class);
                    if (taskConditionDescriptor == null) {
                        errorCollection.addError("condition", "Can't find " + taskCondition.getConditionPluginKey() + " plugin. Remove this condition");
                        continue;
                    }
                    TaskCondition condition = (TaskCondition)taskConditionDescriptor.getModule();
                    ErrorCollection errors = condition.validate((ActionParametersMap)actionParametersMap);
                    if (errors == null || !errors.hasAnyErrors()) continue;
                    errorCollection.addFieldErrors(errors.getFieldErrors());
                }
            }
        }
    }

    @NotNull
    public Map<String, String> getTaskConfigurationMap(@NotNull TaskModuleDescriptor taskDescriptor, @Nullable TaskDefinition previousTaskDefinition) {
        TaskConfigurator taskConfigurator = taskDescriptor.getTaskConfigurator();
        if (taskConfigurator != null) {
            return taskConfigurator.generateTaskConfigMap((ActionParametersMap)new ActionParametersMapImpl(ActionContext.getContext(), true), previousTaskDefinition);
        }
        return new HashMap<String, String>();
    }

    @NotNull
    public Multimap<String, String> getTasksRequirementsConflicts(@NotNull Collection<? extends ImmutableRequirement> tasksRequirements) {
        TreeMultimap requirementsConflicts = TreeMultimap.create((Comparator)Ordering.natural(), (Comparator)Ordering.natural());
        CapabilityRequirementSetDecorator capabilityRequirementSetDecorator = new CapabilityRequirementSetDecorator(tasksRequirements, this.textProvider, this.capabilityHelper);
        if (!capabilityRequirementSetDecorator.getDecoratedObjects().isEmpty()) {
            for (CapabilityGroup group : capabilityRequirementSetDecorator.getGroups()) {
                for (DecoratedCapabilityRequirement decoratedCapabilityRequirement : this.findConflictsInCapabilityGroup(group)) {
                    requirementsConflicts.put((Object)group.getTypeLabel(), (Object)decoratedCapabilityRequirement.getLabel());
                }
            }
        }
        return requirementsConflicts;
    }

    public String conditionHtml(String conditionPluginKey, @Nullable TaskDefinition taskDefinition, @NotNull ActionParametersMap params) {
        TaskConditionModuleDescriptor enabledPluginModule = (TaskConditionModuleDescriptor)Narrow.downTo((Object)this.pluginAccessor.getEnabledPluginModule(conditionPluginKey), TaskConditionModuleDescriptor.class);
        if (enabledPluginModule != null) {
            TaskCondition taskCondition = (TaskCondition)enabledPluginModule.getModule();
            HashMap existingConditionConfig = new HashMap();
            if (taskDefinition != null) {
                taskDefinition.getConditions().stream().filter(condition -> condition.getConditionPluginKey().equals(conditionPluginKey)).findFirst().ifPresent(taskConditionConfig -> existingConditionConfig.putAll(taskConditionConfig.getConfiguration()));
            }
            HashMap<String, Object> contextParams = new HashMap<String, Object>(taskCondition.prepareParametersMap(existingConditionConfig, params));
            return this.renderConditionEditHtml(enabledPluginModule, contextParams);
        }
        return "";
    }

    @NotNull
    private String renderConditionEditHtml(@NotNull TaskConditionModuleDescriptor conditionModuleDescriptor, @NotNull Map<String, Object> contextParams) {
        ActionContext.getContext().getActionInvocation().getStack().getContext().putAll(contextParams);
        ResourceLocation resourceLocation = conditionModuleDescriptor.getResourceLocation("freemarker", "edit");
        if (resourceLocation != null) {
            String templatePath = resourceLocation.getLocation();
            String html = this.templateRenderer.render(templatePath, contextParams);
            return StringUtils.defaultString((String)html, (String)"");
        }
        return "";
    }

    @NotNull
    private String renderEditHtml(@NotNull TaskModuleDescriptor taskDescriptor, @NotNull Map<String, Object> contextParams, TaskRenderMode renderMode) {
        if (renderMode == TaskRenderMode.ERROR) {
            ActionParamHandlingUtils.appendContextTo(contextParams);
        }
        OgnlStackUtils.putAll(contextParams);
        ResourceLocation resourceLocation = taskDescriptor.getResourceLocation("freemarker", "edit");
        if (resourceLocation != null) {
            String templatePath = resourceLocation.getLocation();
            String html = this.templateRenderer.render(templatePath, contextParams);
            return StringUtils.defaultString((String)html, (String)"");
        }
        return "";
    }

    private Collection<DecoratedCapabilityRequirement> findConflictsInCapabilityGroup(@NotNull CapabilityGroup capabilityGroup) {
        TreeMultimap requirementByPluginKey = TreeMultimap.create((Comparator)Ordering.natural(), (Comparator)new RequirementDecoratorComparator());
        for (DecoratedCapabilityRequirement requirement : capabilityGroup.getDecoratedObjects()) {
            RequirementDecorator decorator = (RequirementDecorator)Narrow.downTo((Object)requirement, RequirementDecorator.class);
            if (decorator == null) continue;
            requirementByPluginKey.put((Object)decorator.getPluginModuleKey(), (Object)decorator);
        }
        HashSet<DecoratedCapabilityRequirement> matchingRequirements = new HashSet<DecoratedCapabilityRequirement>();
        for (String key : requirementByPluginKey.keySet()) {
            if (requirementByPluginKey.get((Object)key).size() <= 1) continue;
            matchingRequirements.addAll(requirementByPluginKey.get((Object)key));
        }
        return matchingRequirements;
    }

    public List<TaskConditionConfig> getTaskConditions(boolean isConditionalTask, @Nullable String selectedCondition) {
        ArrayList<TaskConditionConfig> conditions = new ArrayList<TaskConditionConfig>();
        if (isConditionalTask && StringUtils.isNotEmpty((CharSequence)selectedCondition)) {
            ActionParametersMapImpl actionParametersMap = new ActionParametersMapImpl(ActionContext.getContext(), true);
            TaskConditionModuleDescriptor descriptor = (TaskConditionModuleDescriptor)Narrow.downTo((Object)this.pluginAccessor.getEnabledPluginModule(selectedCondition), TaskConditionModuleDescriptor.class);
            if (descriptor == null) {
                return conditions;
            }
            TaskCondition condition = (TaskCondition)descriptor.getModule();
            Map conditionConfig = condition.prepareConfiguration((ActionParametersMap)actionParametersMap);
            conditions.add((TaskConditionConfig)new TaskConditionConfigImpl(selectedCondition, conditionConfig));
        }
        return conditions;
    }
}

