/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build.admin.config.task;

import com.atlassian.bamboo.deployments.DeploymentTaskContextHelper;
import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.deployments.projects.service.DeploymentProjectService;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.task.TaskContextHelper;
import com.atlassian.bamboo.ww2.actions.build.admin.config.task.TaskOwner;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnvironmentTaskOwner
implements TaskOwner {
    private static final Logger log = Logger.getLogger(EnvironmentTaskOwner.class);
    private final Environment environment;
    private final DeploymentProjectService deploymentProjectService;
    private final CachedPlanManager cachedPlanManager;

    public EnvironmentTaskOwner(Environment environment, DeploymentProjectService deploymentProjectService, CachedPlanManager cachedPlanManager) {
        this.environment = environment;
        this.deploymentProjectService = deploymentProjectService;
        this.cachedPlanManager = cachedPlanManager;
    }

    @Override
    @NotNull
    public Map<String, Object> buildContextMap() {
        ImmutablePlan plan = this.getRelatedPlan(this.environment);
        HashMap<String, Object> context = new HashMap<String, Object>();
        if (plan != null) {
            TaskContextHelper.setRelatedPlan(context, (ImmutablePlan)plan);
        }
        DeploymentTaskContextHelper.setEnvironment(context, (Environment)this.environment);
        TaskContextHelper.setDeploymentMode(context, (boolean)true);
        return context;
    }

    @Nullable
    private ImmutablePlan getRelatedPlan(@NotNull Environment environment) {
        PlanKey planKey;
        DeploymentProject project = this.deploymentProjectService.getDeploymentProject(environment.getDeploymentProjectId());
        if (project != null && (planKey = project.getPlanKey()) != null) {
            ImmutablePlan plan = this.cachedPlanManager.getPlanByKey(planKey);
            return plan;
        }
        log.info((Object)("Env: " + environment + " doesn't have a valid related plan"));
        return null;
    }
}

