/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build.admin.config.task;

import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.task.DecoratedTaskDefinitionImpl;
import com.atlassian.bamboo.task.ImmutableTaskDefinition;
import com.atlassian.bamboo.task.TaskConditionConfig;
import com.atlassian.bamboo.task.TaskContainer;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskHelpLink;
import com.atlassian.bamboo.task.TaskModuleDescriptor;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.ww2.actions.build.admin.config.task.ConfigureBuildTasks;
import com.atlassian.bamboo.ww2.actions.build.admin.config.task.DecoratedTaskManipulationResult;
import com.atlassian.bamboo.ww2.actions.build.admin.config.task.TaskRenderMode;
import com.atlassian.bamboo.ww2.aware.RssConfigurationAware;
import com.google.common.collect.Lists;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.xwork2.Preparable;
import java.util.List;
import org.apache.log4j.Logger;

public class EditTask
extends ConfigureBuildTasks
implements Preparable {
    private static final Logger log = Logger.getLogger(EditTask.class);
    private String editHtml;
    private TaskModuleDescriptor taskDescriptor;

    @Override
    public void prepare() throws Exception {
        super.prepare();
        ImmutablePlan plan = this.getImmutablePlan();
        if (plan != null) {
            this.taskDefinition = this.getTaskById(plan, this.taskId);
            if (this.taskDefinition != null) {
                this.taskDescriptor = this.taskManager.getTaskDescriptor(this.taskDefinition.getPluginKey());
                if (this.taskDescriptor != null) {
                    this.taskName = this.taskDescriptor.getName();
                }
            }
        }
    }

    public String input() {
        this.validateJob();
        if (this.taskDefinition == null) {
            this.addActionError(this.getText("tasks.edit.error.incorrectId", Lists.newArrayList((Object[])new Long[]{this.taskId})));
        }
        if (this.hasErrors()) {
            return "error";
        }
        if (this.taskDescriptor == null) {
            ImmutableJob job = (ImmutableJob)Narrow.downTo((Object)this.getImmutablePlan(), ImmutableJob.class);
            this.addActionError(this.getText("tasks.edit.error.missingPlugin", Lists.newArrayList((Object[])new String[]{this.taskDefinition.getPluginKey()})));
            this.taskDefinition = new DecoratedTaskDefinitionImpl(this.taskDefinition, null, (TaskContainer)job);
            return "invalidPlugin";
        }
        this.editHtml = this.taskUIConfigBean.prepareEditHtml(this.taskDescriptor, this.taskDefinition, TaskRenderMode.SUCCESS, this.taskOwnerFactory.createPlanTaskOwner((ImmutablePlan)this.getMutablePlan()));
        this.userDescription = this.taskDefinition.getUserDescription();
        this.taskDisabled = !this.taskDefinition.isEnabled();
        boolean bl = this.conditionalTask = !this.taskDefinition.getConditions().isEmpty();
        if (this.conditionalTask) {
            this.selectedCondition = ((TaskConditionConfig)this.taskDefinition.getConditions().get(0)).getConditionPluginKey();
        }
        this.workingDirSelector = this.taskDefinition.getRootDirectorySelector().getTaskRootDirectoryType();
        this.repositoryDefiningWorkingDirectory = this.taskDefinition.getRootDirectorySelector().getRepositoryDefiningWorkingDirectory();
        return "input";
    }

    @RssConfigurationAware
    public String execute() {
        try {
            ImmutableJob job = (ImmutableJob)Narrow.downTo((Object)this.getImmutablePlan(), ImmutableJob.class);
            ImmutableTaskDefinition previousTaskDefinition = new ImmutableTaskDefinition(this.taskDefinition);
            List<TaskConditionConfig> conditions = this.getTaskConditions();
            TaskDefinition newDef = this.taskConfigurationService.editTask(PlanKeys.getPlanKey((String)this.getPlanKey()), this.taskId, this.userDescription, !this.taskDisabled, conditions, this.taskUIConfigBean.getTaskConfigurationMap(this.taskDescriptor, (TaskDefinition)previousTaskDefinition), this.getRootDirSelector());
            this.jsonObject = new DecoratedTaskManipulationResult<ImmutableJob>(newDef, this.taskDescriptor, this.getTasksRequirementsConflicts(), job).getJsonObject();
        }
        catch (JSONException | IllegalArgumentException e) {
            this.addActionError((Exception)e);
            return "error";
        }
        this.triggerAnalyticsEvent();
        return "success";
    }

    public void validate() {
        this.checkFieldXssSafety("userDescription", this.userDescription);
        this.validateJob();
        if (this.taskDefinition == null) {
            this.addActionError(this.getText("tasks.edit.error.incorrectId", Lists.newArrayList((Object[])new Long[]{this.taskId})));
        } else if (this.taskDescriptor == null) {
            this.addActionError(this.getText("tasks.edit.error.missingPlugin", Lists.newArrayList((Object[])new String[]{this.taskDefinition.getPluginKey()})));
        } else {
            this.taskUIConfigBean.validateTaskConfiguration(this.taskDescriptor, this.getTaskConditions(), this);
            if (this.hasErrors() && this.taskDefinition != null) {
                this.editHtml = this.taskUIConfigBean.prepareEditHtml(this.taskDescriptor, this.taskDefinition, TaskRenderMode.ERROR, this.taskOwnerFactory.createPlanTaskOwner((ImmutablePlan)this.getMutablePlan()));
            }
        }
    }

    private void validateJob() {
        ImmutableJob job = (ImmutableJob)Narrow.downTo((Object)this.getImmutablePlan(), ImmutableJob.class);
        if (job == null) {
            this.addActionError(this.getText("task.edit.error.noPlan"));
        }
    }

    public String getSubmitAction() {
        return "updateTask";
    }

    public String getEditHtml() {
        return this.editHtml;
    }

    @Override
    public void setTemplateRenderer(TemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
    }

    public TaskDefinition getTaskDefinition() {
        return this.taskDefinition;
    }

    public TaskHelpLink getTaskHelpLink() {
        return this.taskDescriptor.getHelpLink();
    }
}

