/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build.admin.config.task;

import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.task.DecoratedTaskDefinitionImpl;
import com.atlassian.bamboo.task.TaskContainer;
import com.atlassian.bamboo.task.TaskModuleDescriptor;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.ww2.actions.build.admin.config.task.ConfigureBuildTasks;
import com.atlassian.bamboo.ww2.aware.RssConfigurationAware;
import com.google.common.collect.Lists;
import com.opensymphony.xwork2.Preparable;
import org.apache.log4j.Logger;

public class DeleteTask
extends ConfigureBuildTasks
implements Preparable {
    private static final Logger log = Logger.getLogger(DeleteTask.class);

    @Override
    public void prepare() throws Exception {
        super.prepare();
        ImmutableJob job = (ImmutableJob)Narrow.downTo((Object)this.getImmutablePlan(), ImmutableJob.class);
        if (job == null) {
            this.addActionError(this.getText("tasks.delete.error.noPlan"));
            return;
        }
        this.taskDefinition = this.getTaskById((ImmutablePlan)job, this.taskId);
        if (this.taskDefinition == null) {
            this.addActionError(this.getText("tasks.delete.error", Lists.newArrayList((Object[])new Long[]{this.taskId})));
            return;
        }
        TaskModuleDescriptor taskDescriptor = this.taskManager.getTaskDescriptor(this.taskDefinition.getPluginKey());
        this.taskName = taskDescriptor == null ? this.taskDefinition.getPluginKey() : taskDescriptor.getName();
        this.userDescription = this.taskDefinition.getUserDescription();
        this.jsonObject = new DecoratedTaskDefinitionImpl(this.taskDefinition, taskDescriptor, (TaskContainer)job).getJsonObject();
    }

    public String delete() {
        if (this.hasActionErrors()) {
            return "error";
        }
        return "input";
    }

    @RssConfigurationAware
    public String execute() {
        try {
            this.taskConfigurationService.deleteTask(PlanKeys.getPlanKey((String)this.getPlanKey()), this.taskId);
            this.triggerAnalyticsEvent();
            return "success";
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            this.addActionError(e);
            return "error";
        }
    }
}

