/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build.admin.config.task;

import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskHelpLink;
import com.atlassian.bamboo.task.TaskModuleDescriptor;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.ww2.actions.build.admin.config.task.ConfigureBuildTasks;
import com.atlassian.bamboo.ww2.actions.build.admin.config.task.DecoratedTaskManipulationResult;
import com.atlassian.bamboo.ww2.actions.build.admin.config.task.TaskRenderMode;
import com.atlassian.bamboo.ww2.aware.RssConfigurationAware;
import com.google.common.collect.Lists;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.xwork2.Preparable;
import org.apache.log4j.Logger;

public class CreateTask
extends ConfigureBuildTasks
implements Preparable {
    private static final Logger log = Logger.getLogger(CreateTask.class);
    private String createTaskKey;
    private String editHtml;
    private TaskModuleDescriptor taskDescriptor;

    @Override
    public void prepare() throws Exception {
        super.prepare();
        this.taskDescriptor = this.taskManager.getTaskDescriptor(this.createTaskKey);
        if (this.taskDescriptor != null) {
            this.taskName = this.taskDescriptor.getName();
        }
    }

    public String input() throws Exception {
        this.validateJob();
        if (this.hasErrors()) {
            return "error";
        }
        if (this.taskDescriptor == null) {
            this.addActionError(this.getText("tasks.add.error.missingPlugin", Lists.newArrayList((Object[])new String[]{this.createTaskKey})));
            return "invalidPlugin";
        }
        this.editHtml = this.taskUIConfigBean.prepareCreateHtml(this.taskDescriptor, TaskRenderMode.SUCCESS, this.taskOwnerFactory.createPlanTaskOwner((ImmutablePlan)this.getMutablePlan()));
        return "input";
    }

    @RssConfigurationAware
    public String execute() {
        try {
            ImmutableJob job = (ImmutableJob)Narrow.downTo((Object)this.getImmutablePlan(), ImmutableJob.class);
            TaskDefinition taskDefinition = this.taskConfigurationService.createTask(PlanKeys.getPlanKey((String)this.getPlanKey()), this.taskDescriptor, this.userDescription, !this.taskDisabled, this.getTaskConditions(), this.taskUIConfigBean.getTaskConfigurationMap(this.taskDescriptor, null), this.getRootDirSelector());
            this.jsonObject = new DecoratedTaskManipulationResult<ImmutableJob>(taskDefinition, this.taskDescriptor, this.getTasksRequirementsConflicts(), job).getJsonObject();
            this.triggerAnalyticsEvent();
            return "success";
        }
        catch (JSONException | IllegalArgumentException e) {
            this.addActionError((Exception)e);
            return "error";
        }
    }

    public void validate() {
        this.checkFieldXssSafety("userDescription", this.userDescription);
        this.validateJob();
        this.validateTaskDescriptorPresent();
        if (this.taskDescriptor != null) {
            this.taskUIConfigBean.validateTaskConfiguration(this.taskDescriptor, this.getTaskConditions(), this);
            if (this.hasErrors()) {
                this.editHtml = this.taskUIConfigBean.prepareCreateHtml(this.taskDescriptor, TaskRenderMode.ERROR, this.taskOwnerFactory.createPlanTaskOwner((ImmutablePlan)this.getMutablePlan()));
            }
        }
    }

    private void validateJob() {
        ImmutableJob job = (ImmutableJob)Narrow.downTo((Object)this.getImmutablePlan(), ImmutableJob.class);
        if (job == null) {
            this.addActionError(this.getText("task.add.error.noPlan"));
        }
    }

    private void validateTaskDescriptorPresent() {
        if (this.taskDescriptor == null) {
            this.addActionError(this.getText("tasks.add.error.missingPlugin", Lists.newArrayList((Object[])new String[]{this.createTaskKey})));
        }
    }

    public String getSubmitAction() {
        return "createTask";
    }

    public void setCreateTaskKey(String createTaskKey) {
        this.createTaskKey = createTaskKey;
    }

    public String getCreateTaskKey() {
        return this.createTaskKey;
    }

    public String getEditHtml() {
        return this.editHtml;
    }

    public TaskHelpLink getTaskHelpLink() {
        return this.taskDescriptor.getHelpLink();
    }
}

