/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build.admin.config.task;

import com.atlassian.bamboo.build.creation.RepositoryConfigHelper;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.event.analytics.PlanConfigurationChangedAnalyticsEvent;
import com.atlassian.bamboo.jsonator.Jsonator;
import com.atlassian.bamboo.plan.PlanClassHelper;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plugin.descriptor.TaskConditionModuleDescriptor;
import com.atlassian.bamboo.task.DecoratedTaskDefinition;
import com.atlassian.bamboo.task.TaskCategory;
import com.atlassian.bamboo.task.TaskConditionConfig;
import com.atlassian.bamboo.task.TaskConfigurationService;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskManager;
import com.atlassian.bamboo.task.TaskModuleDescriptor;
import com.atlassian.bamboo.task.TaskRootDirectorySelector;
import com.atlassian.bamboo.task.TaskRootDirectoryType;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.BambooPredicates;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.webwork.util.ActionParametersMapImpl;
import com.atlassian.bamboo.ww2.actions.BuildActionSupport;
import com.atlassian.bamboo.ww2.actions.build.admin.config.task.TaskOwnerFactory;
import com.atlassian.bamboo.ww2.actions.build.admin.config.task.TaskUIConfigBean;
import com.atlassian.bamboo.ww2.aware.permissions.PlanEditSecurityAware;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.predicate.ModuleDescriptorOfClassPredicate;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.Preparable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureBuildTasks
extends BuildActionSupport
implements PlanEditSecurityAware,
Preparable {
    protected static final String INVALID_PLUGIN = "invalidPlugin";
    private List<TaskModuleDescriptor> availableTasks;
    private boolean saved;
    protected long taskId;
    protected String taskName;
    protected TaskDefinition taskDefinition;
    protected String userDescription;
    protected boolean taskDisabled;
    protected boolean conditionalTask;
    protected List<Pair<String, String>> conditions;
    protected String selectedCondition;
    protected JSONObject jsonObject;
    protected TaskManager taskManager;
    protected TemplateRenderer templateRenderer;
    protected TaskConfigurationService taskConfigurationService;
    protected TaskRootDirectoryType workingDirSelector = TaskRootDirectoryType.INHERITED;
    protected long repositoryDefiningWorkingDirectory = -1L;
    protected TaskUIConfigBean taskUIConfigBean;
    protected TaskOwnerFactory taskOwnerFactory;
    @Inject
    protected VcsRepositoryManager vcsRepositoryManager;
    @Inject
    protected EventPublisher eventPublisher;

    public void prepare() throws Exception {
        ImmutablePlan plan = this.getImmutablePlan();
        if (plan != null) {
            Preconditions.checkArgument((boolean)plan.getDatabaseId().isPresent(), (Object)"Attempted to edit a branched job");
        }
        Collection availableConditions = this.pluginAccessor.getModuleDescriptors((Predicate)new ModuleDescriptorOfClassPredicate(TaskConditionModuleDescriptor.class));
        this.conditions = availableConditions.stream().filter(ModuleDescriptor::isEnabled).map(condition -> Pair.make((Object)condition.getCompleteKey(), (Object)condition.getName())).collect(Collectors.toList());
    }

    @Override
    public String doDefault() {
        ImmutableBuildable build = this.getImmutableBuild();
        if (!PlanClassHelper.isJob((ImmutablePlan)build)) {
            this.addActionError(this.getText("build.error.build.not.exists", Collections.singletonList(this.getPlanKey())));
            return "error";
        }
        return "input";
    }

    @Override
    @NotNull
    public JSONObject getJsonObject() throws JSONException {
        JSONObject result = super.getJsonObject();
        if (this.jsonObject != null) {
            result.put("taskResult", (Object)this.jsonObject);
        }
        return result;
    }

    public List<TaskModuleDescriptor> getAvailableTasks() {
        if (this.availableTasks == null) {
            this.availableTasks = this.taskManager.getAvailableBuildTaskDescriptors();
        }
        return this.availableTasks;
    }

    public List<DecoratedTaskDefinition> getExistingTasks() {
        ImmutableJob job = (ImmutableJob)Narrow.downTo((Object)this.getImmutablePlan(), ImmutableJob.class);
        if (job != null) {
            return this.taskUIConfigBean.getDecoratedTaskDefinitions(job);
        }
        return new ArrayList<DecoratedTaskDefinition>();
    }

    public List<DecoratedTaskDefinition> getFinalisingTasks() {
        ImmutableJob job = (ImmutableJob)Narrow.downTo((Object)this.getImmutablePlan(), ImmutableJob.class);
        if (job != null) {
            return this.taskUIConfigBean.getDecoratedFinalisingTaskDefinitions(job);
        }
        return new ArrayList<DecoratedTaskDefinition>();
    }

    @Override
    public String getAvailableCategoryJson() throws JSONException {
        return this.toJson(TaskCategory.values(), Jsonator.EnumConversionMode.BEAN);
    }

    @Nullable
    protected TaskDefinition getTaskById(@NotNull ImmutablePlan plan, long id) {
        return (TaskDefinition)Iterables.find((Iterable)plan.getBuildDefinition().getTaskDefinitions(), (com.google.common.base.Predicate)BambooPredicates.hasTaskDefinitionEqualId((long)id), null);
    }

    protected Multimap<String, String> getTasksRequirementsConflicts() {
        Collection tasksRequirements = this.taskConfigurationService.getTasksRequirements(PlanKeys.getPlanKey((String)this.getPlanKey()));
        return this.taskUIConfigBean.getTasksRequirementsConflicts(tasksRequirements);
    }

    @NotNull
    public Map<Long, String> getRepositoriesForWorkingDirSelection() {
        ImmutableJob job = (ImmutableJob)Narrow.downTo((Object)this.getImmutableBuild(), ImmutableJob.class);
        if (job != null) {
            return RepositoryConfigHelper.getRepositoriesForWorkingDirSelection((ImmutableJob)job, (VcsRepositoryManager)this.vcsRepositoryManager);
        }
        return new HashMap<Long, String>();
    }

    @NotNull
    public Map<String, String> getWorkingDirSelectorOptions() {
        return ImmutableMap.of((Object)TaskRootDirectoryType.INHERITED.name(), (Object)this.getText("tasks.jobDefined"), (Object)TaskRootDirectoryType.DEFAULT.name(), (Object)this.getText("job.workingDirectory.default"), (Object)TaskRootDirectoryType.REPOSITORY.name(), (Object)this.getText("job.workingDirectory.repositoryDefined"));
    }

    protected TaskRootDirectorySelector getRootDirSelector() {
        TaskRootDirectorySelector rootDirSelector = new TaskRootDirectorySelector();
        rootDirSelector.setTaskRootDirectoryType(this.workingDirSelector);
        rootDirSelector.setRepositoryDefiningWorkingDirectory(this.repositoryDefiningWorkingDirectory);
        return rootDirSelector;
    }

    protected void triggerAnalyticsEvent() {
        this.eventPublisher.publish((Object)new PlanConfigurationChangedAnalyticsEvent());
    }

    public String conditionHtml(String conditionPluginKey) {
        return this.taskUIConfigBean.conditionHtml(conditionPluginKey, this.taskDefinition, (ActionParametersMap)new ActionParametersMapImpl(ActionContext.getContext(), true));
    }

    protected List<TaskConditionConfig> getTaskConditions() {
        return this.taskUIConfigBean.getTaskConditions(this.conditionalTask, this.selectedCondition);
    }

    public void setTaskManager(TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    public void setTemplateRenderer(TemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
    }

    public void setTaskConfigurationService(TaskConfigurationService taskConfigurationService) {
        this.taskConfigurationService = taskConfigurationService;
    }

    public void setTaskUIConfigBean(TaskUIConfigBean taskUIConfigBean) {
        this.taskUIConfigBean = taskUIConfigBean;
    }

    public boolean isSaved() {
        return this.saved;
    }

    public void setSaved(boolean saved) {
        this.saved = saved;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    public String getUserDescription() {
        return this.userDescription;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public void setUserDescription(String userDescription) {
        this.userDescription = userDescription;
    }

    public boolean isTaskDisabled() {
        return this.taskDisabled;
    }

    public void setTaskDisabled(boolean taskDisabled) {
        this.taskDisabled = taskDisabled;
    }

    public boolean isConditionalTask() {
        return this.conditionalTask;
    }

    public void setConditionalTask(boolean conditionalTask) {
        this.conditionalTask = conditionalTask;
    }

    public List<Pair<String, String>> getConditions() {
        return this.conditions;
    }

    public String getSelectedCondition() {
        return this.selectedCondition;
    }

    public void setSelectedCondition(String selectedCondition) {
        this.selectedCondition = selectedCondition;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public long getRepositoryDefiningWorkingDirectory() {
        return this.repositoryDefiningWorkingDirectory;
    }

    public void setRepositoryDefiningWorkingDirectory(long repositoryDefiningWorkingDirectory) {
        this.repositoryDefiningWorkingDirectory = repositoryDefiningWorkingDirectory;
    }

    public String getWorkingDirSelector() {
        return this.workingDirSelector.name();
    }

    public void setWorkingDirSelector(String workingDirSelector) {
        this.workingDirSelector = TaskRootDirectoryType.valueOf((String)workingDirSelector);
    }

    public void setTaskOwnerFactory(TaskOwnerFactory taskOwnerFactory) {
        this.taskOwnerFactory = taskOwnerFactory;
    }
}

