/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build.admin.config.repository;

import com.atlassian.bamboo.configuration.external.helpers.PlanRepositoryValidator;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.ww2.actions.build.admin.config.repository.ConfigureRepository;
import com.atlassian.bamboo.ww2.aware.RssConfigurationAware;
import com.google.common.annotations.VisibleForTesting;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class MoveRepository
extends ConfigureRepository {
    private static final Logger log = Logger.getLogger(MoveRepository.class);
    @Autowired
    private PlanRepositoryValidator planRepositoryValidator;
    private long afterPosition = -1L;
    private long beforePosition = -1L;

    public MoveRepository() {
        this.repositoryId = -1L;
    }

    public void validate() {
        if (this.repositoryId <= 0L) {
            this.addActionError(this.getText("repository.reorder.error.unknown"));
            return;
        }
        if ((this.beforePosition == -1L || this.isMovingPrimaryRepository(this.getImmutablePlan(), this.repositoryId)) && !this.planRepositoryValidator.canChangeDefaultRepository(this.getImmutablePlan())) {
            this.addActionError(this.getText("repository.reorder.error.pr.plan.branches"));
        }
    }

    @VisibleForTesting
    boolean isMovingPrimaryRepository(ImmutablePlan immutablePlan, Long repositoryId) {
        PlanRepositoryDefinition defaultPlanRepositoryDefinition = PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)immutablePlan);
        return defaultPlanRepositoryDefinition != null && defaultPlanRepositoryDefinition.getId() == repositoryId.longValue();
    }

    @RssConfigurationAware
    public String execute() {
        try {
            this.vcsRepositoryConfigurationService.moveRepository(this.getMutablePlan(), this.repositoryId.longValue(), this.beforePosition, this.afterPosition);
            return "success";
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            this.addActionError(e);
            return "error";
        }
    }

    public long getBeforePosition() {
        return this.beforePosition;
    }

    public void setBeforePosition(long beforePosition) {
        this.beforePosition = beforePosition;
    }

    public long getAfterPosition() {
        return this.afterPosition;
    }

    public void setAfterPosition(long afterPosition) {
        this.afterPosition = afterPosition;
    }
}

