/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build.admin.config.repository;

import com.atlassian.bamboo.configuration.repository.VcsUIConfigBean;
import com.atlassian.bamboo.configuration.repository.VcsViewerUIConfigBean;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.branch.ChainBranchManager;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutor;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.service.VcsConfigurationHelper;
import com.atlassian.bamboo.vcs.configuration.service.VcsRepositoryConfigurationComparator;
import com.atlassian.bamboo.ww2.actions.build.admin.config.repository.ConfigureRepository;
import com.atlassian.bamboo.ww2.actions.build.admin.config.task.TaskRenderMode;
import com.atlassian.bamboo.ww2.aware.RssConfigurationAware;
import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class EditRepository
extends ConfigureRepository {
    protected ChainBranchManager chainBranchManager;
    private CachedPlanManager cachedPlanManager;
    private VcsUIConfigBean.VcsTypeSelector currentVcsTypeSelector;
    private VcsUIConfigBean.VcsTypeSelector currentVcsTypeEditSelector;
    private List<VcsViewerUIConfigBean.VcsViewerTypeSelector> currentViewersSelectors;
    @Inject
    private VcsRepositoryConfigurationComparator vcsRepositoryConfigurationComparator;
    private boolean overrideBranch = false;
    private Boolean canBeConvertedToLinkedRepository = null;

    @Override
    public void prepare() throws Exception {
        super.prepare();
        this.currentVcsTypeSelector = this.prepareHtml(TaskRenderMode.SUCCESS);
        this.currentViewersSelectors = this.prepareViewersHtml(TaskRenderMode.SUCCESS);
    }

    public String input() {
        this.validatePlan();
        if (this.repositoryDefinition == null) {
            this.addActionError(this.getText("repository.edit.error.missingConfiguration"));
            return "error";
        }
        if (this.hasErrors()) {
            return "error";
        }
        this.repositoryName = this.repositoryDefinition.getName();
        this.userDescription = this.repositoryDefinition.getDescription();
        this.overrideBranch = this.isDerivedFromLinkedRepository() && this.repositoryDefinition.getBranch() != null;
        return "input";
    }

    @RssConfigurationAware
    public String execute() {
        try {
            if (this.repositoryDefinition.getInheritedData() == null) {
                VariableSubstitutor variableSubstitutor;
                boolean hasBranches;
                VcsRepositoryData oldData = this.repositoryDefinition.getCompleteData();
                this.repositoryDefinition = this.vcsRepositoryConfigurationService.editRepository(this.getMutablePlan(), this.repositoryId.longValue(), this.vcsUIConfigBean.getPartialVcsConfigurationFromActionData(this.vcsRepositoryModuleDescriptor, this.repositoryName, StringUtils.defaultString((String)this.userDescription, (String)""), this.repositoryDefinition, VcsConfigurationHelper.OVERRIDE_ALL));
                if (this.defaultRepositoryIsBeingChanged() && (hasBranches = this.cachedPlanManager.getBranchesOfChain(this.getImmutablePlan().getPlanKey()).findAny().isPresent()) && !this.vcsRepositoryConfigurationComparator.isTheSameVcsLocation(this.vcsRepositoryModuleDescriptor, variableSubstitutor = this.customVariableContext.getVariableSubstitutorFactory().newSubstitutorForPlan(this.getImmutablePlan()), oldData, this.repositoryDefinition.getCompleteData())) {
                    this.addActionWarning(this.getText("repository.edit.warning.invalidatingBranches"));
                }
            } else if (this.overrideBranch) {
                this.repositoryDefinition = this.vcsRepositoryConfigurationService.editRepository(this.getMutablePlan(), this.repositoryId.longValue(), this.vcsUIConfigBean.getPartialVcsConfigurationFromActionData(this.vcsRepositoryModuleDescriptor, this.repositoryName, StringUtils.defaultString((String)this.userDescription, (String)""), this.repositoryDefinition, EnumSet.of(VcsConfigurationHelper.Overrides.BRANCH)));
            } else if (this.repositoryDefinition.getBranch() != null) {
                this.repositoryDefinition = this.vcsRepositoryConfigurationService.editRepository(this.getMutablePlan(), this.repositoryId.longValue(), this.vcsUIConfigBean.getPartialVcsConfigurationFromActionData(this.vcsRepositoryModuleDescriptor, this.repositoryName, StringUtils.defaultString((String)this.userDescription, (String)""), this.repositoryDefinition, VcsConfigurationHelper.OVERRIDE_NOTHING));
            }
        }
        catch (Exception e) {
            this.addActionError(e);
            return "error";
        }
        this.triggerAnalyticsEvent();
        return "success";
    }

    private boolean defaultRepositoryIsBeingChanged() {
        return PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)this.getImmutablePlan()).getId() == this.repositoryId.longValue();
    }

    public void validate() {
        this.validatePlan();
        if (this.repositoryDefinition == null) {
            this.addActionError(this.getText("repository.edit.error.incorrectId", Lists.newArrayList((Object[])new Long[]{this.repositoryId})));
        }
        this.validateRepositoryConfiguration(this.overrideBranch);
        if (this.hasErrors()) {
            this.currentVcsTypeSelector = this.prepareHtml(TaskRenderMode.ERROR);
            this.currentViewersSelectors = this.prepareViewersHtml(TaskRenderMode.ERROR);
        }
    }

    private VcsUIConfigBean.VcsTypeSelector prepareHtml(@NotNull TaskRenderMode renderMode) {
        Long projectId = this.getProject() != null ? Long.valueOf(this.getProject().getId()) : null;
        return (VcsUIConfigBean.VcsTypeSelector)this.customVariableContext.withVariableSubstitutor(this.customVariableContext.getVariableSubstitutorFactory().newSubstitutorForPlan(this.getImmutablePlan()), () -> {
            String globalGroup = this.getText("repository.type.shared");
            if (this.isDerivedFromLinkedRepository()) {
                boolean hasReadPermission = this.hasEntityPermission(BambooPermission.READ.getName(), this.repositoryDefinition.getInheritedData());
                this.currentVcsTypeEditSelector = new VcsUIConfigBean.VcsTypeSelector(this.repositoryDefinition, this.vcsRepositoryModuleDescriptor, globalGroup, this.vcsUIConfigBean.prepareEditHtmlFragments(this.vcsRepositoryModuleDescriptor, this.repositoryDefinition, renderMode, projectId), hasReadPermission);
                VcsUIConfigBean.VcsTypeSelector viewSelector = new VcsUIConfigBean.VcsTypeSelector(this.repositoryDefinition, this.vcsRepositoryModuleDescriptor, globalGroup, this.vcsUIConfigBean.prepareViewHtmlFragments(this.vcsRepositoryModuleDescriptor, this.repositoryDefinition.getInheritedData(), projectId), hasReadPermission);
                return viewSelector;
            }
            this.currentVcsTypeEditSelector = new VcsUIConfigBean.VcsTypeSelector(this.vcsRepositoryModuleDescriptor, this.vcsUIConfigBean.prepareEditHtmlFragments(this.vcsRepositoryModuleDescriptor, this.repositoryDefinition, renderMode, projectId));
            return this.currentVcsTypeEditSelector;
        });
    }

    public String getSubmitAction() {
        return "updateRepository";
    }

    public VcsUIConfigBean.VcsTypeSelector getCurrentVcsTypeSelector() {
        return this.currentVcsTypeSelector;
    }

    public VcsUIConfigBean.VcsTypeSelector getCurrentVcsTypeEditSelector() {
        return this.currentVcsTypeEditSelector;
    }

    public boolean getCanBeConvertedToLinkedRepository() {
        if (this.canBeConvertedToLinkedRepository == null) {
            this.canBeConvertedToLinkedRepository = this.vcsRepositoryConfigurationService.getProjectSharedCredentialsForRepository(this.repositoryDefinition).isEmpty();
        }
        return this.canBeConvertedToLinkedRepository;
    }

    private List<VcsViewerUIConfigBean.VcsViewerTypeSelector> prepareViewersHtml(@NotNull TaskRenderMode renderMode) {
        return this.vcsViewerUIConfigBean.getViewerOptionsForRepositoryType(this.currentVcsTypeSelector.getKey(), this.repositoryDefinition.getViewerConfiguration(), renderMode);
    }

    public List<VcsViewerUIConfigBean.VcsViewerTypeSelector> getViewerSelectors() {
        return this.currentViewersSelectors;
    }

    public void setChainBranchManager(ChainBranchManager chainBranchManager) {
        this.chainBranchManager = chainBranchManager;
    }

    @Override
    public void setCachedPlanManager(CachedPlanManager cachedPlanManager) {
        this.cachedPlanManager = cachedPlanManager;
    }

    public boolean isOverrideBranch() {
        return this.overrideBranch;
    }

    public void setOverrideBranch(boolean overrideBranch) {
        this.overrideBranch = overrideBranch;
    }
}

