/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build.admin.config.repository;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskManager;
import com.atlassian.bamboo.task.TaskModuleDescriptor;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.ww2.actions.build.admin.config.repository.ConfigureRepository;
import com.atlassian.bamboo.ww2.actions.build.admin.create.RepositoryOption;
import com.atlassian.bamboo.ww2.aware.RssConfigurationAware;
import com.google.common.collect.Lists;
import com.opensymphony.xwork2.Preparable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class DeleteRepository
extends ConfigureRepository
implements Preparable {
    private String replaceRepository = "0";
    private TaskManager taskManager;

    @Override
    public void prepare() throws Exception {
        ImmutablePlan plan = this.getImmutablePlan();
        if (plan == null) {
            this.addActionError(this.getText("repository.add.error.noPlan"));
            return;
        }
        this.repositoryDefinition = this.getRepositoryById(this.repositoryId);
        if (this.repositoryDefinition == null) {
            this.addActionError(this.getText("repository.delete.error", Lists.newArrayList((Object[])new Long[]{this.repositoryId})));
            return;
        }
        this.repositoryName = this.repositoryDefinition.getName();
    }

    public String delete() {
        if (this.hasActionErrors()) {
            return "error";
        }
        return "input";
    }

    @RssConfigurationAware
    public String execute() {
        try {
            long replacementRepositoryId = Long.parseLong(this.replaceRepository);
            this.vcsRepositoryConfigurationService.deleteRepository(this.getMutablePlan(), this.repositoryId.longValue(), Long.valueOf(replacementRepositoryId));
            this.triggerAnalyticsEvent();
            return "success";
        }
        catch (Exception e) {
            this.addActionError(e);
            return "error";
        }
    }

    public Map<ImmutableJob, List<TaskDefinition>> getRelevantJobsUsingRepository() {
        return this.vcsRepositoryConfigurationService.getRelevantJobsForRepositoryIdChange(this.getImmutablePlan(), this.repositoryId.longValue());
    }

    public String getTaskName(TaskDefinition taskDefinition) {
        if (StringUtils.isBlank((CharSequence)taskDefinition.getUserDescription())) {
            TaskModuleDescriptor taskDescriptor = this.taskManager.getTaskDescriptor(taskDefinition.getPluginKey());
            if (taskDescriptor != null) {
                return taskDescriptor.getName();
            }
            return "";
        }
        return taskDefinition.getUserDescription();
    }

    public Integer getTasksCount(Map<Job, List<TaskDefinition>> tasks) {
        int size = 0;
        for (List<TaskDefinition> taskDefinitions : tasks.values()) {
            size += taskDefinitions.size();
        }
        return size;
    }

    public List<RepositoryOption> getAvailableRepositories() {
        ImmutableChain chain = (ImmutableChain)Narrow.to((Object)this.getImmutablePlan(), ImmutableChain.class);
        if (chain != null) {
            RepositoryOption deleteRepositoryOption = new RepositoryOption(this.getText("repository.delete.no.replacement"), "");
            Stream<RepositoryOption> otherRepositoriesDefinedInChainAsOptions = chain.getPlanRepositoryDefinitions().stream().filter(repositoryDefinition -> repositoryDefinition.getId() != this.repositoryId.longValue()).map(repositoryDefinition -> new RepositoryOption((VcsRepositoryData)repositoryDefinition, "", false));
            return Stream.concat(Stream.of(deleteRepositoryOption), otherRepositoriesDefinedInChainAsOptions).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public String getReplaceRepository() {
        return this.replaceRepository;
    }

    public void setReplaceRepository(String replaceRepository) {
        this.replaceRepository = replaceRepository;
    }

    public void setTaskManager(TaskManager taskManager) {
        this.taskManager = taskManager;
    }
}

