/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build.admin.config.repository;

import com.atlassian.bamboo.configuration.repository.VcsUIConfigBean;
import com.atlassian.bamboo.configuration.repository.VcsViewerUIConfigBean;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.vcs.configuration.service.VcsConfigurationHelper;
import com.atlassian.bamboo.ww2.actions.build.admin.config.repository.ConfigureRepository;
import com.atlassian.bamboo.ww2.actions.build.admin.config.task.TaskRenderMode;
import com.atlassian.bamboo.ww2.aware.RssConfigurationAware;
import java.util.EnumSet;
import java.util.List;
import org.acegisecurity.acls.Permission;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;

public class CreateRepository
extends ConfigureRepository {
    private VcsUIConfigBean.VcsTypeSelector currentVcsTypeSelector;
    private VcsUIConfigBean.VcsTypeSelector currentVcsTypeEditSelector;
    private List<VcsViewerUIConfigBean.VcsViewerTypeSelector> currentViewersSelectors;
    private boolean overrideBranch = false;

    @Override
    public void prepare() throws Exception {
        String keyString = this.getBuildConfiguration().getString(this.SELECTED_REPOSITORY);
        if (NumberUtils.isCreatable((String)keyString)) {
            this.repositoryId = Long.parseLong(keyString);
        }
        super.prepare();
        this.currentVcsTypeSelector = this.prepareHtml(TaskRenderMode.SUCCESS);
        this.currentViewersSelectors = this.prepareViewersHtml(TaskRenderMode.SUCCESS);
    }

    public String input() throws Exception {
        this.validatePlan();
        if (this.hasErrors()) {
            return "error";
        }
        return "input";
    }

    @RssConfigurationAware
    public String execute() {
        try {
            String selectedRepository = this.getBuildConfiguration().getString(this.SELECTED_REPOSITORY);
            if (NumberUtils.isCreatable((String)selectedRepository)) {
                long selectedRepositoryId = Long.parseLong(selectedRepository);
                this.repositoryDefinition = this.vcsRepositoryConfigurationService.linkRepositoryToPlan(this.getMutablePlan(), selectedRepositoryId);
                if (this.overrideBranch) {
                    this.repositoryDefinition = this.vcsRepositoryConfigurationService.editRepository(this.getMutablePlan(), this.repositoryDefinition.getId(), this.vcsUIConfigBean.getPartialVcsConfigurationFromActionData(this.vcsRepositoryModuleDescriptor, this.repositoryName, StringUtils.defaultString((String)this.userDescription, (String)""), this.repositoryDefinition, EnumSet.of(VcsConfigurationHelper.Overrides.BRANCH)));
                }
            } else {
                this.repositoryDefinition = this.vcsRepositoryConfigurationService.createPlanRepository(this.getMutablePlan(), this.vcsUIConfigBean.getPartialVcsConfigurationFromActionData(this.vcsRepositoryModuleDescriptor, this.repositoryName, this.userDescription, null, VcsConfigurationHelper.OVERRIDE_ALL));
            }
        }
        catch (IllegalArgumentException e) {
            this.addActionError(e);
            return "error";
        }
        this.triggerAnalyticsEvent();
        return "success";
    }

    public void validate() {
        this.validatePlan();
        this.validateRepositoryConfiguration(this.overrideBranch);
        if (!NumberUtils.isCreatable((String)this.selectedRepository) && !this.hasGlobalPermission((Permission)BambooPermission.CREATE_REPOSITORY)) {
            this.addActionError(this.getText("repository.add.no.permission"));
        }
        if (this.hasErrors()) {
            this.currentVcsTypeSelector = this.prepareHtml(TaskRenderMode.ERROR);
            this.currentViewersSelectors = this.prepareViewersHtml(TaskRenderMode.ERROR);
        }
    }

    private VcsUIConfigBean.VcsTypeSelector prepareHtml(@NotNull TaskRenderMode renderMode) {
        Long projectId;
        String globalGroup = this.getText("repository.type.shared");
        String keyString = this.getBuildConfiguration().getString(this.SELECTED_REPOSITORY);
        Long l = projectId = this.getProject() != null ? Long.valueOf(this.getProject().getId()) : null;
        if (NumberUtils.isCreatable((String)keyString)) {
            boolean hasReadPermission = this.hasEntityPermission(BambooPermission.READ.getName(), this.repositoryDefinition);
            this.currentVcsTypeEditSelector = new VcsUIConfigBean.VcsTypeSelector(this.repositoryDefinition, this.vcsRepositoryModuleDescriptor, globalGroup, this.vcsUIConfigBean.prepareEditHtmlFragments(this.vcsRepositoryModuleDescriptor, this.repositoryDefinition, renderMode, projectId), hasReadPermission);
            VcsUIConfigBean.VcsTypeSelector viewSelector = new VcsUIConfigBean.VcsTypeSelector(this.repositoryDefinition, this.vcsRepositoryModuleDescriptor, globalGroup, this.vcsUIConfigBean.prepareViewHtmlFragments(this.vcsRepositoryModuleDescriptor, this.repositoryDefinition.getCompleteData(), projectId), hasReadPermission);
            return viewSelector;
        }
        this.currentVcsTypeEditSelector = new VcsUIConfigBean.VcsTypeSelector(this.vcsRepositoryModuleDescriptor, this.vcsUIConfigBean.prepareCreateHtmlFragments(this.vcsRepositoryModuleDescriptor, renderMode, projectId));
        return this.currentVcsTypeEditSelector;
    }

    public VcsUIConfigBean.VcsTypeSelector getCurrentVcsTypeSelector() {
        return this.currentVcsTypeSelector;
    }

    public VcsUIConfigBean.VcsTypeSelector getCurrentVcsTypeEditSelector() {
        return this.currentVcsTypeEditSelector;
    }

    private List<VcsViewerUIConfigBean.VcsViewerTypeSelector> prepareViewersHtml(@NotNull TaskRenderMode renderMode) {
        return this.vcsViewerUIConfigBean.getViewerOptionsForRepositoryType(this.currentVcsTypeSelector.getKey(), renderMode);
    }

    public List<VcsViewerUIConfigBean.VcsViewerTypeSelector> getViewerSelectors() {
        return this.currentViewersSelectors;
    }

    public String getSubmitAction() {
        return "createRepository";
    }

    public boolean isOverrideBranch() {
        return this.overrideBranch;
    }

    public void setOverrideBranch(boolean overrideBranch) {
        this.overrideBranch = overrideBranch;
    }
}

